package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolCategoryStatusBuilder extends V1alpha1ToolCategoryStatusFluentImpl<V1alpha1ToolCategoryStatusBuilder> implements VisitableBuilder<V1alpha1ToolCategoryStatus,V1alpha1ToolCategoryStatusBuilder>{

    V1alpha1ToolCategoryStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolCategoryStatusBuilder(){
            this(true);
    }
    public V1alpha1ToolCategoryStatusBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolCategoryStatus(), validationEnabled);
    }
    public V1alpha1ToolCategoryStatusBuilder(V1alpha1ToolCategoryStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolCategoryStatusBuilder(V1alpha1ToolCategoryStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolCategoryStatus(), validationEnabled);
    }
    public V1alpha1ToolCategoryStatusBuilder(V1alpha1ToolCategoryStatusFluent<?> fluent,V1alpha1ToolCategoryStatus instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolCategoryStatusBuilder(V1alpha1ToolCategoryStatusFluent<?> fluent,V1alpha1ToolCategoryStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPhase(instance.getPhase());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolCategoryStatusBuilder(V1alpha1ToolCategoryStatus instance){
            this(instance,true);
    }
    public V1alpha1ToolCategoryStatusBuilder(V1alpha1ToolCategoryStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPhase(instance.getPhase());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolCategoryStatus build(){
            V1alpha1ToolCategoryStatus buildable = new V1alpha1ToolCategoryStatus();
            buildable.setPhase(fluent.getPhase());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolCategoryStatusBuilder that = (V1alpha1ToolCategoryStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
