/*
 * Decompiled with CFR 0.152.
 */
package io.bindingz.api.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.bindingz.api.annotations.Contract;
import io.bindingz.api.client.SchemaService;
import io.bindingz.api.client.SchemaServiceFactory;
import io.bindingz.api.model.ContractDto;
import io.bindingz.api.model.ContractSchema;
import io.bindingz.api.model.JsonSchemaSpec;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;

public class ContractService {
    private final List<ClassLoader> classLoaders;
    private final SchemaServiceFactory schemaServiceFactory;

    public ContractService(ClassLoader ... classLoaders) {
        this(Arrays.asList(classLoaders));
    }

    public ContractService(List<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
        this.schemaServiceFactory = new SchemaServiceFactory(classLoaders);
    }

    public Collection<ContractDto> create(String ... packageNames) throws IOException {
        return this.create(Arrays.asList(packageNames));
    }

    public Collection<ContractDto> create(List<String> packageNames) throws IOException {
        Reflections reflections = new Reflections((Configuration)ConfigurationBuilder.build((Object[])new Object[0]).addScanners(new Scanner[]{new TypeAnnotationsScanner()}).forPackages(packageNames.toArray(new String[0])).addClassLoaders(this.classLoaders));
        Set contractClasses = reflections.getTypesAnnotatedWith(Contract.class);
        return contractClasses.stream().map(clazz -> this.createResource((Class)clazz)).collect(Collectors.toList());
    }

    private ContractDto createResource(Class contract) {
        SchemaService schemaService = this.schemaServiceFactory.getSchemaService(contract);
        Map<JsonSchemaSpec, JsonNode> schemas = schemaService.createSchemas(contract);
        Contract owner = contract.getAnnotation(Contract.class);
        return new ContractDto(owner.namespace(), owner.owner(), owner.contractName(), owner.version(), new ContractSchema(schemas));
    }
}

