/*
 * Decompiled with CFR 0.152.
 */
package io.bindingz.api.client.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.kjetland.jackson.jsonSchema.JsonSchemaConfig;
import com.kjetland.jackson.jsonSchema.JsonSchemaDraft;
import com.kjetland.jackson.jsonSchema.JsonSchemaGenerator;
import io.bindingz.api.annotations.jackson.ConfigurationFactory;
import io.bindingz.api.annotations.jackson.JacksonConfiguration;
import io.bindingz.api.client.SchemaService;
import io.bindingz.api.model.JsonSchemaSpec;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;

public class JacksonSchemaService
implements SchemaService {
    private final JsonSchemaGenerator generator;

    public JacksonSchemaService(List<ClassLoader> classLoaders) {
        this.generator = this.createDefaultGenerator(classLoaders);
    }

    public JacksonSchemaService(List<ClassLoader> classLoaders, JacksonConfiguration configuration) {
        if (!configuration.factory().equals(ConfigurationFactory.class)) {
            try {
                ConfigurationFactory factory = (ConfigurationFactory)configuration.factory().getConstructor(new Class[0]).newInstance(new Object[0]);
                this.generator = new JsonSchemaGenerator(factory.createObjectMapper(), this.createConfig(factory.customTypeMappings()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create ConfigurationFactory");
            }
        } else {
            this.generator = this.createDefaultGenerator(classLoaders);
        }
    }

    @Override
    public Map<JsonSchemaSpec, JsonNode> createSchemas(Class contract) {
        HashMap<JsonSchemaSpec, JsonNode> schemas = new HashMap<JsonSchemaSpec, JsonNode>();
        schemas.put(JsonSchemaSpec.DRAFT_04, this.generator.generateJsonSchema(contract));
        return schemas;
    }

    private JsonSchemaGenerator createDefaultGenerator(List<ClassLoader> classLoaders) {
        HashMap<String, String> typeMappings = new HashMap<String, String>();
        typeMappings.put("java.time.LocalDateTime", "datetime-local");
        typeMappings.put("java.time.OffsetDateTime", "datetime");
        typeMappings.put("java.time.LocalDate", "date");
        typeMappings.put("org.joda.time.LocalDate", "date");
        return new JsonSchemaGenerator(this.createDefaultObjectMapper(classLoaders), this.createConfig(typeMappings));
    }

    private JsonSchemaConfig createConfig(Map<String, String> customTypesToFormats) {
        JsonSchemaConfig config = JsonSchemaConfig.create((boolean)false, Optional.empty(), (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, customTypesToFormats, (boolean)false, new HashSet<Class>(Arrays.asList(scala.collection.immutable.Set.class, scala.collection.mutable.Set.class, Set.class)), Collections.emptyMap(), Collections.emptyMap(), null, (boolean)true, null);
        return config.withJsonSchemaDraft(this.version(JsonSchemaSpec.DRAFT_04));
    }

    private ObjectMapper createDefaultObjectMapper(List<ClassLoader> classLoaders) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        String[] packages = Arrays.stream(Package.getPackages()).map(aPackage -> aPackage.getName().split("\\.")[0]).collect(Collectors.toSet()).toArray(new String[0]);
        Reflections reflections = new Reflections((Configuration)ConfigurationBuilder.build((Object[])new Object[0]).addClassLoaders(classLoaders).forPackages(packages).addScanners(new Scanner[]{new SubTypesScanner()}));
        Set modules = reflections.getSubTypesOf(Module.class);
        for (Class moduleClass : modules) {
            try {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = moduleClass.getConstructors()) {
                    if (constructor.getParameterCount() != 0) continue;
                    Module module = (Module)constructor.newInstance(new Object[0]);
                    mapper.registerModule(module);
                    System.out.println("Registered module " + moduleClass);
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return mapper;
    }

    private JsonSchemaDraft version(JsonSchemaSpec spec) {
        return JsonSchemaDraft.valueOf((String)spec.name());
    }
}

