package io.bitsensor.plugins.java.sql.handler;

import io.bitsensor.lib.entity.proto.Invocation.SQLInvocation;
import io.bitsensor.plugins.java.core.BitSensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

@Component
public class ResultSetHandler implements SQLHandler {

    private static final Logger logger = LoggerFactory.getLogger(ResultSetHandler.class);

    @Override
    public void handle(Statement statement, SQLInvocation.Builder builder) {
        try {
            if (statement.getResultSet() != null) {
                if (statement.getResultSetType() == ResultSet.TYPE_FORWARD_ONLY) {
                    logger.warn("Unable to handle ResultSet for BitSensor because this ResultSet is FORWARD_ONLY.");
                } else {
                    ResultSet rs = statement.getResultSet();

                    // saves row id to restore cursor later
                    int savedRow = rs.getRow();
                    rs.last();

                    SQLInvocation newSqlInvocation = builder
                            .putEndpoint("hits", String.valueOf(rs.getRow()))
                            .build();
                    BitSensor.apply(b -> BitSensor.addSQLInvocation(newSqlInvocation));

                    // resets cursor to previous cursor place
                    rs.absolute(savedRow);
                    return;
                }
            }
            BitSensor.apply(b -> BitSensor.addSQLInvocation(builder.build()));
        } catch (SQLException e) {
            logger.warn("Unable to handle ResultSet for BitSensor.", e);
        }
    }

    @Override
    public ExecutionMoment getExecutionMoment() {
        return ExecutionMoment.POST_HANDLE;
    }
}
