/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.api;

import io.elastic.api.Component;
import io.elastic.api.EventEmitter;
import io.elastic.api.ExecutionParameters;
import java.lang.reflect.Constructor;

public final class Executor {
    private String componentClassName;
    private EventEmitter eventEmitter;

    public Executor(String componentClassName, EventEmitter eventEmitter) {
        this.componentClassName = componentClassName;
        this.eventEmitter = eventEmitter;
    }

    public void execute(ExecutionParameters parameters) {
        if (parameters == null) {
            this.eventEmitter.emitException(new IllegalArgumentException("ExecutionParameters is required. Please pass a parameters object to Executor.execute(parameters)"));
            return;
        }
        try {
            this.newComponent().execute(parameters);
        }
        catch (Exception e) {
            this.eventEmitter.emitException(e);
        }
    }

    private Component newComponent() throws Exception {
        Class<?> clazz = Class.forName(this.componentClassName);
        Constructor<?> constructor = clazz.getDeclaredConstructor(EventEmitter.class);
        return (Component)clazz.cast(constructor.newInstance(this.eventEmitter));
    }
}

