/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.api;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.Serializable;

public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    private JsonObject body;
    private JsonObject attachments;

    private Message(JsonObject body, JsonObject attachments) {
        if (body == null) {
            throw new IllegalArgumentException("Message body must not be null");
        }
        if (attachments == null) {
            throw new IllegalStateException("Attachments must not be null");
        }
        this.body = body;
        this.attachments = attachments;
    }

    public JsonObject getBody() {
        return this.body;
    }

    public JsonObject getAttachments() {
        return this.attachments;
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public static final class Builder {
        private JsonObject body = new JsonObject();
        private JsonObject attachments = new JsonObject();

        public Builder body(JsonObject body) {
            this.body = body;
            return this;
        }

        public Builder attachments(JsonObject attachments) {
            this.attachments = attachments;
            return this;
        }

        public Message build() {
            return new Message(this.body, this.attachments);
        }
    }
}

