/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.api;

import com.google.gson.JsonObject;
import io.elastic.api.Message;

public final class EventEmitter {
    private Callback errorCallback;
    private Callback dataCallback;
    private Callback snapshotCallback;

    private EventEmitter(Callback errorCallback, Callback dataCallback, Callback snapshotCallback) {
        this.errorCallback = errorCallback;
        this.dataCallback = dataCallback;
        this.snapshotCallback = snapshotCallback;
    }

    EventEmitter emitException(Exception e) {
        return this.emit(this.errorCallback, e);
    }

    public EventEmitter emitData(Message message) {
        return this.emit(this.dataCallback, message);
    }

    public EventEmitter emitSnapshot(JsonObject snapshot) {
        return this.emit(this.snapshotCallback, snapshot);
    }

    private EventEmitter emit(Callback callback, Object value) {
        callback.receive(value);
        return this;
    }

    public static final class Builder {
        private Callback errorCallback;
        private Callback dataCallback;
        private Callback snapshotCallback;

        public Builder onError(Callback callback) {
            this.errorCallback = callback;
            return this;
        }

        public Builder onData(Callback callback) {
            this.dataCallback = callback;
            return this;
        }

        public Builder onSnapshot(Callback callback) {
            this.snapshotCallback = callback;
            return this;
        }

        public EventEmitter build() {
            if (this.errorCallback == null) {
                throw new IllegalStateException("'onError' callback is required");
            }
            if (this.dataCallback == null) {
                throw new IllegalStateException("'onData' callback is required");
            }
            if (this.snapshotCallback == null) {
                throw new IllegalStateException("'onSnapshot' callback is required");
            }
            return new EventEmitter(this.errorCallback, this.dataCallback, this.snapshotCallback);
        }
    }

    public static interface Callback {
        public void receive(Object var1);
    }
}

