/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.api;

import io.elastic.api.Component;
import io.elastic.api.EventEmitter;
import io.elastic.api.ExecutionParameters;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Executor {
    private static final Logger logger = LoggerFactory.getLogger(Executor.class);
    private String componentClassName;
    private EventEmitter eventEmitter;

    public Executor(String componentClassName, EventEmitter eventEmitter) {
        this.componentClassName = componentClassName;
        this.eventEmitter = eventEmitter;
    }

    public void execute(ExecutionParameters parameters) {
        if (parameters == null) {
            IllegalArgumentException exception = new IllegalArgumentException("ExecutionParameters is required. Please pass a parameters object to Executor.execute(parameters)");
            logger.error(exception.getMessage());
            this.eventEmitter.emitException(exception);
            return;
        }
        try {
            this.newComponent().execute(parameters);
        }
        catch (Exception e) {
            logger.error("Component execution failed", (Throwable)e);
            this.eventEmitter.emitException(e);
        }
    }

    private Component newComponent() throws Exception {
        logger.info("Instantiating component {}", (Object)this.componentClassName);
        Class<?> clazz = Class.forName(this.componentClassName);
        Constructor<?> constructor = clazz.getDeclaredConstructor(EventEmitter.class);
        return (Component)clazz.cast(constructor.newInstance(this.eventEmitter));
    }
}

