/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.api;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UUID id;
    private JsonObject headers;
    private JsonObject body;
    private JsonObject attachments;

    private Message(UUID id, JsonObject headers, JsonObject body, JsonObject attachments) {
        if (id == null) {
            throw new IllegalArgumentException("Message id must not be null");
        }
        if (headers == null) {
            throw new IllegalArgumentException("Message headers must not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("Message body must not be null");
        }
        if (attachments == null) {
            throw new IllegalArgumentException("Message attachments must not be null");
        }
        this.id = id;
        this.headers = headers;
        this.body = body;
        this.attachments = attachments;
    }

    public UUID getId() {
        return this.id;
    }

    public JsonObject getHeaders() {
        return this.headers;
    }

    public JsonObject getBody() {
        return this.body;
    }

    public JsonObject getAttachments() {
        return this.attachments;
    }

    public String toString() {
        JsonObject json = Json.createObjectBuilder().add("id", this.id.toString()).add("headers", (JsonValue)this.headers).add("body", (JsonValue)this.body).add("attachments", (JsonValue)this.attachments).build();
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)writer);
        jsonWriter.writeObject(json);
        jsonWriter.close();
        return writer.toString();
    }

    public static final class Builder {
        private UUID id = UUID.randomUUID();
        private JsonObject headers = Json.createObjectBuilder().build();
        private JsonObject body = Json.createObjectBuilder().build();
        private JsonObject attachments = Json.createObjectBuilder().build();

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder headers(JsonObject headers) {
            this.headers = headers;
            return this;
        }

        public Builder body(JsonObject body) {
            this.body = body;
            return this;
        }

        public Builder attachments(JsonObject attachments) {
            this.attachments = attachments;
            return this;
        }

        public Message build() {
            return new Message(this.id, this.headers, this.body, this.attachments);
        }
    }
}

