/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonWriter;

public final class JSON {
    private JSON() {
    }

    public static JsonObject parseObject(String input) {
        JsonReader reader = JSON.createReader(input);
        if (reader == null) {
            return null;
        }
        try {
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
        finally {
            reader.close();
        }
    }

    public static JsonArray parseArray(String input) {
        JsonReader reader = JSON.createReader(input);
        if (reader == null) {
            return null;
        }
        try {
            JsonArray jsonArray = reader.readArray();
            return jsonArray;
        }
        finally {
            reader.close();
        }
    }

    private static <T> JsonReader createReader(String input) {
        if (input == null) {
            return null;
        }
        JsonReader reader = Json.createReader((InputStream)new ByteArrayInputStream(input.getBytes()));
        return reader;
    }

    public static String stringify(JsonObject object) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)writer);
        jsonWriter.writeObject(object);
        jsonWriter.close();
        return writer.toString();
    }
}

