/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.api;

import io.elastic.api.EventEmitter;
import io.elastic.api.Message;
import java.io.Serializable;
import javax.json.Json;
import javax.json.JsonObject;

public final class ExecutionParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Message message;
    private final JsonObject configuration;
    private final JsonObject snapshot;
    private final EventEmitter eventEmitter;

    private ExecutionParameters(Message message, EventEmitter eventEmitter, JsonObject configuration, JsonObject snapshot) {
        this.message = message;
        this.configuration = configuration;
        this.snapshot = snapshot;
        this.eventEmitter = eventEmitter;
    }

    public Message getMessage() {
        return this.message;
    }

    public JsonObject getConfiguration() {
        return this.configuration;
    }

    public JsonObject getSnapshot() {
        return this.snapshot;
    }

    public EventEmitter getEventEmitter() {
        return this.eventEmitter;
    }

    public String toString() {
        return "ExecutionParameters{message=" + this.message + ", configuration=" + this.configuration + ", snapshot=" + this.snapshot + ", eventEmitter=" + this.eventEmitter + '}';
    }

    public static final class Builder {
        private final Message message;
        private JsonObject configuration;
        private JsonObject snapshot;
        private EventEmitter eventEmitter;

        public Builder(Message message, EventEmitter eventEmitter) {
            if (message == null) {
                throw new IllegalArgumentException("Message is required");
            }
            if (eventEmitter == null) {
                throw new IllegalArgumentException("EventEmitter is required");
            }
            this.message = message;
            this.eventEmitter = eventEmitter;
            this.configuration = Json.createObjectBuilder().build();
            this.snapshot = Json.createObjectBuilder().build();
        }

        public Builder configuration(JsonObject configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder snapshot(JsonObject snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public ExecutionParameters build() {
            if (this.configuration == null) {
                throw new IllegalStateException("Configuration may not be null");
            }
            if (this.snapshot == null) {
                throw new IllegalStateException("Snapshot may not be null");
            }
            return new ExecutionParameters(this.message, this.eventEmitter, this.configuration, this.snapshot);
        }
    }
}

