/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.Buildable;
import io.fusionauth.http.util.DateTools;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Cookie
implements Buildable<Cookie> {
    public String domain;
    public ZonedDateTime expires;
    public boolean httpOnly;
    public Long maxAge;
    public String name;
    public String path;
    public SameSite sameSite;
    public boolean secure;
    public String value;

    public Cookie() {
    }

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Cookie(Cookie other) {
        if (other == null) {
            return;
        }
        this.domain = other.domain;
        this.expires = other.expires;
        this.httpOnly = other.httpOnly;
        this.maxAge = other.maxAge;
        this.name = other.name;
        this.path = other.path;
        this.sameSite = other.sameSite;
        this.secure = other.secure;
        this.value = other.value;
    }

    public static List<Cookie> fromRequestHeader(String header) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        boolean inName = false;
        boolean inValue = false;
        char[] chars = header.toCharArray();
        int start = 0;
        String name = null;
        String value = null;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!(inName || inValue || !Character.isWhitespace(c) && c != ';')) {
                ++start;
                continue;
            }
            if (c == '=' && inName) {
                name = new String(chars, start, i - start);
                value = "";
                inValue = true;
                inName = false;
                start = i + 1;
                continue;
            }
            if (c == ';' && inValue) {
                value = new String(chars, start, i - start);
                if (name.trim().length() > 0 && value.trim().length() > 0) {
                    cookies.add(new Cookie(name, value));
                }
                inValue = false;
                name = null;
                value = null;
                start = 0;
                continue;
            }
            if (inName || inValue) continue;
            inName = true;
            start = i;
        }
        if (inName && start > 0) {
            name = header.substring(start);
        }
        if (inValue && start > 0) {
            value = header.substring(start);
        }
        if (name != null && value != null && name.trim().length() > 0 && value.trim().length() > 0) {
            cookies.add(new Cookie(name, value));
        }
        return cookies;
    }

    public static Cookie fromResponseHeader(String header) {
        Cookie cookie = new Cookie();
        boolean inName = false;
        boolean inValue = false;
        boolean inAttributes = false;
        char[] chars = header.toCharArray();
        int start = 0;
        String name = null;
        String value = null;
        for (int i = 0; i < header.length(); ++i) {
            char c = chars[i];
            if (!(inName || inValue || !Character.isWhitespace(c) && c != ';')) {
                ++start;
                continue;
            }
            if (c == '=' && inName) {
                name = header.substring(start, i);
                if (!inAttributes && name.trim().length() == 0) {
                    return null;
                }
                value = "";
                inValue = true;
                inName = false;
                start = i + 1;
                continue;
            }
            if (c == ';') {
                if (inName) {
                    if (!inAttributes) {
                        return null;
                    }
                    name = header.substring(start, i);
                    value = null;
                } else {
                    value = header.substring(start, i);
                }
                if (inAttributes) {
                    cookie.addAttribute(name, value);
                } else {
                    cookie.name = name;
                    cookie.value = value;
                }
                inName = false;
                inValue = false;
                inAttributes = true;
                name = null;
                value = null;
                continue;
            }
            if (inName || inValue) continue;
            inName = true;
            start = i;
        }
        if (inName && start > 0) {
            name = header.substring(start);
        }
        if (inValue && start > 0) {
            value = header.substring(start);
        }
        if (inAttributes) {
            cookie.addAttribute(name, value);
        } else {
            if (name == null || value == null || name.trim().length() == 0) {
                return null;
            }
            cookie.name = name;
            cookie.value = value;
        }
        return cookie;
    }

    public void addAttribute(String name, String value) {
        switch (name.toLowerCase()) {
            case "domain": {
                this.domain = value;
                break;
            }
            case "expires": {
                this.expires = DateTools.parse(value);
                break;
            }
            case "httponly": {
                this.httpOnly = true;
                break;
            }
            case "max-age": {
                try {
                    this.maxAge = Long.parseLong(value);
                }
                catch (Exception exception) {}
                break;
            }
            case "path": {
                this.path = value;
                break;
            }
            case "samesite": {
                try {
                    this.sameSite = SameSite.valueOf(value);
                }
                catch (Exception exception) {}
                break;
            }
            case "secure": {
                this.secure = true;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        return this.httpOnly == cookie.httpOnly && this.secure == cookie.secure && Objects.equals(this.domain, cookie.domain) && Objects.equals(this.expires, cookie.expires) && Objects.equals(this.maxAge, cookie.maxAge) && Objects.equals(this.name, cookie.name) && Objects.equals(this.path, cookie.path) && Objects.equals(this.value, cookie.value);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ZonedDateTime getExpires() {
        return this.expires;
    }

    public void setExpires(ZonedDateTime expires) {
        this.expires = expires;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Long maxAge) {
        this.maxAge = maxAge;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public SameSite getSameSite() {
        return this.sameSite;
    }

    public void setSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.expires, this.httpOnly, this.maxAge, this.name, this.path, this.secure, this.value);
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String toRequestHeader() {
        return this.name + "=" + this.value;
    }

    public String toResponseHeader() {
        return this.name + "=" + this.value + (String)(this.domain != null ? "; Domain=" + this.domain : "") + (String)(this.expires != null ? "; Expires=" + DateTools.format(this.expires) : "") + (this.httpOnly ? "; HttpOnly" : "") + (String)(this.maxAge != null ? "; Max-Age=" + this.maxAge : "") + (String)(this.path != null ? "; Path=" + this.path : "") + (String)(this.sameSite != null ? "; SameSite=" + this.sameSite.name() : "") + (this.secure ? "; Secure" : "");
    }

    public static enum SameSite {
        Lax,
        None,
        Strict;

    }
}

