/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.body.response;

import io.fusionauth.http.HTTPValues;
import io.fusionauth.http.body.response.BodyProcessor;
import io.fusionauth.http.io.NonBlockingByteBufferOutputStream;
import java.nio.ByteBuffer;

public class ChunkedBodyProcessor
implements BodyProcessor {
    private final ByteBuffer[] Final = new ByteBuffer[]{ByteBuffer.wrap(HTTPValues.ControlBytes.ChunkedTerminator)};
    private final ByteBuffer Trailer = ByteBuffer.wrap(HTTPValues.ControlBytes.CRLF);
    private final ByteBuffer[] currentBuffers = new ByteBuffer[3];
    private final NonBlockingByteBufferOutputStream outputStream;

    public ChunkedBodyProcessor(NonBlockingByteBufferOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public ByteBuffer[] currentBuffers() {
        if (this.currentBuffers[1] != null && (this.currentBuffers[0].hasRemaining() || this.currentBuffers[1].hasRemaining() || this.currentBuffers[2].hasRemaining())) {
            return this.currentBuffers;
        }
        ByteBuffer buffer = this.outputStream.readableBuffer();
        if (buffer != null) {
            this.buildChunk(buffer);
            return this.currentBuffers;
        }
        if (!this.outputStream.isClosed()) {
            return null;
        }
        if (this.Final[0].hasRemaining()) {
            return this.Final;
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.outputStream.isClosed() && !this.Final[0].hasRemaining();
    }

    private void buildChunk(ByteBuffer buffer) {
        String header = Integer.toHexString(buffer.remaining()) + "\r\n";
        this.currentBuffers[0] = ByteBuffer.wrap(header.getBytes());
        this.currentBuffers[1] = buffer;
        this.currentBuffers[2] = this.Trailer.clear();
    }
}

