/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.server.Notifier;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class NonBlockingByteBufferOutputStream
extends OutputStream {
    private final int bufferSize;
    private final Queue<ByteBuffer> buffers = new ConcurrentLinkedQueue<ByteBuffer>();
    private final Notifier notifier;
    private volatile boolean closed;
    private ByteBuffer currentBuffer;
    private volatile boolean used;

    public NonBlockingByteBufferOutputStream(Notifier notifier, int bufferSize) {
        this.notifier = notifier;
        this.bufferSize = bufferSize;
    }

    public void clear() {
        this.currentBuffer = null;
        this.buffers.clear();
    }

    @Override
    public void close() {
        if (this.currentBuffer != null) {
            this.addBuffer(false);
        }
        this.closed = true;
        this.notifier.notifyNow();
    }

    @Override
    public void flush() {
        if (this.currentBuffer != null && this.currentBuffer.remaining() < this.currentBuffer.capacity() / 10) {
            this.addBuffer(true);
        }
    }

    public boolean hasReadableBuffer() {
        return this.buffers.peek() != null;
    }

    public boolean isClosed() {
        return this.buffers.isEmpty() && this.closed;
    }

    public boolean isEmpty() {
        return !this.used;
    }

    public ByteBuffer readableBuffer() {
        return this.buffers.poll();
    }

    @Override
    public void write(int b) {
        if (this.closed) {
            throw new IllegalStateException("Steam is closed");
        }
        this.used = true;
        this.setupBuffer(this.bufferSize);
        this.currentBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.closed) {
            throw new IllegalStateException("Steam is closed");
        }
        this.used = true;
        this.setupBuffer(Math.max(this.bufferSize, len));
        int length = Math.min(this.currentBuffer.remaining(), len);
        this.currentBuffer.put(b, off, length);
        if (length < len) {
            this.addBuffer(true);
            int newCapacity = Math.max(this.bufferSize, len - length);
            this.currentBuffer = ByteBuffer.allocate(newCapacity);
            this.currentBuffer.put(b, off + length, len - length);
            if (!this.currentBuffer.hasRemaining()) {
                this.addBuffer(true);
            }
        }
    }

    private void addBuffer(boolean notify) {
        this.currentBuffer.flip();
        if (!this.buffers.offer(this.currentBuffer)) {
            throw new IllegalStateException("The ConcurrentLinkedQueue is borked. It should never reject an offer() operation.");
        }
        this.currentBuffer = null;
        if (notify) {
            this.notifier.notifyNow();
        }
    }

    private void setupBuffer(int length) {
        if (this.currentBuffer == null) {
            this.currentBuffer = ByteBuffer.allocate(length);
        } else if (!this.currentBuffer.hasRemaining()) {
            this.addBuffer(true);
            this.currentBuffer = ByteBuffer.allocate(length);
        }
    }
}

