/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.log.SystemOutLoggerFactory;
import io.fusionauth.http.server.Configurable;
import io.fusionauth.http.server.ExpectValidator;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HTTPServerConfiguration
implements Configurable<HTTPServerConfiguration> {
    private final List<HTTPListenerConfiguration> listeners = new ArrayList<HTTPListenerConfiguration>();
    private Path baseDir = Path.of("", new String[0]);
    private Duration clientTimeoutDuration = Duration.ofSeconds(20L);
    private boolean compressByDefault = true;
    private String contextPath = "";
    private ExpectValidator expectValidator;
    private HTTPHandler handler;
    private Instrumenter instrumenter;
    private LoggerFactory loggerFactory = SystemOutLoggerFactory.FACTORY;
    private int maxHeadLength = 131072;
    private int multipartBufferSize = 16384;
    private int numberOfWorkerThreads = 40;
    private int preambleBufferSize = 16384;
    private int requestBufferSize = 16384;
    private int responseBufferSize = 16384;
    private Duration shutdownDuration = Duration.ofSeconds(10L);

    @Override
    public HTTPServerConfiguration configuration() {
        return this;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Duration getClientTimeoutDuration() {
        return this.clientTimeoutDuration;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ExpectValidator getExpectValidator() {
        return this.expectValidator;
    }

    public HTTPHandler getHandler() {
        return this.handler;
    }

    public Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    public List<HTTPListenerConfiguration> getListeners() {
        return this.listeners;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public int getMaxHeadLength() {
        return this.maxHeadLength;
    }

    public int getMultipartBufferSize() {
        return this.multipartBufferSize;
    }

    public int getNumberOfWorkerThreads() {
        return this.numberOfWorkerThreads;
    }

    public int getPreambleBufferSize() {
        return this.preambleBufferSize;
    }

    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public Duration getShutdownDuration() {
        return this.shutdownDuration;
    }

    public boolean isCompressByDefault() {
        return this.compressByDefault;
    }

    @Override
    public HTTPServerConfiguration withBaseDir(Path baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    @Override
    public HTTPServerConfiguration withClientTimeout(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the client timeout to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("You cannot set the client timeout less than 0");
        }
        this.clientTimeoutDuration = duration;
        return this;
    }

    @Override
    public HTTPServerConfiguration withCompressByDefault(boolean compressByDefault) {
        this.compressByDefault = compressByDefault;
        return this;
    }

    @Override
    public HTTPServerConfiguration withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Override
    public HTTPServerConfiguration withExpectValidator(ExpectValidator validator) {
        this.expectValidator = validator;
        return this;
    }

    @Override
    public HTTPServerConfiguration withHandler(HTTPHandler handler) {
        Objects.requireNonNull(handler, "You cannot set HTTPHandler to null");
        this.handler = handler;
        return this;
    }

    @Override
    public HTTPServerConfiguration withInstrumenter(Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
        return this;
    }

    @Override
    public HTTPServerConfiguration withListener(HTTPListenerConfiguration listener) {
        Objects.requireNonNull(listener, "You cannot set HTTPListenerConfiguration to null");
        this.listeners.add(listener);
        return this;
    }

    @Override
    public HTTPServerConfiguration withLoggerFactory(LoggerFactory loggerFactory) {
        Objects.requireNonNull(loggerFactory, "You cannot set LoggerFactory to null");
        this.loggerFactory = loggerFactory;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMaxPreambleLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("You cannot set the max preamble length than 0");
        }
        this.maxHeadLength = maxLength;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMultipartBufferSize(int multipartBufferSize) {
        if (multipartBufferSize <= 0) {
            throw new IllegalArgumentException("You cannot set the multipart buffer size less than 0");
        }
        this.multipartBufferSize = multipartBufferSize;
        return this;
    }

    @Override
    public HTTPServerConfiguration withNumberOfWorkerThreads(int numberOfWorkerThreads) {
        if (numberOfWorkerThreads <= 0) {
            throw new IllegalArgumentException("You cannot set the number of worker threads less than 0");
        }
        this.numberOfWorkerThreads = numberOfWorkerThreads;
        return this;
    }

    @Override
    public HTTPServerConfiguration withPreambleBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("You cannot set the preamble buffer size less than 0");
        }
        this.preambleBufferSize = size;
        return this;
    }

    @Override
    public HTTPServerConfiguration withRequestBufferSize(int requestBufferSize) {
        if (requestBufferSize <= 0) {
            throw new IllegalArgumentException("You cannot set the request buffer size less than 0");
        }
        this.requestBufferSize = requestBufferSize;
        return this;
    }

    @Override
    public HTTPServerConfiguration withResponseBufferSize(int responseBufferSize) {
        if (responseBufferSize <= 0) {
            throw new IllegalArgumentException("You cannot set the response buffer size less than 0");
        }
        this.responseBufferSize = responseBufferSize;
        return this;
    }

    @Override
    public HTTPServerConfiguration withShutdownDuration(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the shutdown duration to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("You cannot set the shutdown duration less than 0");
        }
        this.shutdownDuration = duration;
        return this;
    }
}

