/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.ConnectionClosedException;
import io.fusionauth.http.server.Notifier;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class BlockingByteBufferOutputStream
extends OutputStream {
    private final int bufferSize;
    private final BlockingQueue<ByteBuffer> buffers;
    private final Notifier notifier;
    private volatile boolean closed;
    private ByteBuffer currentBuffer;
    private volatile boolean used;

    public BlockingByteBufferOutputStream(Notifier notifier, int bufferSize, int maximumQueueSize) {
        this.buffers = new LinkedBlockingQueue<ByteBuffer>(maximumQueueSize);
        this.bufferSize = bufferSize;
        this.notifier = notifier;
    }

    public void clear() {
        this.currentBuffer = null;
        this.buffers.clear();
    }

    @Override
    public void close() {
        if (this.currentBuffer != null) {
            this.addBuffer(false);
        }
        this.closed = true;
        this.notifier.notifyNow();
    }

    @Override
    public void flush() {
        if (this.currentBuffer != null && this.currentBuffer.remaining() < this.currentBuffer.capacity() / 10) {
            this.addBuffer(true);
        }
    }

    public boolean hasReadableBuffer() {
        return this.buffers.peek() != null;
    }

    public boolean isClosed() {
        return this.buffers.isEmpty() && this.closed;
    }

    public boolean isEmpty() {
        return !this.used;
    }

    public ByteBuffer readableBuffer() {
        return (ByteBuffer)this.buffers.poll();
    }

    @Override
    public void write(int b) {
        if (this.closed) {
            throw new IllegalStateException("Steam is closed");
        }
        this.used = true;
        this.setupBuffer(this.bufferSize);
        this.currentBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.closed) {
            throw new IllegalStateException("Steam is closed");
        }
        this.used = true;
        this.setupBuffer(this.bufferSize);
        int length = Math.min(this.currentBuffer.remaining(), len);
        this.currentBuffer.put(b, off, length);
        if (length < len) {
            this.addBuffer(true);
            int newCapacity = Math.max(this.bufferSize, len - length);
            this.currentBuffer = ByteBuffer.allocate(newCapacity);
            this.currentBuffer.put(b, off + length, len - length);
            if (!this.currentBuffer.hasRemaining()) {
                this.addBuffer(true);
            }
        }
    }

    private void addBuffer(boolean notify) {
        this.currentBuffer.flip();
        try {
            this.buffers.put(this.currentBuffer);
        }
        catch (InterruptedException e) {
            this.currentBuffer = null;
            this.buffers.clear();
            throw new ConnectionClosedException(e);
        }
        this.currentBuffer = null;
        if (notify) {
            this.notifier.notifyNow();
        }
    }

    private void setupBuffer(int length) {
        if (this.currentBuffer == null) {
            this.currentBuffer = ByteBuffer.allocate(length);
        } else if (!this.currentBuffer.hasRemaining()) {
            this.addBuffer(true);
            this.currentBuffer = ByteBuffer.allocate(length);
        }
    }
}

