/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.log.Logger;
import io.fusionauth.http.security.SecurityTools;
import io.fusionauth.http.server.HTTP11Processor;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPProcessor;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.ProcessorState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;

public class HTTPS11Processor
implements HTTPProcessor {
    private static final AtomicInteger threadCount = new AtomicInteger(1);
    private static final ExecutorService executor = Executors.newCachedThreadPool(r -> new Thread(r, "TLS Handshake Thread " + threadCount.getAndIncrement()));
    private final SSLEngine engine;
    private final Logger logger;
    private final ByteBuffer[] myAppData;
    private final ByteBuffer[] myNetData;
    private final ByteBuffer peerAppData;
    private HTTP11Processor delegate;
    private volatile ProcessorState handshakeState;
    private ByteBuffer peerNetData;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HTTPS11Processor(HTTP11Processor delegate, HTTPServerConfiguration configuration, HTTPListenerConfiguration listenerConfiguration) throws GeneralSecurityException, IOException {
        this.delegate = delegate;
        this.logger = configuration.getLoggerFactory().getLogger(HTTPS11Processor.class);
        if (listenerConfiguration.isTLS()) {
            SSLContext context = SecurityTools.serverContext(listenerConfiguration.getCertificateChain(), listenerConfiguration.getPrivateKey());
            this.engine = context.createSSLEngine();
            this.engine.setUseClientMode(false);
            SSLSession session = this.engine.getSession();
            this.myAppData = new ByteBuffer[]{ByteBuffer.allocate(session.getApplicationBufferSize())};
            this.myNetData = new ByteBuffer[]{ByteBuffer.allocate(session.getPacketBufferSize())};
            this.peerAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
            this.peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.myNetData[0].flip();
            this.engine.beginHandshake();
            SSLEngineResult.HandshakeStatus tlsStatus = this.engine.getHandshakeStatus();
            if (tlsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                this.handshakeState = ProcessorState.Read;
                return;
            } else {
                if (tlsStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) throw new IllegalStateException("The SSLEngine is not in a valid state. It should be in the handshake state, but it is in the state [" + tlsStatus + "]");
                this.handshakeState = ProcessorState.Write;
            }
            return;
        } else {
            this.engine = null;
            this.myAppData = null;
            this.myNetData = null;
            this.peerAppData = null;
            this.peerNetData = null;
        }
    }

    @Override
    public ProcessorState close(boolean endOfStream) {
        this.logger.trace("(HTTPS-C)");
        if (this.engine == null) {
            return this.delegate.close(endOfStream);
        }
        if (endOfStream) {
            try {
                this.engine.closeInbound();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.delegate.close(endOfStream);
        this.handshakeState = ProcessorState.Write;
        this.engine.closeOutbound();
        return this.handshakeState;
    }

    @Override
    public void failure(Throwable t) {
        this.logger.trace("(HTTPS-F)");
        this.delegate.failure(t);
    }

    @Override
    public int initialKeyOps() {
        this.logger.trace("(HTTPS-A)");
        if (this.engine == null) {
            return this.delegate.initialKeyOps();
        }
        return this.handshakeState == ProcessorState.Read ? 1 : 4;
    }

    @Override
    public long lastUsed() {
        return this.delegate.lastUsed();
    }

    @Override
    public ProcessorState read(ByteBuffer buffer) throws IOException {
        ByteBuffer decryptBuffer;
        this.delegate.markUsed();
        if (this.engine == null) {
            return this.delegate.read(buffer);
        }
        SSLEngineResult.HandshakeStatus tlsStatus = this.engine.getHandshakeStatus();
        if (tlsStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && tlsStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            this.logger.trace("(HTTPS-R-HS)" + tlsStatus);
            decryptBuffer = this.peerAppData.clear();
        } else {
            this.logger.trace("(HTTPS-R-RQ)");
            this.handshakeState = null;
            decryptBuffer = this.delegate.readBuffer();
        }
        if (decryptBuffer == null) {
            this.logger.trace("(HTTPS-R-NULL)");
            return this.delegate.state();
        }
        SSLEngineResult result = this.engine.unwrap(this.peerNetData, decryptBuffer);
        this.peerNetData.compact();
        if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            this.logger.trace("(HTTPS-R-UF)");
            this.peerNetData = this.handleBufferUnderflow(this.peerNetData);
            return this.handshakeState != null ? this.handshakeState : this.delegate.state();
        }
        if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.logger.trace("(HTTPS-R-C)");
            return this.close(false);
        }
        if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            throw new IllegalStateException("A buffer overflow is not expected during an unwrap operation. This occurs because the preamble or body buffers are too small. Increase their sizes to avoid this issue.");
        }
        if (tlsStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || tlsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.logger.trace("(HTTPS-R-RQ-R)");
            this.handshakeState = null;
            decryptBuffer.flip();
            return this.delegate.read(decryptBuffer);
        }
        this.logger.trace("(HTTPS-HS-UW){}", this.peerNetData);
        SSLEngineResult.HandshakeStatus newTLSStatus = result.getHandshakeStatus();
        ProcessorState newState = this.handleHandshake(newTLSStatus);
        if (this.handshakeState == ProcessorState.Read && this.peerNetData.position() > 0 && result.bytesConsumed() > 0) {
            this.peerNetData.flip();
            return this.read(this.peerNetData);
        }
        return newState;
    }

    @Override
    public ByteBuffer readBuffer() {
        this.delegate.markUsed();
        if (this.engine == null) {
            return this.delegate.readBuffer();
        }
        return this.peerNetData;
    }

    @Override
    public long readThroughput() {
        return this.delegate.readThroughput();
    }

    @Override
    public ProcessorState state() {
        if (this.engine == null) {
            return this.delegate.state();
        }
        return this.handshakeState != null ? this.handshakeState : this.delegate.state();
    }

    public void updateDelegate(HTTP11Processor delegate) {
        this.delegate = delegate;
    }

    @Override
    public ByteBuffer[] writeBuffers() throws IOException {
        ByteBuffer[] plainTextBuffers;
        this.delegate.markUsed();
        if (this.engine == null) {
            return this.delegate.writeBuffers();
        }
        if (this.myNetData[0].hasRemaining()) {
            return this.myNetData;
        }
        SSLEngineResult.HandshakeStatus tlsStatus = this.engine.getHandshakeStatus();
        if (tlsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.handshakeState = ProcessorState.Read;
            return null;
        }
        if (tlsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            this.logger.trace("(HTTPS-W-HS)");
            this.myAppData[0].clear();
            plainTextBuffers = this.myAppData;
        } else {
            this.handshakeState = null;
            plainTextBuffers = this.delegate.writeBuffers();
        }
        if (plainTextBuffers == null) {
            return null;
        }
        this.myNetData[0].clear();
        SSLEngineResult result = this.engine.wrap(plainTextBuffers, this.myNetData[0]);
        if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            this.logger.trace("(HTTPS-W-OF)");
            this.myNetData[0] = this.handleBufferOverflow(this.myNetData[0]);
        } else {
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.logger.trace("(HTTPS-W-C)");
                this.close(false);
                return null;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                throw new IllegalStateException("A buffer underflow is not expected during a wrap operation according to the Javadoc. Maybe this is something we need to fix.");
            }
            this.logger.trace("(HTTPS-W-RQ)");
            this.myNetData[0].flip();
        }
        return this.myNetData;
    }

    @Override
    public long writeThroughput() {
        return this.delegate.writeThroughput();
    }

    @Override
    public ProcessorState wrote(long num) throws IOException {
        this.delegate.markUsed();
        if (this.handshakeState == null) {
            return this.delegate.wrote(num);
        }
        SSLEngineResult.HandshakeStatus tlsStatus = this.engine.getHandshakeStatus();
        return this.handleHandshake(tlsStatus);
    }

    private ByteBuffer handleBufferOverflow(ByteBuffer buffer) {
        int applicationSize = this.engine.getSession().getApplicationBufferSize();
        ByteBuffer newBuffer = ByteBuffer.allocate(applicationSize + buffer.position());
        buffer.flip();
        newBuffer.put(buffer);
        return newBuffer;
    }

    private ByteBuffer handleBufferUnderflow(ByteBuffer buffer) {
        int networkSize = this.engine.getSession().getPacketBufferSize();
        if (networkSize > buffer.capacity()) {
            ByteBuffer newBuffer = ByteBuffer.allocate(networkSize);
            buffer.flip();
            newBuffer.put(buffer);
            buffer = newBuffer;
        }
        return buffer;
    }

    private ProcessorState handleHandshake(SSLEngineResult.HandshakeStatus newTLSStatus) throws IOException {
        if (newTLSStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN) {
            throw new IllegalStateException("The NEED_UNWRAP_AGAIN state should not happen in HTTPS");
        }
        if (newTLSStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.logger.trace("(HTTPS-HS-T)");
            do {
                Runnable task;
                newTLSStatus = this.engine.getHandshakeStatus();
                while ((task = this.engine.getDelegatedTask()) != null) {
                    executor.submit(task);
                }
            } while (newTLSStatus == SSLEngineResult.HandshakeStatus.NEED_TASK);
        }
        if (newTLSStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.logger.trace("(HTTPS-HS-R)");
            this.handshakeState = ProcessorState.Read;
        } else if (newTLSStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            this.logger.trace("(HTTPS-HS-W)");
            this.handshakeState = ProcessorState.Write;
        } else {
            this.logger.trace("(HTTPS-HS-DONE)" + newTLSStatus.name());
            if (!this.myNetData[0].hasRemaining()) {
                this.logger.trace("(HTTPS-HS-DONE)" + newTLSStatus.name() + "-" + this.delegate.state());
                this.handshakeState = null;
                if (this.peerNetData.position() > 0) {
                    this.peerNetData.flip();
                    return this.read(this.peerNetData);
                }
                return this.delegate.state();
            }
        }
        return this.handshakeState;
    }
}

