/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.Configurable;
import io.fusionauth.http.server.HTTPContext;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.HTTPServerThread;
import io.fusionauth.http.util.ThreadPool;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HTTPServer
implements Closeable,
Configurable<HTTPServer> {
    private final List<HTTPServerThread> threads = new ArrayList<HTTPServerThread>();
    private HTTPServerConfiguration configuration = new HTTPServerConfiguration();
    private volatile HTTPContext context;
    private Logger logger;
    private ThreadPool threadPool;

    @Override
    public void close() {
        this.logger.info("HTTP server shutdown requested. Attempting to close each listener. This could take a while.");
        for (HTTPServerThread thread : this.threads) {
            thread.close();
            try {
                thread.join(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.threadPool.shutdown()) {
            this.logger.info("HTTP server shutdown successfully.");
        } else {
            this.logger.error("HTTP server shutdown failed. It's harshing my mellow!");
        }
    }

    @Override
    public HTTPServerConfiguration configuration() {
        return this.configuration;
    }

    public HTTPContext getContext() {
        return this.context;
    }

    public HTTPServer start() {
        if (this.context != null) {
            return this;
        }
        this.logger = this.configuration.getLoggerFactory().getLogger(HTTPServer.class);
        this.logger.info("Starting the HTTP server. Buckle up!");
        this.context = new HTTPContext(this.configuration.getBaseDir());
        this.threadPool = new ThreadPool(this.configuration.getNumberOfWorkerThreads(), "HTTP Server Worker Thread", this.configuration.getShutdownDuration());
        try {
            for (HTTPListenerConfiguration listener : this.configuration.getListeners()) {
                HTTPServerThread thread = new HTTPServerThread(this.configuration, listener, this.threadPool);
                thread.start();
                this.threads.add(thread);
                this.logger.info("HTTP server listening on port [{}]", listener.getPort());
            }
            this.logger.info("HTTP server started successfully");
        }
        catch (IOException e) {
            this.logger.error("Unable to start the HTTP server because one of the listeners threw an exception.", e);
            this.close();
        }
        return this;
    }

    public HTTPServer withConfiguration(HTTPServerConfiguration configuration) {
        this.configuration = configuration;
        this.logger = configuration.getLoggerFactory().getLogger(HTTPServer.class);
        return this;
    }
}

