/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.ParseException;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.security.SecurityTools;
import io.fusionauth.http.server.HTTP11Processor;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPProcessor;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.ProcessorState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class HTTPS11Processor
implements HTTPProcessor {
    private final ByteBuffer[] encryptedDataArray;
    private final SSLEngine engine;
    private final ByteBuffer[] handshakeDataArray;
    private final Logger logger;
    private ByteBuffer decryptedData;
    private HTTP11Processor delegate;
    private ByteBuffer encryptedData;
    private ByteBuffer handshakeData;
    private volatile HTTPSState state;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HTTPS11Processor(HTTP11Processor delegate, HTTPServerConfiguration configuration, HTTPListenerConfiguration listenerConfiguration) throws GeneralSecurityException, IOException {
        this.delegate = delegate;
        this.logger = configuration.getLoggerFactory().getLogger(HTTPS11Processor.class);
        if (listenerConfiguration.isTLS()) {
            SSLContext context = SecurityTools.serverContext(listenerConfiguration.getCertificateChain(), listenerConfiguration.getPrivateKey());
            this.engine = context.createSSLEngine();
            this.engine.setUseClientMode(false);
            SSLSession session = this.engine.getSession();
            this.decryptedData = ByteBuffer.allocate(session.getApplicationBufferSize());
            this.encryptedData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.handshakeData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.encryptedDataArray = new ByteBuffer[]{this.encryptedData};
            this.handshakeDataArray = new ByteBuffer[]{this.handshakeData};
            this.engine.beginHandshake();
            SSLEngineResult.HandshakeStatus tlsStatus = this.engine.getHandshakeStatus();
            if (tlsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                this.state = HTTPSState.HandshakeRead;
                return;
            } else {
                if (tlsStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) throw new IllegalStateException("The SSLEngine is not in a valid state. It should be in the handshake state, but it is in the state [" + tlsStatus + "]");
                this.state = HTTPSState.HandshakeWrite;
            }
            return;
        } else {
            this.engine = null;
            this.decryptedData = null;
            this.encryptedData = null;
            this.encryptedDataArray = null;
            this.handshakeData = null;
            this.handshakeDataArray = null;
        }
    }

    @Override
    public ProcessorState close(boolean endOfStream) {
        if (this.engine == null) {
            return this.delegate.close(endOfStream);
        }
        this.logger.trace("(HTTPS-CLOSE) {} {}", this.engine.isInboundDone(), this.engine.isOutboundDone());
        this.engine.getSession().invalidate();
        try {
            this.delegate.close(endOfStream);
            this.engine.closeOutbound();
            this.state = HTTPSState.HandshakeWrite;
            this.encryptedData.clear();
            this.decryptedData.clear();
            SSLEngineResult result = this.engine.wrap(this.decryptedData, this.encryptedData);
            this.logger.trace("(HTTPS-CLOSE) {} {} {} {} {} {} {}", new Object[]{this.engine.isInboundDone(), this.engine.isOutboundDone(), this.encryptedData, this.decryptedData, result.getStatus(), result.getHandshakeStatus(), this.state});
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        return this.toProcessorState();
    }

    @Override
    public void failure(Throwable t) {
        this.logger.trace("(HTTPS-FAILURE)");
        this.delegate.failure(t);
        this.state = switch (this.delegate.state()) {
            case ProcessorState.Close -> HTTPSState.Close;
            case ProcessorState.Write -> HTTPSState.BodyWrite;
            default -> throw new IllegalStateException("Unexpected failure state from the HTTP11Processor (delegate to the HTTPS11Processor)");
        };
    }

    @Override
    public int initialKeyOps() {
        this.logger.trace("(HTTPS-ACCEPT)");
        if (this.engine == null) {
            return this.delegate.initialKeyOps();
        }
        return this.toProcessorState() == ProcessorState.Read ? 1 : 4;
    }

    @Override
    public long lastUsed() {
        return this.delegate.lastUsed();
    }

    @Override
    public ProcessorState read(ByteBuffer buffer) throws IOException {
        this.logger.trace("(HTTPS-READ) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
        this.delegate.markUsed();
        if (this.engine == null) {
            return this.delegate.read(buffer);
        }
        if (this.state == HTTPSState.HandshakeRead || this.state == HTTPSState.HandshakeWrite) {
            this.state = this.handshake();
            if (this.handshakeData.hasRemaining()) {
                if (this.handshakeData.remaining() > this.encryptedData.remaining()) {
                    this.logger.trace("(HTTPS-READ-RESIZE-AFTER-HANDSHAKE-BEFORE) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                    this.encryptedData = this.resizeBuffer(this.encryptedData, this.encryptedData.capacity() + this.handshakeData.remaining());
                    this.logger.trace("(HTTPS-READ-RESIZE-AFTER-HANDSHAKE-AFTER) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                }
                this.encryptedData.put(this.handshakeData);
                this.logger.trace("(HTTPS-READ-COPY-AFTER-HANDSHAKE) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
            }
            if (this.state == HTTPSState.HandshakeRead || this.state == HTTPSState.HandshakeWrite) {
                this.handshakeData.clear();
                return this.toProcessorState();
            }
            if (this.encryptedData.hasRemaining()) {
                this.state = HTTPSState.BodyRead;
                this.encryptedData.compact();
            } else {
                this.encryptedData.clear();
            }
        }
        this.decrypt();
        this.state = switch (this.delegate.state()) {
            default -> throw new IncompatibleClassChangeError();
            case ProcessorState.Read -> HTTPSState.BodyRead;
            case ProcessorState.Write -> HTTPSState.BodyWrite;
            case ProcessorState.Close -> HTTPSState.Close;
            case ProcessorState.Reset -> HTTPSState.Reset;
        };
        this.logger.trace("(HTTPS-READ-DONE) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
        return this.toProcessorState();
    }

    @Override
    public ByteBuffer readBuffer() {
        this.logger.trace("(HTTPS-READ-BUFFER) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
        this.delegate.markUsed();
        if (this.engine == null) {
            return this.delegate.readBuffer();
        }
        return this.state == HTTPSState.HandshakeRead ? this.handshakeData : this.encryptedData;
    }

    @Override
    public long readThroughput() {
        return this.delegate.readThroughput();
    }

    @Override
    public ProcessorState state() {
        if (this.engine == null) {
            return this.delegate.state();
        }
        return this.toProcessorState();
    }

    public void updateDelegate(HTTP11Processor delegate) {
        this.delegate = delegate;
        this.state = HTTPSState.BodyRead;
        if (this.engine != null) {
            this.decryptedData.clear();
            this.encryptedData.clear();
            this.handshakeData.clear();
        }
    }

    @Override
    public ByteBuffer[] writeBuffers() throws IOException {
        this.logger.trace("(HTTPS-WRITE-BUFFERS) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
        this.delegate.markUsed();
        if (this.engine == null) {
            return this.delegate.writeBuffers();
        }
        if (this.state == HTTPSState.HandshakeWriting && this.handshakeData.hasRemaining()) {
            return this.handshakeDataArray;
        }
        if (this.state == HTTPSState.BodyWriting && this.encryptedData.hasRemaining()) {
            return this.encryptedDataArray;
        }
        if (this.state == HTTPSState.HandshakeRead || this.state == HTTPSState.HandshakeWrite) {
            this.state = this.handshake();
        } else {
            this.encrypt();
        }
        if (this.state != HTTPSState.BodyWriting && this.state != HTTPSState.HandshakeWriting) {
            return null;
        }
        return this.state == HTTPSState.HandshakeWriting ? this.handshakeDataArray : this.encryptedDataArray;
    }

    @Override
    public long writeThroughput() {
        return this.delegate.writeThroughput();
    }

    @Override
    public ProcessorState wrote(long num) throws IOException {
        this.delegate.markUsed();
        if (this.engine == null) {
            return this.delegate.wrote(num);
        }
        this.logger.trace("(HTTPS-WROTE) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
        if (this.state == HTTPSState.HandshakeWriting && !this.handshakeData.hasRemaining()) {
            this.handshakeData.clear();
            SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
            this.state = switch (handshakeStatus) {
                case SSLEngineResult.HandshakeStatus.NEED_WRAP -> HTTPSState.HandshakeWrite;
                case SSLEngineResult.HandshakeStatus.NEED_UNWRAP, SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN -> HTTPSState.HandshakeRead;
                case SSLEngineResult.HandshakeStatus.FINISHED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING -> HTTPSState.BodyRead;
                default -> throw new IllegalStateException("Handshaking went from write to task, which was unexpected");
            };
            if (this.state == HTTPSState.BodyRead && this.encryptedData.position() > 0) {
                this.encryptedData.flip();
                this.read(this.encryptedData);
            }
        } else {
            ProcessorState newState = this.delegate.wrote(num);
            switch (newState) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case Read: {
                    HTTPSState hTTPSState = HTTPSState.BodyRead;
                    break;
                }
                case Write: {
                    HTTPSState hTTPSState = HTTPSState.BodyWrite;
                    break;
                }
                case Close: {
                    HTTPSState hTTPSState = HTTPSState.Close;
                    break;
                }
                case Reset: {
                    HTTPSState hTTPSState = this.state = HTTPSState.Reset;
                }
            }
            if (this.state == HTTPSState.BodyRead) {
                if (this.encryptedData.hasRemaining()) {
                    throw new IllegalStateException("The encrypted data still has data to write, but the HTTP processor changed states.");
                }
                this.encryptedData.clear();
            }
        }
        this.logger.trace("(HTTPS-WROTE-DONE) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
        return this.toProcessorState();
    }

    private void copyToDelegate() throws IOException {
        this.decryptedData.flip();
        while (this.decryptedData.hasRemaining()) {
            ByteBuffer buf = this.delegate.readBuffer();
            if (buf == null) {
                this.logger.trace("(HTTPS-DECRYPT-COPY-TO-DELEGATE-NULL)");
                throw new ParseException("Unable to complete HTTP request because the server thought the request was complete but the client sent more data");
            }
            this.logger.trace("(HTTPS-DECRYPT-COPY-TO-DELEGATE) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
            int length = Math.min(buf.remaining(), this.decryptedData.remaining());
            buf.put(buf.position(), this.decryptedData, this.decryptedData.position(), length);
            buf.position(buf.position() + length);
            buf.flip();
            this.decryptedData.position(this.decryptedData.position() + length);
            this.logger.trace("(HTTPS-DECRYPT-COPY-TO-DELEGATE-COPIED) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
            ProcessorState newState = this.delegate.read(buf);
            this.logger.trace("(HTTPS-DECRYPT-COPY-TO-DELEGATE-DONE) {} {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state, newState});
        }
    }

    private void decrypt() throws IOException {
        if (this.state != HTTPSState.BodyRead) {
            throw new IllegalStateException("Somehow we got into a state of [" + this.state + "] but should be in BodyRead.");
        }
        boolean overflowedAlready = false;
        while (this.encryptedData.hasRemaining()) {
            this.logger.trace("(HTTPS-DECRYPT-BEFORE) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
            SSLEngineResult result = this.engine.unwrap(this.encryptedData, this.decryptedData);
            this.logger.trace("(HTTPS-DECRYPT-AFTER) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
            SSLEngineResult.Status status = result.getStatus();
            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.logger.trace("(HTTPS-DECRYPT-OVERFLOW) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
                if (overflowedAlready) {
                    throw new IllegalStateException("We already overflowed the decryption buffer and resized it, so this is extremely unexpected.");
                }
                overflowedAlready = true;
                this.decryptedData = this.resizeBuffer(this.decryptedData, this.engine.getSession().getApplicationBufferSize());
                continue;
            }
            if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.logger.trace("(HTTPS-DECRYPT-UNDERFLOW-BEFORE) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
                this.encryptedData.compact();
                this.logger.trace("(HTTPS-DECRYPT-UNDERFLOW-AFTER) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
                return;
            }
            if (status == SSLEngineResult.Status.CLOSED) {
                this.logger.trace("(HTTPS-DECRYPT-CLOSE) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
                this.state = HTTPSState.Close;
                return;
            }
            this.copyToDelegate();
            this.decryptedData.clear();
        }
        this.encryptedData.clear();
    }

    private void encrypt() throws SSLException {
        SSLEngineResult.Status status;
        this.logger.trace("(HTTPS-ENCRYPT) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
        ByteBuffer[] buffers = this.delegate.writeBuffers();
        if (buffers == null || buffers.length == 0) {
            return;
        }
        this.encryptedData.clear();
        this.logger.trace("(HTTPS-ENCRYPT-CLEAR) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
        do {
            this.logger.trace("(HTTPS-ENCRYPT-WRAP-BEFORE) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
            SSLEngineResult result = this.engine.wrap(buffers, this.encryptedData);
            status = result.getStatus();
            this.logger.trace("(HTTPS-ENCRYPT-WRAP-AFTER) {} {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state, status});
            if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                return;
            }
            if (status == SSLEngineResult.Status.CLOSED) {
                this.state = HTTPSState.Close;
                return;
            }
            if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            this.encryptedData = this.resizeBuffer(this.encryptedData, this.engine.getSession().getPacketBufferSize());
            this.logger.trace("(HTTPS-ENCRYPT-RESIZE) {} {} {}", new Object[]{this.encryptedData, this.decryptedData, this.state});
        } while (status == SSLEngineResult.Status.BUFFER_OVERFLOW);
        this.encryptedData.flip();
        this.state = HTTPSState.BodyWriting;
    }

    private SSLEngineResult.HandshakeStatus handleHandshakeTask(SSLEngineResult.HandshakeStatus handshakeStatus) {
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.logger.trace("(HTTPS-HANDSHAKE-TASK) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
            while (true) {
                Runnable task;
                if ((task = this.engine.getDelegatedTask()) != null) {
                    task.run();
                    continue;
                }
                handshakeStatus = this.engine.getHandshakeStatus();
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
            }
            this.logger.trace("(HTTPS-HANDSHAKE-TASK-DONE) {} {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state, handshakeStatus});
        }
        return handshakeStatus;
    }

    private HTTPSState handshake() throws SSLException {
        SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return HTTPSState.BodyRead;
        }
        if ((handshakeStatus = this.handleHandshakeTask(handshakeStatus)) == SSLEngineResult.HandshakeStatus.NEED_UNWRAP || handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN) {
            this.logger.trace("(HTTPS-HANDSHAKE-UNWRAP) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
            SSLEngineResult result = null;
            while ((handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP || handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN) && this.handshakeData.hasRemaining()) {
                this.logger.trace("(HTTPS-HANDSHAKE-UNWRAP-BEFORE) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                result = this.engine.unwrap(this.handshakeData, this.decryptedData);
                this.logger.trace("(HTTPS-HANDSHAKE-UNWRAP-AFTER) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                SSLEngineResult.Status status = result.getStatus();
                if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    throw new IllegalStateException("Handshake reading should never overflow the network buffer. It is sized such that it can handle a full TLS packet.");
                }
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    this.logger.trace("(HTTPS-HANDSHAKE-UNWRAP-UNDERFLOW) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                    this.handshakeData.compact();
                    return HTTPSState.HandshakeRead;
                }
                if (status == SSLEngineResult.Status.CLOSED) {
                    this.logger.trace("(HTTPS-HANDSHAKE-UNWRAP-CLOSE) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                    return HTTPSState.Close;
                }
                handshakeStatus = result.getHandshakeStatus();
                handshakeStatus = this.handleHandshakeTask(handshakeStatus);
            }
            if (result == null) {
                this.logger.trace("(HTTPS-HANDSHAKE-UNWRAP-EMPTY) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                return this.state;
            }
            this.logger.trace("(HTTPS-HANDSHAKE-DONE) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
            return switch (handshakeStatus) {
                case SSLEngineResult.HandshakeStatus.NEED_WRAP -> HTTPSState.HandshakeWrite;
                case SSLEngineResult.HandshakeStatus.NEED_UNWRAP, SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN -> HTTPSState.HandshakeRead;
                case SSLEngineResult.HandshakeStatus.FINISHED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING -> HTTPSState.BodyRead;
                default -> throw new IllegalStateException("Handshaking got back into a NEED_TASK mode and should have handled that above.");
            };
        }
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            SSLEngineResult.Status status;
            this.logger.trace("(HTTPS-HANDSHAKE-WRAP) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
            do {
                this.logger.trace("(HTTPS-HANDSHAKE-WRAP-BEFORE) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                SSLEngineResult result = this.engine.wrap(this.decryptedData, this.handshakeData);
                status = result.getStatus();
                this.logger.trace("(HTTPS-HANDSHAKE-WRAP-AFTER) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                this.logger.trace("(HTTPS-HANDSHAKE-WRAP-OVERFLOW) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                this.handshakeData = this.resizeBuffer(this.handshakeData, this.engine.getSession().getPacketBufferSize() + this.handshakeData.remaining());
            } while (status == SSLEngineResult.Status.BUFFER_OVERFLOW);
            if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                throw new IllegalStateException("Handshake writing should never underflow the network buffer. The engine handles generating handshake data, so this should be impossible.");
            }
            if (status == SSLEngineResult.Status.CLOSED) {
                this.logger.trace("(HTTPS-HANDSHAKE-WRAP-CLOSE) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
                return HTTPSState.Close;
            }
            this.handshakeData.flip();
            this.logger.trace("(HTTPS-HANDSHAKE-DONE) {} {} {} {}", new Object[]{this.handshakeData, this.encryptedData, this.decryptedData, this.state});
            return HTTPSState.HandshakeWriting;
        }
        return this.state;
    }

    private ByteBuffer resizeBuffer(ByteBuffer buffer, int engineSize) {
        if (engineSize > buffer.capacity()) {
            ByteBuffer newBuffer = ByteBuffer.allocate(engineSize + buffer.remaining());
            newBuffer.put(buffer);
            buffer = newBuffer;
        } else {
            buffer.compact();
        }
        return buffer;
    }

    private ProcessorState toProcessorState() {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case HTTPSState.BodyRead, HTTPSState.HandshakeRead -> ProcessorState.Read;
            case HTTPSState.BodyWrite, HTTPSState.BodyWriting, HTTPSState.HandshakeWrite, HTTPSState.HandshakeWriting -> ProcessorState.Write;
            case HTTPSState.Close -> ProcessorState.Close;
            case HTTPSState.Reset -> ProcessorState.Reset;
        };
    }

    public static enum HTTPSState {
        BodyRead,
        BodyWrite,
        BodyWriting,
        Close,
        HandshakeRead,
        HandshakeWrite,
        HandshakeWriting,
        Reset;

    }
}

