/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.client;

import io.fusionauth.http.ParseException;
import io.fusionauth.http.util.HTTPTools;
import java.util.List;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ResponseParserState {
    ResponseProtocol{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 72 || ch == 84 || ch == 80 || ch == 47 || ch == 49 || ch == 46) {
                return ResponseProtocol;
            }
            if (ch == 32) {
                return ResponseProtocolSP;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    ResponseProtocolSP{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 32) {
                return ResponseProtocolSP;
            }
            if (HTTPTools.isDigitCharacter(ch)) {
                return ResponseStatusCode;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    ResponseStatusCode{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 32) {
                return ResponseStatusCodeSP;
            }
            if (HTTPTools.isDigitCharacter(ch)) {
                return ResponseStatusCode;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    ResponseStatusCodeSP{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 32) {
                return ResponseStatusCodeSP;
            }
            if (HTTPTools.isValueCharacter(ch)) {
                return ResponseStatusMessage;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    ResponseStatusMessage{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 13) {
                return ResponseStatusMessageCR;
            }
            if (HTTPTools.isValueCharacter(ch)) {
                return ResponseStatusMessage;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    ResponseStatusMessageCR{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 10) {
                return ResponseStatusMessageLF;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    ResponseStatusMessageLF{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 13) {
                return ResponseMessageCR;
            }
            if (HTTPTools.isTokenCharacter(ch)) {
                return HeaderName;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    ResponseMessageCR{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 10) {
                return ResponseComplete;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    ResponseComplete{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            return ResponseComplete;
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    HeaderName{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (HTTPTools.isTokenCharacter(ch)) {
                return HeaderName;
            }
            if (ch == 58) {
                return HeaderColon;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    HeaderColon{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 32) {
                return HeaderColon;
            }
            if (HTTPTools.isTokenCharacter(ch)) {
                return HeaderValue;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    HeaderValue{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 13) {
                return HeaderCR;
            }
            if (HTTPTools.isValueCharacter(ch)) {
                return HeaderValue;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    HeaderCR{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 10) {
                return HeaderLF;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    HeaderLF{

        @Override
        public ResponseParserState next(byte ch, Map<String, List<String>> headers) {
            if (ch == 13) {
                return ResponseMessageCR;
            }
            if (HTTPTools.isTokenCharacter(ch)) {
                return HeaderName;
            }
            throw new ParseException();
        }

        @Override
        public boolean store() {
            return false;
        }
    };


    public abstract ResponseParserState next(byte var1, Map<String, List<String>> var2);

    public abstract boolean store();
}

