/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.ParseException;
import io.fusionauth.http.io.ChunkException;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private final byte[] b1 = new byte[1];
    private final byte[] buffer;
    private final PushbackInputStream delegate;
    private final StringBuilder headerSizeHex = new StringBuilder();
    private int bufferIndex;
    private int bufferLength;
    private int chunkBytesRead;
    private int chunkBytesRemaining;
    private int chunkSize;
    private ChunkedBodyState state = ChunkedBodyState.ChunkSize;

    public ChunkedInputStream(PushbackInputStream delegate, int bufferSize) {
        this.delegate = delegate;
        this.buffer = new byte[bufferSize];
    }

    @Override
    public int read(byte[] destination, int dOff, int dLen) throws IOException {
        int total;
        int dIndex = dOff;
        block2: while (dIndex < dLen) {
            if (this.state == ChunkedBodyState.Complete) {
                this.pushBackOverReadBytes();
                break;
            }
            if (this.bufferIndex >= this.bufferLength) {
                this.bufferIndex = 0;
                this.bufferLength = this.delegate.read(this.buffer);
            }
            while (this.bufferIndex < this.bufferLength) {
                int lengthToCopy;
                ChunkedBodyState nextState;
                try {
                    nextState = this.state.next(this.buffer[this.bufferIndex], this.chunkSize, this.chunkBytesRead);
                }
                catch (ParseException e) {
                    e.setIndex(this.bufferIndex);
                    throw e;
                }
                if (this.state == ChunkedBodyState.Complete) {
                    this.state = nextState;
                    ++this.bufferIndex;
                    this.pushBackOverReadBytes();
                    continue block2;
                }
                if (nextState == ChunkedBodyState.ChunkSize) {
                    this.headerSizeHex.appendCodePoint(this.buffer[this.bufferIndex]);
                    this.state = nextState;
                    ++this.bufferIndex;
                    continue;
                }
                if (this.state != ChunkedBodyState.Chunk && nextState == ChunkedBodyState.Chunk) {
                    if (this.headerSizeHex.isEmpty()) {
                        throw new ChunkException("Chunk size is missing");
                    }
                    this.chunkSize = (int)Long.parseLong(this.headerSizeHex, 0, this.headerSizeHex.length(), 16);
                    this.chunkBytesRead = 0;
                    this.chunkBytesRemaining = this.chunkSize;
                    this.headerSizeHex.delete(0, this.headerSizeHex.length());
                    if (this.chunkSize == 0) {
                        this.state = nextState;
                        continue;
                    }
                }
                if (this.chunkBytesRemaining > 0) {
                    int remainingInBuffer = this.bufferLength - this.bufferIndex;
                    lengthToCopy = Math.min(Math.min(this.chunkBytesRemaining, remainingInBuffer), dLen - dIndex);
                    if (lengthToCopy == 0) {
                        this.state = nextState;
                        ++this.bufferIndex;
                        return dIndex - dOff;
                    }
                } else {
                    this.state = nextState;
                    ++this.bufferIndex;
                    continue;
                }
                System.arraycopy(this.buffer, this.bufferIndex, destination, dIndex, lengthToCopy);
                this.bufferIndex += lengthToCopy;
                this.chunkBytesRead += lengthToCopy;
                this.chunkBytesRemaining -= lengthToCopy;
                this.state = nextState;
                if ((dIndex += lengthToCopy) != dLen) continue;
                continue block2;
            }
        }
        return (total = dIndex - dOff) == 0 ? -1 : total;
    }

    @Override
    public int read() throws IOException {
        int read = this.read(this.b1);
        if (read <= 0) {
            return read;
        }
        return this.b1[0] & 0xFF;
    }

    private void pushBackOverReadBytes() {
        int leftOver = this.bufferLength - this.bufferIndex;
        if (leftOver > 0) {
            this.delegate.push(this.buffer, this.bufferIndex, leftOver);
            this.bufferIndex = this.bufferLength;
        }
    }

    public static enum ChunkedBodyState {
        ChunkExtensionStart{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 13) {
                    return ChunkExtensionCR;
                }
                if (HTTPTools.isTokenCharacter(ch)) {
                    return ChunkExtensionName;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        ChunkExtensionName{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 13) {
                    return ChunkExtensionCR;
                }
                if (ch == 61) {
                    return ChunkExtensionValueSep;
                }
                if (ch == 59) {
                    return ChunkExtensionStart;
                }
                if (HTTPTools.isTokenCharacter(ch)) {
                    return ChunkExtensionName;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        ChunkExtensionValueSep{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 13) {
                    return ChunkExtensionCR;
                }
                if (ch == 59) {
                    return ChunkExtensionStart;
                }
                if (HTTPTools.isTokenCharacter(ch)) {
                    return ChunkExtensionValue;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        ChunkExtensionValue{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 13) {
                    return ChunkExtensionCR;
                }
                if (ch == 59) {
                    return ChunkExtensionStart;
                }
                if (HTTPTools.isTokenCharacter(ch)) {
                    return ChunkExtensionValue;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        ChunkExtensionCR{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 10) {
                    return ChunkExtensionLF;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        ChunkExtensionLF{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                return Chunk;
            }
        }
        ,
        ChunkSize{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 13) {
                    return ChunkSizeCR;
                }
                if (ch == 59) {
                    return ChunkExtensionStart;
                }
                if (HTTPTools.isHexadecimalCharacter(ch)) {
                    return ChunkSize;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        ChunkSizeCR{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 10) {
                    return ChunkSizeLF;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        ChunkSizeLF{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                return Chunk;
            }
        }
        ,
        Chunk{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (length == 0L) {
                    if (HTTPTools.isURICharacter(ch)) {
                        return Trailer;
                    }
                    return Complete;
                }
                if (bytesRead == length && ch == 13) {
                    return ChunkCR;
                }
                if (bytesRead < length) {
                    return Chunk;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        ChunkCR{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 10) {
                    return length == 0L ? Complete : ChunkLF;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        ChunkLF{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (length == 0L) {
                    return Complete;
                }
                if (HTTPTools.isHexadecimalCharacter(ch)) {
                    return ChunkSize;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        Complete{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                return Complete;
            }
        }
        ,
        Trailer{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 13) {
                    return TrailerCR;
                }
                return Trailer;
            }
        }
        ,
        TrailerCR{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 10) {
                    return TrailerLF;
                }
                throw HTTPTools.makeParseException(ch, this);
            }
        }
        ,
        TrailerLF{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (HTTPTools.isURICharacter(ch)) {
                    return Trailer;
                }
                return Complete;
            }
        };


        public abstract ChunkedBodyState next(byte var1, long var2, long var4);
    }
}

