/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HTTPContext {
    public Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    public Path baseDir;

    public HTTPContext(Path baseDir) {
        this.baseDir = baseDir;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public URL getResource(String path) throws IllegalStateException {
        String filePath = path;
        if (path.startsWith("/")) {
            filePath = path.substring(1);
        }
        try {
            Path resolved = this.baseDir.resolve(filePath);
            if (Files.exists(resolved, new LinkOption[0])) {
                return resolved.toUri().toURL();
            }
            return HTTPContext.class.getResource(path);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public Path resolve(String appPath) {
        if (appPath.startsWith("/")) {
            appPath = appPath.substring(1);
        }
        return this.baseDir.resolve(appPath);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }
}

