/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.BodyException;
import io.fusionauth.http.Buildable;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.FileInfo;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.io.MultipartStreamProcessor;
import io.fusionauth.http.util.HTTPTools;
import io.fusionauth.http.util.WeightedString;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class HTTPRequest
implements Buildable<HTTPRequest> {
    private final List<String> acceptEncodings = new LinkedList<String>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private final List<FileInfo> files = new LinkedList<FileInfo>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final List<Locale> locales = new LinkedList<Locale>();
    private final MultipartStreamProcessor multipartStreamProcessor = new MultipartStreamProcessor();
    private final Map<String, List<String>> urlParameters = new HashMap<String, List<String>>();
    private byte[] bodyBytes;
    private Map<String, List<String>> combinedParameters;
    private Long contentLength;
    private String contentType;
    private String contextPath;
    private Charset encoding = StandardCharsets.UTF_8;
    private Map<String, List<String>> formData;
    private String host;
    private InputStream inputStream;
    private String ipAddress;
    private HTTPMethod method;
    private boolean multipart;
    private String multipartBoundary;
    private String path = "/";
    private int port = -1;
    private String protocol;
    private String queryString;
    private String scheme;

    public HTTPRequest() {
        this.contextPath = "";
    }

    public HTTPRequest(String contextPath, @Deprecated int multipartBufferSize, String scheme, int port, String ipAddress) {
        Objects.requireNonNull(contextPath);
        Objects.requireNonNull(scheme);
        this.contextPath = contextPath;
        this.scheme = scheme;
        this.port = port;
        this.ipAddress = ipAddress;
        this.multipartStreamProcessor.getMultiPartConfiguration().withMultipartBufferSize(multipartBufferSize);
    }

    public HTTPRequest(String contextPath, String scheme, int port, String ipAddress) {
        Objects.requireNonNull(contextPath);
        Objects.requireNonNull(scheme);
        this.contextPath = contextPath;
        this.scheme = scheme;
        this.port = port;
        this.ipAddress = ipAddress;
    }

    public void addAcceptEncoding(String encoding) {
        this.acceptEncodings.add(encoding);
    }

    public void addAcceptEncodings(List<String> encodings) {
        this.acceptEncodings.addAll(encodings);
    }

    public void addCookies(Cookie ... cookies) {
        for (Cookie cookie : cookies) {
            this.cookies.put(cookie.name, cookie);
        }
    }

    public void addCookies(Collection<Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            this.cookies.put(cookie.name, cookie);
        }
    }

    public void addHeader(String name, String value) {
        name = name.toLowerCase();
        this.headers.computeIfAbsent(name, key -> new ArrayList()).add(value);
        this.decodeHeader(name, value);
    }

    public void addHeaders(String name, String ... values) {
        name = name.toLowerCase();
        this.headers.computeIfAbsent(name, key -> new ArrayList()).addAll(List.of(values));
        for (String value : values) {
            this.decodeHeader(name, value);
        }
    }

    public void addHeaders(String name, Collection<String> values) {
        name = name.toLowerCase();
        this.headers.computeIfAbsent(name, key -> new ArrayList()).addAll(values);
        for (String value : values) {
            this.decodeHeader(name, value);
        }
    }

    public void addHeaders(Map<String, List<String>> params) {
        params.forEach(this::addHeaders);
    }

    public void addLocales(Locale ... locales) {
        this.locales.addAll(Arrays.asList(locales));
    }

    public void addLocales(Collection<Locale> locales) {
        this.locales.addAll(locales);
    }

    public void addURLParameter(String name, String value) {
        this.urlParameters.computeIfAbsent(name, key -> new ArrayList()).add(value);
        this.combinedParameters = null;
    }

    public void addURLParameters(String name, String ... values) {
        this.urlParameters.computeIfAbsent(name, key -> new ArrayList()).addAll(List.of(values));
        this.combinedParameters = null;
    }

    public void addURLParameters(String name, Collection<String> values) {
        this.urlParameters.computeIfAbsent(name, key -> new ArrayList()).addAll(values);
        this.combinedParameters = null;
    }

    public void addURLParameters(Map<String, List<String>> params) {
        params.forEach(this::addURLParameters);
        this.combinedParameters = null;
    }

    public void deleteCookie(String name) {
        this.cookies.remove(name);
    }

    public List<String> getAcceptEncodings() {
        return this.acceptEncodings;
    }

    public void setAcceptEncodings(List<String> encodings) {
        this.acceptEncodings.clear();
        this.acceptEncodings.addAll(encodings);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getBaseURL() {
        String scheme = this.getScheme().toLowerCase();
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("The request scheme is invalid. Only http or https are valid schemes. The X-Forwarded-Proto header has a value of [" + this.getHeader("X-Forwarded-Proto") + "], this is likely an issue in your proxy configuration.");
        }
        String serverName = this.getHost().toLowerCase();
        int serverPort = this.getBaseURLServerPort();
        String uri = scheme + "://" + serverName;
        if (serverPort > 0 && (scheme.equalsIgnoreCase("http") && serverPort != 80 || scheme.equalsIgnoreCase("https") && serverPort != 443)) {
            uri = uri + ":" + serverPort;
        }
        return uri;
    }

    public byte[] getBodyBytes() throws BodyException {
        if (this.bodyBytes == null) {
            if (this.inputStream != null) {
                try {
                    this.bodyBytes = this.inputStream.readAllBytes();
                }
                catch (IOException e) {
                    throw new BodyException("Unable to read the HTTP request body bytes", e);
                }
            } else {
                this.bodyBytes = new byte[0];
            }
        }
        return this.bodyBytes;
    }

    public Charset getCharacterEncoding() {
        return this.encoding;
    }

    public void setCharacterEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Cookie getCookie(String name) {
        return this.cookies.get(name);
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    public Instant getDateHeader(String name) {
        String header = this.getHeader(name);
        return header != null ? ZonedDateTime.parse(header, DateTimeFormatter.RFC_1123_DATE_TIME).toInstant() : null;
    }

    public List<FileInfo> getFiles() {
        this.getFormData();
        return this.files;
    }

    public Map<String, List<String>> getFormData() {
        if (this.formData == null) {
            this.formData = new HashMap<String, List<String>>();
            String contentType = this.getContentType();
            if (contentType != null && contentType.equalsIgnoreCase("application/x-www-form-urlencoded")) {
                byte[] body = this.getBodyBytes();
                HTTPTools.parseEncodedData(body, 0, body.length, this.formData);
            } else if (this.isMultipart()) {
                try {
                    this.multipartStreamProcessor.process(this.inputStream, this.formData, this.files, this.multipartBoundary.getBytes());
                }
                catch (IOException e) {
                    throw new BodyException("Invalid multipart body.", e);
                }
            }
        }
        return this.formData;
    }

    public String getHeader(String name) {
        List<String> values = this.getHeaders(name);
        return values != null && !values.isEmpty() ? values.getFirst() : null;
    }

    public List<String> getHeaders(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> parameters) {
        this.headers.clear();
        parameters.forEach(this::setHeaders);
    }

    public String getHost() {
        int colon;
        String xHost = this.getHeader("X-Forwarded-Host");
        if (xHost == null) {
            return this.host;
        }
        String[] xHosts = xHost.split(",");
        if (xHosts.length > 1) {
            xHost = xHosts[0];
        }
        if ((colon = xHost.indexOf(58)) > 0) {
            return xHost.substring(0, colon);
        }
        return xHost.trim();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIPAddress() {
        String xIPAddress = this.getHeader("X-Forwarded-For");
        if (xIPAddress == null || xIPAddress.trim().length() == 0) {
            return this.ipAddress;
        }
        String[] ips = xIPAddress.split(",");
        if (ips.length < 1) {
            return xIPAddress.trim();
        }
        return ips[0].trim();
    }

    public void setIPAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.combinedParameters = null;
        this.formData = null;
    }

    public Locale getLocale() {
        return this.locales.size() > 0 ? this.locales.getFirst() : Locale.getDefault();
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public void setMethod(HTTPMethod method) {
        this.method = method;
    }

    public MultipartStreamProcessor getMultiPartStreamProcessor() {
        return this.multipartStreamProcessor;
    }

    public String getMultipartBoundary() {
        return this.multipartBoundary;
    }

    public String getParameter(String name) {
        List<String> values = this.getParameters().get(name);
        if (values != null && values.size() > 0) {
            return values.getFirst();
        }
        return null;
    }

    public Map<String, List<String>> getParameters() {
        if (this.combinedParameters == null) {
            this.combinedParameters = new HashMap<String, List<String>>();
            this.getURLParameters().forEach((name, values) -> this.combinedParameters.put((String)name, new LinkedList(values)));
            this.getFormData().forEach((name, value) -> this.combinedParameters.merge((String)name, (List<String>)value, (first, second) -> {
                first.addAll(second);
                return first;
            }));
        }
        return this.combinedParameters;
    }

    public List<String> getParameters(String name) {
        return this.getParameters().get(name);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.urlParameters.clear();
        byte[] chars = path.getBytes(StandardCharsets.UTF_8);
        int questionMark = path.indexOf(63);
        if (questionMark > 0 && questionMark != chars.length - 1) {
            this.queryString = new String(chars, questionMark + 1, chars.length - questionMark - 1);
            HTTPTools.parseEncodedData(chars, questionMark + 1, chars.length, this.urlParameters);
        }
        this.path = questionMark > 0 ? new String(chars, 0, questionMark) : path;
    }

    public int getPort() {
        String xPort = this.getHeader("X-Forwarded-Port");
        return xPort == null ? this.port : Integer.parseInt(xPort);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRawHost() {
        return this.host;
    }

    public String getRawIPAddress() {
        return this.ipAddress;
    }

    public int getRawPort() {
        return this.port;
    }

    public String getRawScheme() {
        return this.scheme;
    }

    public String getScheme() {
        String xScheme = this.getHeader("X-Forwarded-Proto");
        return xScheme == null ? this.scheme : xScheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getTransferEncoding() {
        return this.getHeader("Transfer-Encoding");
    }

    public String getURLParameter(String name) {
        List<String> values = this.urlParameters.get(name);
        return values != null && values.size() > 0 ? values.getFirst() : null;
    }

    public List<String> getURLParameters(String name) {
        return this.urlParameters.get(name);
    }

    public Map<String, List<String>> getURLParameters() {
        return this.urlParameters;
    }

    public void setURLParameters(Map<String, List<String>> parameters) {
        this.urlParameters.clear();
        this.urlParameters.putAll(parameters);
    }

    public boolean hasBody() {
        Long contentLength = this.getContentLength();
        return this.isChunked() || contentLength != null && contentLength > 0L;
    }

    public boolean isChunked() {
        return this.getTransferEncoding() != null && this.getTransferEncoding().equalsIgnoreCase("chunked");
    }

    public boolean isKeepAlive() {
        String connection = this.getHeader("Connection");
        if ("HTTP/1.0".equals(this.protocol)) {
            return connection != null && connection.equalsIgnoreCase("keep-alive");
        }
        return connection == null || !connection.equalsIgnoreCase("close");
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public void removeHeader(String name) {
        this.headers.remove(name.toLowerCase());
    }

    public void removeHeader(String name, String ... values) {
        List<String> actual = this.headers.get(name.toLowerCase());
        if (actual != null) {
            actual.removeAll(List.of(values));
        }
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setHeader(String name, String value) {
        name = name.toLowerCase();
        this.headers.put(name, new ArrayList<String>(List.of(value)));
        this.decodeHeader(name, value);
    }

    public void setHeaders(String name, String ... values) {
        name = name.toLowerCase();
        this.headers.put(name, new ArrayList<String>(List.of(values)));
        for (String value : values) {
            this.decodeHeader(name, value);
        }
    }

    public void setHeaders(String name, Collection<String> values) {
        name = name.toLowerCase();
        this.headers.put(name, new ArrayList<String>(values));
        for (String value : values) {
            this.decodeHeader(name, value);
        }
    }

    public void setURLParameter(String name, String value) {
        this.setURLParameters(name, value);
    }

    public void setURLParameters(String name, String ... values) {
        this.setURLParameters(name, new ArrayList<String>(List.of(values)));
    }

    public void setURLParameters(String name, Collection<String> values) {
        ArrayList list = new ArrayList();
        this.urlParameters.put(name, list);
        values.stream().filter(Objects::nonNull).forEach(list::add);
        this.combinedParameters = null;
    }

    private void decodeHeader(String name, String value) {
        switch (name) {
            case "accept-encoding": {
                TreeSet<WeightedString> weightedStrings = new TreeSet<WeightedString>();
                String[] parts = value.split(",");
                int index = 0;
                for (String part : parts) {
                    if ((part = part.trim()).isEmpty()) continue;
                    HTTPTools.HeaderValue parsed = HTTPTools.parseHeaderValue(part);
                    String weightText = parsed.parameters().get("q");
                    double weight = 1.0;
                    if (weightText != null) {
                        weight = Double.parseDouble(weightText);
                    }
                    WeightedString ws = new WeightedString(parsed.value(), weight, index);
                    weightedStrings.add(ws);
                    ++index;
                }
                this.setAcceptEncodings(weightedStrings.stream().map(WeightedString::value).toList());
                break;
            }
            case "accept-language": {
                try {
                    this.addLocales(Locale.LanguageRange.parse(value).stream().sorted(Comparator.comparing(Locale.LanguageRange::getWeight).reversed()).map(Locale.LanguageRange::getRange).map(Locale::forLanguageTag).collect(Collectors.toList()));
                }
                catch (Exception exception) {}
                break;
            }
            case "content-type": {
                String charset;
                this.encoding = null;
                this.multipart = false;
                HTTPTools.HeaderValue headerValue = HTTPTools.parseHeaderValue(value);
                this.contentType = headerValue.value();
                if (headerValue.value().startsWith("multipart/")) {
                    this.multipart = true;
                    this.multipartBoundary = headerValue.parameters().get("boundary");
                }
                if ((charset = headerValue.parameters().get("charset")) == null) break;
                this.encoding = Charset.forName(charset);
                break;
            }
            case "content-length": {
                if (value == null || value.isBlank()) {
                    this.contentLength = null;
                    break;
                }
                try {
                    this.contentLength = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    this.contentLength = null;
                }
                break;
            }
            case "cookie": {
                this.addCookies(Cookie.fromRequestHeader(value));
                break;
            }
            case "host": {
                int colon = value.indexOf(58);
                if (colon > 0) {
                    this.host = value.substring(0, colon);
                    String portString = value.substring(colon + 1);
                    if (portString.length() <= 0) break;
                    try {
                        this.port = Integer.parseInt(portString);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                this.host = value;
            }
        }
    }

    private int getBaseURLServerPort() {
        int serverPort = this.getPort();
        if (this.scheme.equalsIgnoreCase("http") && serverPort == 80) {
            serverPort = -1;
        }
        if (this.getHeader("X-Forwarded-Port") != null) {
            return serverPort;
        }
        String xHost = this.getHeader("X-Forwarded-Host");
        if (xHost == null) {
            return serverPort;
        }
        try {
            int hostPort = URI.create("https://" + xHost).getPort();
            if (hostPort != -1) {
                return hostPort;
            }
        }
        catch (Exception ignore) {
            return serverPort;
        }
        if (!"https".equals(this.getHeader("X-Forwarded-Proto"))) {
            return serverPort;
        }
        return 443;
    }
}

