/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.util;

import io.fusionauth.http.util.HTTPTools;

public enum RequestPreambleState {
    RequestMethod{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 32) {
                return RequestMethodSP;
            }
            if (HTTPTools.isTokenCharacter(ch)) {
                return RequestMethod;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    RequestMethodSP{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 32) {
                return RequestMethodSP;
            }
            if (HTTPTools.isURICharacter(ch)) {
                return RequestPath;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    RequestPath{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 32) {
                return RequestPathSP;
            }
            if (HTTPTools.isURICharacter(ch)) {
                return RequestPath;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    RequestPathSP{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 32) {
                return RequestPathSP;
            }
            if (HTTPTools.isURICharacter(ch)) {
                return RequestProtocol;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    RequestProtocol{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 72 || ch == 84 || ch == 80 || ch == 47 || ch == 46 || ch >= 48 && ch <= 57) {
                return RequestProtocol;
            }
            if (ch == 13) {
                return RequestCR;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    RequestCR{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 10) {
                return RequestLF;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    RequestLF{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 13) {
                return PreambleCR;
            }
            if (HTTPTools.isTokenCharacter(ch)) {
                return HeaderName;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    HeaderName{

        @Override
        public RequestPreambleState next(byte ch) {
            if (HTTPTools.isTokenCharacter(ch)) {
                return HeaderName;
            }
            if (ch == 58) {
                return HeaderColon;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    HeaderColon{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 32) {
                return HeaderColon;
            }
            if (ch == 13) {
                return HeaderCR;
            }
            return HeaderValue;
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    HeaderValue{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 13) {
                return HeaderCR;
            }
            if (HTTPTools.isValueCharacter(ch)) {
                return HeaderValue;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    HeaderCR{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 10) {
                return HeaderLF;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    HeaderLF{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 13) {
                return PreambleCR;
            }
            if (HTTPTools.isTokenCharacter(ch)) {
                return HeaderName;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    PreambleCR{

        @Override
        public RequestPreambleState next(byte ch) {
            if (ch == 10) {
                return Complete;
            }
            throw HTTPTools.makeParseException(ch, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    Complete{

        @Override
        public RequestPreambleState next(byte ch) {
            return null;
        }

        @Override
        public boolean store() {
            return false;
        }
    };


    public abstract RequestPreambleState next(byte var1);

    public abstract boolean store();
}

