/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.server.Instrumenter;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends InputStream {
    private final byte[] b1 = new byte[1];
    private final InputStream delegate;
    private final Instrumenter instrumenter;
    private byte[] buffer;
    private int bufferEndPosition;
    private int bufferPosition;

    public PushbackInputStream(InputStream delegate, Instrumenter instrumenter) {
        this.delegate = delegate;
        this.instrumenter = instrumenter;
    }

    public int getAvailableBufferedBytesRemaining() {
        return this.buffer != null ? this.bufferEndPosition - this.bufferPosition : 0;
    }

    public void push(byte[] buffer, int offset, int length) {
        if (this.buffer != null) {
            throw new IllegalStateException("You are not allowed to push more bytes back on to the InputStream until you have read the previously pushed bytes.");
        }
        this.buffer = buffer;
        this.bufferPosition = offset;
        this.bufferEndPosition = offset + length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer != null) {
            int read = Math.min(len, this.bufferEndPosition - this.bufferPosition);
            System.arraycopy(this.buffer, this.bufferPosition, b, off, read);
            this.bufferPosition += read;
            if (this.bufferPosition >= this.bufferEndPosition) {
                this.buffer = null;
                this.bufferPosition = -1;
                this.bufferEndPosition = -1;
            }
            return read;
        }
        int read = this.delegate.read(b, off, len);
        if (read > 0 && this.instrumenter != null) {
            this.instrumenter.readFromClient(read);
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        int read = this.read(this.b1);
        if (read <= 0) {
            return read;
        }
        return this.b1[0] & 0xFF;
    }
}

