/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.server.Instrumenter;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadSafeCountingInstrumenter
implements Instrumenter {
    private final AtomicLong acceptedConnections = new AtomicLong();
    private final AtomicLong acceptedRequests = new AtomicLong();
    private final AtomicLong badRequests = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong chunkedRequests = new AtomicLong();
    private final AtomicLong chunkedResponses = new AtomicLong();
    private final AtomicLong closedConnections = new AtomicLong();
    private final AtomicLong servers = new AtomicLong();
    private final AtomicLong workers = new AtomicLong();

    @Override
    public void acceptedConnection() {
        this.acceptedConnections.incrementAndGet();
    }

    @Override
    public void acceptedRequest() {
        this.acceptedRequests.incrementAndGet();
    }

    @Override
    public void badRequest() {
        this.badRequests.incrementAndGet();
    }

    @Override
    public void chunkedRequest() {
        this.chunkedRequests.incrementAndGet();
    }

    @Override
    public void chunkedResponse() {
        this.chunkedResponses.incrementAndGet();
    }

    @Override
    public void connectionClosed() {
        this.closedConnections.incrementAndGet();
    }

    public long getAcceptedConnections() {
        return this.acceptedConnections.get();
    }

    public long getAcceptedRequests() {
        return this.acceptedRequests.get();
    }

    public long getBadRequests() {
        return this.badRequests.get();
    }

    public long getBytesRead() {
        return this.bytesRead.get();
    }

    public long getBytesWritten() {
        return this.bytesWritten.get();
    }

    public long getChunkedRequests() {
        return this.chunkedRequests.get();
    }

    public long getChunkedResponses() {
        return this.chunkedResponses.get();
    }

    public long getClosedConnections() {
        return this.closedConnections.get();
    }

    public long getServers() {
        return this.servers.get();
    }

    public long getWorkers() {
        return this.workers.get();
    }

    @Override
    public void readFromClient(long bytes) {
        this.bytesRead.addAndGet(bytes);
    }

    @Override
    public void serverStarted() {
        this.servers.incrementAndGet();
    }

    @Override
    public void workerStarted() {
        this.workers.incrementAndGet();
    }

    @Override
    public void workerStopped() {
        this.workers.decrementAndGet();
    }

    @Override
    public void wroteToClient(long bytes) {
        this.bytesWritten.addAndGet(bytes);
    }
}

