/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.internal;

import io.fusionauth.http.io.FastByteArrayOutputStream;
import io.fusionauth.http.server.HTTPServerConfiguration;

public class HTTPBuffers {
    private final HTTPServerConfiguration configuration;
    private final byte[] requestBuffer;
    private final byte[] responseBuffer;
    private byte[] chunkBuffer;
    private FastByteArrayOutputStream chunkOutputStream;

    public HTTPBuffers(HTTPServerConfiguration configuration) {
        this.configuration = configuration;
        this.requestBuffer = new byte[configuration.getRequestBufferSize()];
        int responseBufferSize = configuration.getResponseBufferSize();
        this.responseBuffer = (byte[])(responseBufferSize > 0 ? new byte[responseBufferSize] : null);
    }

    public FastByteArrayOutputStream chuckedOutputStream() {
        if (this.chunkOutputStream == null) {
            this.chunkOutputStream = new FastByteArrayOutputStream(this.configuration.getMaxResponseChunkSize() + 64, 64);
        }
        return this.chunkOutputStream;
    }

    public byte[] chunkBuffer() {
        if (this.chunkBuffer == null) {
            this.chunkBuffer = new byte[this.configuration.getMaxResponseChunkSize()];
        }
        return this.chunkBuffer;
    }

    public byte[] requestBuffer() {
        return this.requestBuffer;
    }

    public byte[] responseBuffer() {
        return this.responseBuffer;
    }
}

