/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.internal;

import io.fusionauth.http.HTTPProcessingException;
import io.fusionauth.http.ParseException;
import io.fusionauth.http.io.MultipartConfiguration;
import io.fusionauth.http.io.MultipartFileManager;
import io.fusionauth.http.io.MultipartStreamProcessor;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.ExceptionHandlerContext;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.internal.HTTPBuffers;
import io.fusionauth.http.server.io.ConnectionClosedException;
import io.fusionauth.http.server.io.HTTPInputStream;
import io.fusionauth.http.server.io.HTTPOutputStream;
import io.fusionauth.http.server.io.Throughput;
import io.fusionauth.http.server.io.ThroughputInputStream;
import io.fusionauth.http.server.io.ThroughputOutputStream;
import io.fusionauth.http.server.io.TooManyBytesToDrainException;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;

public class HTTPWorker
implements Runnable {
    private final HTTPBuffers buffers;
    private final HTTPServerConfiguration configuration;
    private final PushbackInputStream inputStream;
    private final Instrumenter instrumenter;
    private final HTTPListenerConfiguration listener;
    private final Logger logger;
    private final Socket socket;
    private final long startInstant;
    private final Throughput throughput;
    private long handledRequests;
    private volatile State state;

    public HTTPWorker(Socket socket, HTTPServerConfiguration configuration, Instrumenter instrumenter, HTTPListenerConfiguration listener, Throughput throughput) throws IOException {
        this.socket = socket;
        this.configuration = configuration;
        this.instrumenter = instrumenter;
        this.listener = listener;
        this.throughput = throughput;
        this.buffers = new HTTPBuffers(configuration);
        this.logger = configuration.getLoggerFactory().getLogger(HTTPWorker.class);
        this.inputStream = new PushbackInputStream(new ThroughputInputStream(socket.getInputStream(), throughput), instrumenter);
        this.state = State.Read;
        this.startInstant = System.currentTimeMillis();
        this.logger.trace("[{}] Starting HTTP worker.", Thread.currentThread().threadId());
    }

    public long getHandledRequests() {
        return this.handledRequests;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public long getStartInstant() {
        return this.startInstant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        HTTPRequest request = null;
        HTTPResponse response = null;
        try {
            if (this.instrumenter != null) {
                this.instrumenter.workerStarted();
            }
            while (true) {
                HTTPInputStream httpInputStream;
                block46: {
                    Iterator<Path> iterator;
                    int availableBufferedBytes;
                    this.logger.trace("[{}] Running HTTP worker. Block while we wait to read the preamble", Thread.currentThread().threadId());
                    request = new HTTPRequest(this.configuration.getContextPath(), this.listener.getCertificate() != null ? "https" : "http", this.listener.getPort(), this.socket.getInetAddress().getHostAddress());
                    request.getMultiPartStreamProcessor().setMultipartConfiguration(new MultipartConfiguration(this.configuration.getMultipartConfiguration()));
                    ThroughputOutputStream throughputOutputStream = new ThroughputOutputStream(this.socket.getOutputStream(), this.throughput);
                    response = new HTTPResponse();
                    HTTPOutputStream outputStream = new HTTPOutputStream(this.configuration, request.getAcceptEncodings(), response, throughputOutputStream, this.buffers, () -> {
                        this.state = State.Write;
                    });
                    response.setOutputStream(outputStream);
                    byte[] requestBuffer = this.buffers.requestBuffer();
                    HTTPTools.parseRequestPreamble(this.inputStream, this.configuration.getMaxRequestHeaderSize(), request, requestBuffer, () -> {
                        this.state = State.Read;
                    });
                    if (this.logger.isTraceEnabled() && (availableBufferedBytes = this.inputStream.getAvailableBufferedBytesRemaining()) != 0) {
                        this.logger.trace("[{}] Preamble parser had [{}] left over bytes. These will be used in the HTTPInputStream.", availableBufferedBytes);
                    }
                    ++this.handledRequests;
                    if (this.instrumenter != null) {
                        this.instrumenter.acceptedRequest();
                    }
                    int maximumContentLength = HTTPTools.getMaxRequestBodySize(request.getContentType(), this.configuration.getMaxRequestBodySize());
                    httpInputStream = new HTTPInputStream(this.configuration, request, this.inputStream, maximumContentLength);
                    request.setInputStream(httpInputStream);
                    response.setHeader("Connection", request.isKeepAlive() ? "keep-alive" : "close");
                    Integer status = this.validatePreamble(request);
                    if (status != null) {
                        this.closeSocketOnError(response, status);
                        return;
                    }
                    String expect = request.getHeader("Expect");
                    if (expect != null && expect.equalsIgnoreCase("100-continue")) {
                        this.state = State.Write;
                        boolean doContinue = this.handleExpectContinue(request);
                        if (!doContinue) {
                            this.closeSocketOnly(CloseSocketReason.Expected);
                            return;
                        }
                        this.state = State.Read;
                    }
                    this.state = State.Process;
                    this.logger.trace("[{}] Set state [{}]. Call the request handler.", new Object[]{Thread.currentThread().threadId(), this.state});
                    try {
                        this.configuration.getHandler().handle(request, response);
                        this.logger.trace("[{}] Handler completed successfully", Thread.currentThread().threadId());
                        MultipartStreamProcessor multiPartProcessor = request.getMultiPartStreamProcessor();
                        if (!multiPartProcessor.getMultiPartConfiguration().isDeleteTemporaryFiles()) break block46;
                        MultipartFileManager fileManager = multiPartProcessor.getMultipartFileManager();
                        iterator = fileManager.getTemporaryFiles().iterator();
                    }
                    catch (Throwable throwable) {
                        MultipartStreamProcessor multiPartProcessor = request.getMultiPartStreamProcessor();
                        if (!multiPartProcessor.getMultiPartConfiguration().isDeleteTemporaryFiles()) throw throwable;
                        MultipartFileManager fileManager2 = multiPartProcessor.getMultipartFileManager();
                        Iterator<Path> iterator2 = fileManager2.getTemporaryFiles().iterator();
                        while (iterator2.hasNext()) {
                            Path file = iterator2.next();
                            try {
                                this.logger.debug("Delete temporary file [{}]", file);
                                Files.deleteIfExists(file);
                            }
                            catch (Exception e) {
                                this.logger.error("Unable to delete temporary file. [" + String.valueOf(file) + "]", e);
                            }
                        }
                        throw throwable;
                    }
                    while (iterator.hasNext()) {
                        Path file = iterator.next();
                        try {
                            this.logger.debug("Delete temporary file [{}]", file);
                            Files.deleteIfExists(file);
                        }
                        catch (Exception e) {
                            this.logger.error("Unable to delete temporary file. [" + String.valueOf(file) + "]", e);
                        }
                    }
                }
                if (this.handledRequests >= (long)this.configuration.getMaxRequestsPerConnection()) {
                    this.logger.trace("[{}] Maximum requests per connection has been reached. Turn off Keep-Alive.", Thread.currentThread().threadId());
                    response.setHeader("Connection", "close");
                }
                response.close();
                boolean keepSocketAlive = this.keepSocketAlive(request, response);
                if (!keepSocketAlive) {
                    this.logger.trace("[{}] Closing socket. No Keep-Alive.", Thread.currentThread().threadId());
                    this.closeSocketOnly(CloseSocketReason.Expected);
                    return;
                }
                this.state = State.KeepAlive;
                int soTimeout = (int)this.configuration.getKeepAliveTimeoutDuration().toMillis();
                this.logger.trace("[{}] Enter Keep-Alive state [{}] Reset socket timeout [{}].", new Object[]{Thread.currentThread().threadId(), this.state, soTimeout});
                this.socket.setSoTimeout(soTimeout);
                long startDrain = System.currentTimeMillis();
                int drained = httpInputStream.drain();
                if (drained <= 0 || !this.logger.isTraceEnabled()) continue;
                long drainDuration = System.currentTimeMillis() - startDrain;
                this.logger.trace("[{}] Drained [{}] bytes from the InputStream. Duration [{}] ms.", Thread.currentThread().threadId(), drained, drainDuration);
                continue;
                break;
            }
        }
        catch (ConnectionClosedException e) {
            this.logger.trace("[{}] Closing socket. Client closed the connection. Reason [{}].", Thread.currentThread().threadId(), e.getMessage());
            this.closeSocketOnly(CloseSocketReason.Expected);
            return;
        }
        catch (HTTPProcessingException e) {
            this.logger.trace("[{}] Closing socket with status [{}]. An unhandled [{}] exception was taken. Reason [{}].", Thread.currentThread().threadId(), e.getStatus(), e.getClass().getSimpleName(), e.getMessage());
            this.closeSocketOnError(response, e.getStatus());
            return;
        }
        catch (TooManyBytesToDrainException e) {
            this.logger.debug("[{}] Closing socket [{}]. Too many bytes remaining in the InputStream. Drained [{}] bytes. Configured maximum bytes [{}].", new Object[]{Thread.currentThread().threadId(), this.state, e.getDrainedBytes(), e.getMaximumDrainedBytes()});
            this.closeSocketOnly(CloseSocketReason.Expected);
            return;
        }
        catch (SocketTimeoutException e) {
            String message;
            CloseSocketReason reason = this.state == State.KeepAlive ? CloseSocketReason.Expected : CloseSocketReason.Unexpected;
            String string = message = this.state == State.Read ? "Initial read timeout" : "Keep-Alive expired";
            if (reason == CloseSocketReason.Expected) {
                this.logger.trace("[{}] Closing socket [{}]. {}.", new Object[]{Thread.currentThread().threadId(), this.state, message});
            } else {
                this.logger.debug("[{}] Closing socket [{}]. {}.", new Object[]{Thread.currentThread().threadId(), this.state, message});
            }
            this.closeSocketOnly(reason);
            return;
        }
        catch (ParseException e) {
            this.logger.debug("[{}] Closing socket with status [{}]. Bad request, failed to parse request. Reason [{}] Parser state [{}]", Thread.currentThread().threadId(), 400, e.getMessage(), e.getState());
            this.closeSocketOnError(response, 400);
            return;
        }
        catch (SocketException e) {
            if (Thread.currentThread().isInterrupted()) {
                this.logger.debug("[{}] Closing socket. Server is shutting down.", Thread.currentThread().threadId());
            } else {
                this.logger.debug("[{}] Closing socket. The socket was closed by a client, proxy or otherwise.", Thread.currentThread().threadId());
            }
            this.closeSocketOnly(CloseSocketReason.Expected);
            return;
        }
        catch (IOException e) {
            this.logger.debug(String.format("[%s] Closing socket with status [%d]. An IO exception was thrown during processing. These are pretty common.", Thread.currentThread().threadId(), 500), e);
            this.closeSocketOnError(response, 500);
            return;
        }
        catch (Throwable e) {
            ExceptionHandlerContext context = new ExceptionHandlerContext(this.logger, request, 500, e);
            try {
                this.configuration.getUnexpectedExceptionHandler().handle(context);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.closeSocketOnError(response, context.getStatusCode());
            return;
        }
        finally {
            if (this.instrumenter != null) {
                this.instrumenter.workerStopped();
            }
        }
    }

    public State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocketOnError(HTTPResponse response, int status) {
        if (status >= 400 && status <= 499 && this.instrumenter != null) {
            this.instrumenter.badRequest();
        }
        try {
            if (response != null && !response.isCommitted()) {
                response.reset();
                response.setHeader("Connection", "close");
                response.setStatus(status);
                response.setContentLength(0L);
                response.close();
            }
        }
        catch (IOException e) {
            this.logger.debug(String.format("[%s] Could not close the HTTP response.", Thread.currentThread().threadId()), e);
        }
        finally {
            this.closeSocketOnly(CloseSocketReason.Unexpected);
        }
    }

    private void closeSocketOnly(CloseSocketReason reason) {
        if (reason == CloseSocketReason.Unexpected && this.instrumenter != null) {
            this.instrumenter.connectionClosed();
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.logger.debug(String.format("[%s] Could not close the socket.", Thread.currentThread().threadId()), e);
        }
    }

    private boolean handleExpectContinue(HTTPRequest request) throws IOException {
        HTTPResponse expectResponse = new HTTPResponse();
        this.configuration.getExpectValidator().validate(request, expectResponse);
        OutputStream out = this.socket.getOutputStream();
        HTTPTools.writeResponsePreamble(expectResponse, out);
        out.flush();
        return expectResponse.getStatus() == 100;
    }

    private boolean keepSocketAlive(HTTPRequest request, HTTPResponse response) {
        String connectionHeader = response.getHeader("Connection");
        return request.getProtocol().equals("HTTP/1.1") ? !"close".equalsIgnoreCase(connectionHeader) : "keep-alive".equalsIgnoreCase(connectionHeader);
    }

    private Integer validatePreamble(HTTPRequest request) {
        boolean debugEnabled = this.logger.isDebugEnabled();
        String protocol = request.getProtocol();
        if (protocol == null) {
            this.logger.debug("Invalid request. Missing HTTP Protocol");
            return 400;
        }
        if (!protocol.startsWith("HTTP/")) {
            if (debugEnabled) {
                this.logger.debug("Invalid request. Invalid protocol [{}]. Supported versions [{}].", protocol, "HTTP/1.1");
            }
            return 400;
        }
        if (!protocol.equals("HTTP/1.0") && !protocol.equals("HTTP/1.1")) {
            if (debugEnabled) {
                this.logger.debug("Invalid request. Unsupported HTTP version [{}]. Supported versions [{}].", protocol, "HTTP/1.1");
            }
            return 505;
        }
        String host = request.getRawHost();
        if (host == null) {
            this.logger.debug("Invalid request. Missing Host header.");
            return 400;
        }
        List<String> hostHeaders = request.getHeaders("Host");
        if (hostHeaders.size() != 1) {
            if (debugEnabled) {
                this.logger.debug("Invalid request. Duplicate Host headers. [{}]", String.join((CharSequence)", ", hostHeaders));
            }
            return 400;
        }
        if (request.getHeader("Transfer-Encoding") == null) {
            Long contentLength = request.getContentLength();
            List<String> requestedContentLengthHeaders = request.getHeaders("Content-Length");
            if (requestedContentLengthHeaders != null) {
                if (requestedContentLengthHeaders.size() != 1) {
                    if (debugEnabled) {
                        this.logger.debug("Invalid request. Duplicate Content-Length headers. [{}]", String.join((CharSequence)", ", requestedContentLengthHeaders));
                    }
                    return 400;
                }
                if (contentLength == null || contentLength < 0L) {
                    if (debugEnabled) {
                        this.logger.debug("Invalid request. The Content-Length must be >= 0 and <= 9,223,372,036,854,775,807. [{}]", requestedContentLengthHeaders.getFirst());
                    }
                    return 400;
                }
            }
        } else {
            request.setContentLength(null);
            request.removeHeader("Content-Length");
        }
        return null;
    }

    public static enum State {
        Read,
        Process,
        Write,
        KeepAlive;

    }

    private static enum CloseSocketReason {
        Expected,
        Unexpected;

    }

    private static class Status {
        public static final int BadRequest = 400;
        public static final int HTTPVersionNotSupported = 505;
        public static final int InternalServerError = 500;

        private Status() {
        }
    }
}

