/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.io;

import io.fusionauth.http.ContentTooLargeException;
import io.fusionauth.http.io.ChunkedInputStream;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.io.TooManyBytesToDrainException;
import java.io.IOException;
import java.io.InputStream;

public class HTTPInputStream
extends InputStream {
    private final byte[] b1 = new byte[1];
    private final int chunkedBufferSize;
    private final Instrumenter instrumenter;
    private final Logger logger;
    private final int maximumBytesToDrain;
    private final int maximumContentLength;
    private final PushbackInputStream pushbackInputStream;
    private final HTTPRequest request;
    private int bytesRead;
    private long bytesRemaining;
    private boolean closed;
    private boolean committed;
    private InputStream delegate;
    private boolean drained;

    public HTTPInputStream(HTTPServerConfiguration configuration, HTTPRequest request, PushbackInputStream pushbackInputStream, int maximumContentLength) {
        this.logger = configuration.getLoggerFactory().getLogger(HTTPInputStream.class);
        this.instrumenter = configuration.getInstrumenter();
        this.request = request;
        this.delegate = pushbackInputStream;
        this.pushbackInputStream = pushbackInputStream;
        this.chunkedBufferSize = configuration.getChunkedBufferSize();
        this.maximumBytesToDrain = configuration.getMaxBytesToDrain();
        this.maximumContentLength = maximumContentLength;
        if (request.getContentLength() != null) {
            this.bytesRemaining = request.getContentLength();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.drained) {
            return;
        }
        this.drain();
    }

    public int drain() throws IOException {
        int skipped;
        if (this.drained) {
            return 0;
        }
        this.drained = true;
        int total = 0;
        byte[] skipBuffer = new byte[2048];
        while ((skipped = this.read(skipBuffer)) >= 0) {
            if ((total += skipped) <= this.maximumBytesToDrain) continue;
            throw new TooManyBytesToDrainException(total, this.maximumBytesToDrain);
        }
        return total;
    }

    @Override
    public int read() throws IOException {
        int read = this.read(this.b1);
        if (read <= 0) {
            return read;
        }
        return this.b1[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        boolean fixedLength;
        if (len == 0) {
            return 0;
        }
        boolean bl = fixedLength = !this.request.isChunked();
        if (fixedLength && this.bytesRemaining <= 0L) {
            return -1;
        }
        if (!this.committed) {
            this.commit();
        }
        int maxReadLen = this.maximumContentLength == -1 ? len : Math.min(len, this.maximumContentLength - this.bytesRead + 1);
        int reportBytesRead = read = this.delegate.read(b, off, maxReadLen);
        if (fixedLength && read > 0) {
            int extraBytes = (int)((long)read - this.bytesRemaining);
            if (extraBytes > 0) {
                reportBytesRead -= extraBytes;
                this.pushbackInputStream.push(b, (int)this.bytesRemaining, extraBytes);
            }
            this.bytesRemaining -= (long)reportBytesRead;
        }
        this.bytesRead += reportBytesRead;
        if (this.maximumContentLength != -1 && this.bytesRead > this.maximumContentLength) {
            String detailedMessage = "The maximum request size has been exceeded. The maximum request size is [" + this.maximumContentLength + "] bytes.";
            throw new ContentTooLargeException((long)this.maximumContentLength, detailedMessage);
        }
        return reportBytesRead;
    }

    private void commit() {
        boolean hasBody;
        this.committed = true;
        Long contentLength = this.request.getContentLength();
        boolean bl = hasBody = contentLength != null && contentLength > 0L || this.request.isChunked();
        if (!hasBody) {
            this.delegate = InputStream.nullInputStream();
        } else if (this.request.isChunked()) {
            this.logger.trace("Client indicated it was sending an entity-body in the request. Handling body using chunked encoding.");
            this.delegate = new ChunkedInputStream(this.pushbackInputStream, this.chunkedBufferSize);
            if (this.instrumenter != null) {
                this.instrumenter.chunkedRequest();
            }
        } else if (contentLength != null) {
            this.logger.trace("Client indicated it was sending an entity-body in the request. Handling body using Content-Length header {}.", contentLength);
        } else {
            this.logger.trace("Client indicated it was NOT sending an entity-body in the request");
        }
        if (contentLength != null && this.maximumContentLength != -1 && contentLength > (long)this.maximumContentLength) {
            String detailedMessage = "The maximum request size has been exceeded. The reported Content-Length is [" + contentLength + "] and the maximum request size is [" + this.maximumContentLength + "] bytes.";
            throw new ContentTooLargeException((long)this.maximumContentLength, detailedMessage);
        }
    }
}

