/*
 * Decompiled with CFR 0.152.
 */
package strInfo.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import strInfo.manager.SQLParserManager;
import strInfo.parser.SQLParser;
import strInfo.result.AlterStatement;
import strInfo.result.AlterStatementBuilder;

public class AlterParser
implements SQLParser<AlterStatement, AlterStatementBuilder> {
    private static final String Name = "alter";
    private static final Pattern ALTER_PATTERN = Pattern.compile("alter\\s+?table\\s*?(\\S*)\\s+?(add|drop|rename|change)", 2);
    private static final Pattern ADD_PATTERN = Pattern.compile("add\\s+?(\\S+)\\s?", 2);
    private static final Pattern ADD_COLUMN_PATTERN = Pattern.compile("add\\s*?([\\s\\S]*?);", 2);
    private static final Pattern ADD_INFO_PATTERN = Pattern.compile("add\\s*?\\S+?\\s*?(\\S+)\\s+?\\(([\\s\\S]+?)\\);", 2);
    private static final Pattern DROP_PATTERN = Pattern.compile("drop\\s+?([\\S]*?)\\s*?;", 2);
    private static final Pattern RENAME_PATTERN = Pattern.compile("rename\\s+?([\\S]*?)\\s*?;", 2);
    private static final Pattern CHANGE_PATTERN = Pattern.compile("change\\s+?(\\S+)\\s+?([\\s\\S]+?)\\s*?;", 2);

    public static AlterParser getInstance() {
        AlterParser sqlParserByName = SQLParserManager.getSQLParserByName(Name);
        if (sqlParserByName == null) {
            sqlParserByName = new AlterParser();
            SQLParserManager.register(sqlParserByName);
        }
        return sqlParserByName;
    }

    @Override
    public String getName() {
        return Name;
    }

    @Override
    public AlterStatement parseSql(String sql) {
        return this.parseSqlByWord(AlterStatement.builder(), 0, sql, Name);
    }

    @Override
    public AlterStatement parseSqlByWord(AlterStatementBuilder StatementBuilder, int startIndex, String sql, String sqlWord) {
        if (";".equals(sqlWord)) {
            return StatementBuilder.create();
        }
        int wordNum = AlterStatement.getWordNum(sqlWord, 8);
        if (wordNum == AlterStatement.ALTER_WORD) {
            Matcher matcher = ALTER_PATTERN.matcher(sql);
            if (matcher.find(startIndex)) {
                String mod = matcher.group(2);
                return this.parseSqlByWord(StatementBuilder.setAlterStr(matcher.group().substring(5)).setSql(sql).setMod(mod).setTableName(matcher.group(1)), 5, sql, mod);
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        if (wordNum == AlterStatement.ADD_WORD) {
            Matcher matcher = ADD_PATTERN.matcher(sql);
            if (matcher.find(startIndex)) {
                String addInFo = matcher.group(1);
                int addWordNum = AlterStatement.getWordNum(addInFo, 8);
                if (addWordNum == AlterStatement.INDEX_WORD) {
                    Matcher matcher1 = ADD_INFO_PATTERN.matcher(sql);
                    if (matcher1.find(startIndex)) {
                        return this.parseSqlByWord(StatementBuilder.setAddStr(matcher.group() + ' ' + matcher1.group()).setAddINFO(addInFo).setIndexName(matcher1.group(1)).setFieldStr(matcher1.group(2)), matcher1.end(), sql, ";");
                    }
                    throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
                }
                if (addWordNum == AlterStatement.UNIQUE_WORD || addWordNum == AlterStatement.PRIMARY_WORD) {
                    Matcher matcher1 = ADD_INFO_PATTERN.matcher(sql);
                    if (matcher1.find(startIndex)) {
                        return this.parseSqlByWord(StatementBuilder.setAddStr(matcher.group() + ' ' + matcher1.group()).setAddINFO(addInFo).setFieldStr(matcher1.group(2)), matcher1.end(), sql, ";");
                    }
                    throw new RuntimeException("add \u7ea6\u675f\u5b50\u53e5\u89e3\u6790\u9519\u8bef\u3002\nError parsing add constraint clause.\nERROR SQL => " + sql.substring(startIndex));
                }
                Matcher matcher1 = ADD_COLUMN_PATTERN.matcher(sql);
                if (matcher1.find(startIndex)) {
                    return this.parseSqlByWord(StatementBuilder.setAddStr(matcher1.group()).setAddINFO("field").setFieldStr(matcher1.group(1)), matcher1.end(), sql, ";");
                }
                throw new RuntimeException("add \u5b57\u6bb5\u5b50\u53e5\u89e3\u6790\u9519\u8bef\u3002\nParsing error of add field clause.\nERROR SQL => " + sql.substring(startIndex));
            }
            throw new RuntimeException("add \u5b50\u53e5\u7684\u8bed\u6cd5\u53d1\u751f\u4e86\u9519\u8bef!!!\nError occurred in syntax of add clause!!!\nERROR SQL => " + sql.substring(startIndex));
        }
        if (wordNum == AlterStatement.RENAME_WORD) {
            Matcher matcher = RENAME_PATTERN.matcher(sql);
            if (matcher.find(startIndex)) {
                return this.parseSqlByWord(StatementBuilder.setRenameStr(matcher.group(1)), matcher.end(), sql, ";");
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        if (wordNum == AlterStatement.DROP_WORD) {
            Matcher matcher = DROP_PATTERN.matcher(sql);
            if (matcher.find(startIndex)) {
                String dropCol = matcher.group(1);
                return this.parseSqlByWord(StatementBuilder.setDropStr(dropCol).setFieldStr(dropCol), matcher.end(), sql, ";");
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        if (wordNum == AlterStatement.CHANGE_WORD) {
            Matcher matcher = CHANGE_PATTERN.matcher(sql);
            if (matcher.find(startIndex)) {
                return this.parseSqlByWord(StatementBuilder.setChangeStr(matcher.group(2)).setFieldStr(matcher.group(1)), matcher.end(), sql, ";");
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u89e3\u6790\u8bcd\uff1a" + sqlWord);
    }
}

