/*
 * Decompiled with CFR 0.152.
 */
package strInfo.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import strInfo.manager.SQLParserManager;
import strInfo.parser.SQLParser;
import strInfo.parser.SelectParser;
import strInfo.result.CreateStatement;
import strInfo.result.CreateStatementBuilder;
import strInfo.result.Statement;

public class CreateParser
implements SQLParser<CreateStatement, CreateStatementBuilder> {
    private static final String Name = "create";
    private static final Pattern TABLE_PATTERN = Pattern.compile("(?<=create)\\s*?(temporary\\s*?table|table)\\s*([\\S]+)\\s*?(?=(\\(|as|like))", 2);
    private static final Pattern FIELD_PATTERN = Pattern.compile("(?<=\\()[\\s\\S]*(?=\\))", 2);
    private static final Pattern OPTIONS_PATTERN = Pattern.compile("(?<=\\)[^,])[\\s\\S]*?(?=(;))", 2);
    private static final Pattern LIKE_PATTERN = Pattern.compile("(?<=like)[\\s\\S]*(?=(;))", 2);
    private static final Pattern AS_PATTERN = Pattern.compile("as\\s*?(select[\\s\\S]*)", 2);

    public static CreateParser getInstance() {
        CreateParser sqlParserByName = SQLParserManager.getSQLParserByName(Name);
        if (sqlParserByName == null) {
            sqlParserByName = new CreateParser();
            SQLParserManager.register(sqlParserByName);
        }
        return sqlParserByName;
    }

    @Override
    public String getName() {
        return Name;
    }

    @Override
    public CreateStatement parseSql(String sql) {
        return this.parseSqlByWord(CreateStatement.builder(), 0, sql, Name);
    }

    @Override
    public CreateStatement parseSqlByWord(CreateStatementBuilder createStatementBuilder, int startIndex, String sql, String sqlWord) {
        Matcher matcher;
        if (";".equals(sqlWord)) {
            return createStatementBuilder.create();
        }
        int wordNum = Statement.getWordNum(sqlWord.toLowerCase(), 6);
        if (wordNum == CreateStatement.CREATE_WORD) {
            Matcher matcher2 = TABLE_PATTERN.matcher(sql);
            if (matcher2.find(startIndex)) {
                return this.parseSqlByWord(createStatementBuilder.setSQL(sql).setCreateStr(matcher2.group()).setTemporary(!matcher2.group(1).equalsIgnoreCase("table")).setTableName(matcher2.group(2)), matcher2.end(), sql, matcher2.group(3));
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        if (wordNum == CreateStatement.LEFT_BRACKET_WORD) {
            Matcher matcher3 = FIELD_PATTERN.matcher(sql);
            if (matcher3.find(startIndex)) {
                return this.parseSqlByWord(createStatementBuilder.setFieldStr(matcher3.group(0)), matcher3.end(), sql, ")");
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        if (wordNum == CreateStatement.LIKE_WORD) {
            Matcher matcher4 = LIKE_PATTERN.matcher(sql);
            if (matcher4.find(startIndex)) {
                return this.parseSqlByWord(createStatementBuilder.setLikeStr(matcher4.group(0)), matcher4.end(), sql, matcher4.group(1));
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        if (wordNum == CreateStatement.RIGHT_BRACKET_WORD) {
            if (startIndex < sql.length()) {
                if (";".equals(sql.substring(startIndex + 1).trim())) {
                    return this.parseSqlByWord(createStatementBuilder, startIndex, sql, ";");
                }
                Matcher matcher5 = OPTIONS_PATTERN.matcher(sql);
                if (matcher5.find(startIndex)) {
                    return this.parseSqlByWord(createStatementBuilder.setOptionsStr(matcher5.group(0)), matcher5.end(), sql, matcher5.group(1));
                }
                throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
            }
        } else if (wordNum == CreateStatement.AS_WORD && (matcher = AS_PATTERN.matcher(sql)).find(startIndex)) {
            return this.parseSqlByWord(createStatementBuilder.setSelectStatement(SelectParser.getInstance().parseSql(matcher.group(1))), matcher.end(), sql, ";");
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u89e3\u6790\u8bcd\uff1a" + sqlWord);
    }
}

