/*
 * Decompiled with CFR 0.152.
 */
package strInfo.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import strInfo.manager.SQLParserManager;
import strInfo.parser.SQLParser;
import strInfo.result.InsertStatement;
import strInfo.result.InsertStatementBuilder;

public class InsertParser
implements SQLParser<InsertStatement, InsertStatementBuilder> {
    protected static final Pattern INSERT_PATTERN = Pattern.compile("(?<=insert into )(.*?)\\(([\\s\\S]*?)\\)\\s*(value[s]*)\\s*\\(([\\s\\S]*)\\);", 2);
    private static final String Name = "insert";

    public static InsertParser getInstance() {
        InsertParser sqlParserByName = SQLParserManager.getSQLParserByName(Name);
        if (sqlParserByName == null) {
            sqlParserByName = new InsertParser();
            SQLParserManager.register(sqlParserByName);
        }
        return sqlParserByName;
    }

    @Override
    public String getName() {
        return Name;
    }

    @Override
    public InsertStatement parseSql(String sql) {
        return this.parseSqlByWord(InsertStatement.builder(), 0, sql, Name);
    }

    @Override
    public InsertStatement parseSqlByWord(InsertStatementBuilder insertStatementBuilder, int startIndex, String sql, String sqlWord) {
        if (";".equals(sqlWord)) {
            return insertStatementBuilder.create();
        }
        if (Name.equalsIgnoreCase(sqlWord)) {
            Matcher matcher = INSERT_PATTERN.matcher(sql);
            if (matcher.find()) {
                String valueORvalues = matcher.group(3);
                char last = valueORvalues.charAt(valueORvalues.length() - 1);
                return this.parseSqlByWord(insertStatementBuilder.setSQL(matcher.group()).setTableName(matcher.group(1)).setFieldStr(matcher.group(2)).setMultiline(last == 's' || last == 'S').setDataStr(matcher.group(4)), matcher.end(), sql, ";");
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u89e3\u6790\u8bcd\uff1a" + sqlWord);
    }
}

