/*
 * Decompiled with CFR 0.152.
 */
package strInfo.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import strInfo.manager.SQLParserManager;
import strInfo.parser.SQLParser;
import strInfo.result.SelectStatement;
import strInfo.result.SelectStatementBuilder;
import strInfo.result.Statement;

public class SelectParser
implements SQLParser<SelectStatement, SelectStatementBuilder> {
    private static final String Name = "select";
    private static final Pattern FIELD_AND_TABLE_RESOLUTION = Pattern.compile("select\\s*([()a-zA-Z, 0-9+\\-*/%\\r\\n]+?)\\s*?from\\s*?([a-z_A-Z0-9\\s]*?)(?=(\\(|where|group|order|limit|;))", 2);
    private static final Pattern SUB_QUERY_REPLACEMENT_PATTERN = Pattern.compile("\\(select[\\s\\S]*?;\\)", 2);
    private static final Pattern WHERE_CLAUSE_PARSING = Pattern.compile("(?:on|where)\\s*([\\s\\S]+?)\\s*?(?=(group|order|limit|;))", 2);
    private static final Pattern GROUP_CLAUSE_PARSING = Pattern.compile("group *?by\\s*([\\s\\S]+?)\\s*?(?=(order|limit|;))", 2);
    private static final Pattern ORDER_CLAUSE_PARSING = Pattern.compile("order *?by\\s*([\\s\\S]+?)( |asc|desc)\\s*?(?=(limit|;))", 2);
    private static final Pattern LIMIT_CLAUSE_PARSING = Pattern.compile("limit\\s*([\\s\\S]+?)\\s*?(?=(;))", 2);

    protected SelectParser() {
    }

    public static SelectParser getInstance() {
        SelectParser sqlParserByName = SQLParserManager.getSQLParserByName(Name);
        if (sqlParserByName == null) {
            sqlParserByName = new SelectParser();
            SQLParserManager.register(sqlParserByName);
        }
        return sqlParserByName;
    }

    @Override
    public String getName() {
        return Name;
    }

    @Override
    public SelectStatement parseSql(String sql) {
        return this.parseSqlByWord((SelectStatementBuilder)null, 0, sql, Name);
    }

    @Override
    public SelectStatement parseSqlByWord(SelectStatementBuilder selectStatementBuilder, int startIndex, String sql, String sqlWord) {
        if ("SUB_QUERY".equals(sql) || ";".equals(sqlWord)) {
            return selectStatementBuilder.create();
        }
        int wordNum = Statement.getWordNum(sqlWord, 4);
        if (wordNum == SelectStatement.SELECT_WORD) {
            Matcher matcher = FIELD_AND_TABLE_RESOLUTION.matcher(sql);
            if (matcher.find(startIndex)) {
                String fields = matcher.group(1);
                String tableName = matcher.group(2);
                String word = matcher.group(3);
                return this.parseSqlByWord(SelectStatement.builder().setTableName(tableName).setSQL(sql).setSelectStr(fields), matcher.end(), sql, word);
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        if ("(".equals(sqlWord)) {
            Matcher matcher1 = SUB_QUERY_REPLACEMENT_PATTERN.matcher(sql);
            if (matcher1.find(startIndex)) {
                SelectStatement subSelect = this.parseSqlByWord((SelectStatementBuilder)null, 1, matcher1.group(), Name);
                selectStatementBuilder.addSubSelect(subSelect).addTableName(",").addTableName(subSelect.getTableName());
                while (matcher1.find()) {
                    subSelect = this.parseSqlByWord((SelectStatementBuilder)null, 1, matcher1.group(), Name);
                    selectStatementBuilder.addSubSelect(subSelect).addTableName(",").addTableName(subSelect.getTableName());
                }
            } else {
                throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u5b50\u67e5\u8be2sql\u8bed\u53e5\uff1a" + sql);
            }
            return this.parseSqlByWord(selectStatementBuilder, startIndex, matcher1.replaceFirst("SUB_QUERY"), "where");
        }
        if (wordNum == SelectStatement.WHERE_WORD) {
            Matcher matcher = WHERE_CLAUSE_PARSING.matcher(sql);
            if (matcher.find(startIndex)) {
                return this.parseSqlByWord(selectStatementBuilder.setWhereStr(matcher.group(1)), matcher.end(), sql, matcher.group(2));
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        if (wordNum == SelectStatement.GROUP_WORD) {
            Matcher matcher = GROUP_CLAUSE_PARSING.matcher(sql);
            if (matcher.find(startIndex)) {
                return this.parseSqlByWord(selectStatementBuilder.setGroupStr(matcher.group(1)), matcher.end(), sql, matcher.group(2));
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        if (wordNum == SelectStatement.ORDER_WORD) {
            Matcher matcher = ORDER_CLAUSE_PARSING.matcher(sql);
            if (matcher.find(startIndex)) {
                String orderMode = matcher.group(2);
                return this.parseSqlByWord(selectStatementBuilder.setOrderStr(matcher.group(1)).setAsc(" ".equals(orderMode) || "asc".equalsIgnoreCase(orderMode)), matcher.end(), sql, matcher.group(3));
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        if (wordNum == SelectStatement.LIMIT_WORD) {
            Matcher matcher = LIMIT_CLAUSE_PARSING.matcher(sql);
            if (matcher.find(startIndex)) {
                return this.parseSqlByWord(selectStatementBuilder.setLimitStr(matcher.group(1)), matcher.end(), sql, matcher.group(2));
            }
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790sql\u8bed\u53e5\uff1a" + sql);
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u89e3\u6790\u8bcd\uff1a" + sqlWord);
    }
}

