/*
 * Decompiled with CFR 0.152.
 */
package strInfo.result;

import strInfo.result.AlterStatementBuilder;
import strInfo.result.Statement;

public class AlterStatement
extends Statement {
    public static final short hashNum = 8;
    public static final int ALTER_WORD = AlterStatement.getWordNum("alter", 8);
    public static final int ALTER_MOD_WORD = AlterStatement.getWordNum("mod", 8);
    public static final int ADD_INFO_WORD = AlterStatement.getWordNum("addINFO", 8);
    public static final int TABLE_WORD = AlterStatement.getWordNum("table", 8);
    public static final int ADD_WORD = AlterStatement.getWordNum("add", 8);
    public static final int DROP_WORD = AlterStatement.getWordNum("drop", 8);
    public static final int RENAME_WORD = AlterStatement.getWordNum("rename", 8);
    public static final int CHANGE_WORD = AlterStatement.getWordNum("change", 8);
    public static final int INDEX_WORD = AlterStatement.getWordNum("index", 8);
    public static final int PRIMARY_WORD = AlterStatement.getWordNum("primary", 8);
    public static final int UNIQUE_WORD = AlterStatement.getWordNum("unique", 8);
    public static final int FIELD_WORD = AlterStatement.getWordNum("field", 8);
    private final String alterStr;
    private final String addStr;
    private final String dropStr;
    private final String renameStr;
    private final String changeStr;
    private final String mod;
    private final String addINFO;
    private final String indexName;
    private final String sql;
    private final String fieldStr;

    public AlterStatement(String tableName, String fieldStr, String mod, String alterStr, String addStr, String indexName, String addINFO, String dropStr, String renameStr, String changeStr, String sql) {
        super(tableName, fieldStr == null ? new String[]{} : COMMA_PATTERN.split(fieldStr));
        this.alterStr = alterStr;
        int wordNum = AlterStatement.getWordNum(mod, 8);
        if (wordNum == ADD_WORD) {
            this.addStr = addStr;
            this.dropStr = "null";
            this.renameStr = "null";
            this.changeStr = "null";
            int wordNum1 = AlterStatement.getWordNum(addINFO, 8);
            this.indexName = wordNum1 == INDEX_WORD ? indexName : "null";
            this.addINFO = addINFO;
        } else if (wordNum == DROP_WORD) {
            this.dropStr = dropStr;
            this.addStr = "null";
            this.renameStr = "null";
            this.changeStr = "null";
            this.indexName = "null";
            this.addINFO = "null";
        } else if (wordNum == RENAME_WORD) {
            this.renameStr = renameStr;
            this.dropStr = "null";
            this.addStr = "null";
            this.changeStr = "null";
            this.indexName = "null";
            this.addINFO = "null";
        } else if (wordNum == CHANGE_WORD) {
            this.changeStr = changeStr;
            this.dropStr = "null";
            this.renameStr = "null";
            this.addStr = "null";
            this.indexName = "null";
            this.addINFO = "null";
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790alter\u8bed\u53e5\uff0c\u8bed\u53e5\u4e2d\u89e3\u6790\u8bcd\u5bf9\u5e94\u7684\u53e5\u5b50\u683c\u5f0f\u9519\u8bef\u3002\nThe alter statement cannot be parsed. The format of the sentence corresponding to the parsed word in the statement is incorrect.\nERROR => " + mod);
        }
        this.fieldStr = fieldStr;
        this.mod = mod;
        this.sql = sql;
    }

    public static AlterStatementBuilder builder() {
        return new AlterStatementBuilder();
    }

    @Override
    protected int getWordNum(String sqlWord) {
        return AlterStatement.getWordNum(sqlWord, 8);
    }

    @Override
    public String getSqlStr() {
        return this.sql;
    }

    @Override
    public String getStatementStrByWord(String sqlWord) {
        int wordNum = AlterStatement.getWordNum(sqlWord, 8);
        if (wordNum == ALTER_WORD) {
            return this.alterStr;
        }
        if (wordNum == TABLE_WORD) {
            return this.tableName;
        }
        if (wordNum == ADD_WORD) {
            return this.addStr;
        }
        if (wordNum == DROP_WORD) {
            return this.dropStr;
        }
        if (wordNum == RENAME_WORD) {
            return this.renameStr;
        }
        if (wordNum == CHANGE_WORD) {
            return this.changeStr;
        }
        if (wordNum == INDEX_WORD) {
            return this.indexName;
        }
        if (wordNum == FIELD_WORD) {
            return this.fieldStr;
        }
        if (wordNum == ALTER_MOD_WORD) {
            return this.mod;
        }
        if (wordNum == ADD_INFO_WORD) {
            return this.addINFO;
        }
        throw new IllegalStateException("Unexpected value: " + wordNum);
    }

    @Override
    public String[] getStatementArrayByWord(String sqlWord) {
        int wordNum = AlterStatement.getWordNum(sqlWord, 8);
        if (wordNum == ALTER_WORD) {
            return new String[]{this.alterStr};
        }
        if (wordNum == TABLE_WORD) {
            return new String[]{this.tableName};
        }
        if (wordNum == ADD_WORD) {
            return new String[]{this.addStr};
        }
        if (wordNum == DROP_WORD) {
            return new String[]{this.dropStr};
        }
        if (wordNum == RENAME_WORD) {
            return new String[]{this.renameStr};
        }
        if (wordNum == CHANGE_WORD) {
            return new String[]{this.changeStr};
        }
        if (wordNum == INDEX_WORD) {
            return new String[]{this.indexName};
        }
        if (wordNum == FIELD_WORD) {
            return this.fieldNames;
        }
        if (wordNum == ALTER_MOD_WORD) {
            return new String[]{this.mod};
        }
        if (wordNum == ADD_INFO_WORD) {
            return new String[]{this.addINFO};
        }
        throw new IllegalStateException("Unexpected value: " + wordNum);
    }
}

