/*
 * Decompiled with CFR 0.152.
 */
package strInfo.result;

import strInfo.result.CreateStatementBuilder;
import strInfo.result.SelectStatement;
import strInfo.result.Statement;

public class CreateStatement
extends Statement {
    public static final short hashNum = 6;
    public static final int CREATE_WORD = CreateStatement.getWordNum("create", 6);
    public static final int TABLE_WORD = CreateStatement.getWordNum("table", 6);
    public static final int FIELD_WORD = CreateStatement.getWordNum("field", 6);
    public static final int OPTION_WORD = CreateStatement.getWordNum("option", 6);
    public static final int LEFT_BRACKET_WORD = CreateStatement.getWordNum("(", 6);
    public static final int RIGHT_BRACKET_WORD = CreateStatement.getWordNum(")", 6);
    public static final int LIKE_WORD = CreateStatement.getWordNum("like", 6);
    public static final int AS_WORD = CreateStatement.getWordNum("as", 6);
    private final String SQL;
    private final String createStr;
    private final String fieldStr;
    private final String optionsStr;
    private final boolean temporary;
    private final String likeStr;
    private final SelectStatement selectStatement;

    protected CreateStatement(String tableName, String sql, String createStr, String fieldStr, String optionsStr, boolean temporary, String likeStr, SelectStatement selectStatement) {
        super(tableName, fieldStr != null ? COMMA_PATTERN.split(fieldStr.trim()) : new String[]{});
        this.SQL = sql;
        this.createStr = createStr;
        this.fieldStr = fieldStr;
        this.optionsStr = optionsStr;
        this.temporary = temporary;
        this.likeStr = likeStr;
        this.selectStatement = selectStatement;
    }

    protected CreateStatement(String tableName, String createStr, String fieldStr, String optionsStr, boolean temporary, String likeStr, SelectStatement selectStatement) {
        super(tableName, fieldStr == null ? new String[]{} : COMMA_PATTERN.split(fieldStr.trim()));
        this.createStr = createStr;
        this.fieldStr = fieldStr;
        this.optionsStr = optionsStr;
        this.temporary = temporary;
        this.likeStr = likeStr;
        this.selectStatement = selectStatement;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("create ").append(createStr);
        if (fieldStr != null) {
            stringBuilder.append(" (").append(fieldStr).append(") ");
        } else if (likeStr != null) {
            stringBuilder.append(" like ").append(likeStr);
        }
        if (optionsStr != null) {
            stringBuilder.append(optionsStr);
        }
        this.SQL = stringBuilder + ";";
    }

    public static CreateStatementBuilder builder() {
        return new CreateStatementBuilder();
    }

    @Override
    protected int getWordNum(String sqlWord) {
        return CreateStatement.getWordNum(sqlWord, 6);
    }

    @Override
    public String getSqlStr() {
        return this.SQL;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public String getStatementStrByWord(String sqlWord) {
        int wordNum = CreateStatement.getWordNum(sqlWord, 6);
        if (wordNum == CREATE_WORD) {
            return this.createStr;
        }
        if (wordNum == TABLE_WORD) {
            return this.tableName;
        }
        if (wordNum == FIELD_WORD) {
            return this.fieldStr;
        }
        if (wordNum == OPTION_WORD) {
            return this.optionsStr;
        }
        if (wordNum == LIKE_WORD) {
            return this.likeStr;
        }
        if (wordNum == AS_WORD) {
            return this.selectStatement.getSqlStr();
        }
        throw new IllegalStateException("Unexpected value: " + wordNum);
    }

    @Override
    public String[] getStatementArrayByWord(String sqlWord) {
        int wordNum = CreateStatement.getWordNum(sqlWord, 6);
        if (wordNum == CREATE_WORD) {
            return this.createStr == null ? new String[]{} : SPACE_PATTERN.split(this.createStr);
        }
        if (wordNum == TABLE_WORD) {
            return new String[]{this.tableName};
        }
        if (wordNum == FIELD_WORD) {
            return this.fieldStr == null ? new String[]{} : COMMA_PATTERN.split(this.fieldStr);
        }
        if (wordNum == OPTION_WORD) {
            return this.optionsStr == null ? new String[]{} : SPACE_PATTERN.split(this.optionsStr);
        }
        if (wordNum == LIKE_WORD) {
            return new String[]{this.likeStr};
        }
        if (wordNum == AS_WORD) {
            return this.selectStatement == null ? new String[]{} : SPACE_PATTERN.split(this.selectStatement.getSqlStr());
        }
        throw new IllegalStateException("Unexpected value: " + wordNum);
    }

    public SelectStatement getSelectStatement() {
        return this.selectStatement;
    }

    public CreateStatement merge(CreateStatement createStatement) {
        if (createStatement == null) {
            return this;
        }
        String createStr = null;
        String fieldStr = null;
        String optionStr = null;
        String likeStr = null;
        if (this.createStr == null && createStatement.createStr != null) {
            createStr = createStatement.createStr;
        }
        if (this.fieldStr == null && createStatement.fieldStr != null) {
            fieldStr = createStatement.fieldStr;
        }
        if (this.optionsStr == null && createStatement.optionsStr != null) {
            optionStr = createStatement.optionsStr;
        }
        if (this.likeStr == null && createStatement.likeStr != null) {
            likeStr = createStatement.likeStr;
        }
        return new CreateStatement(this.tableName, createStr, fieldStr == null ? "----" : fieldStr, optionStr, this.temporary == createStatement.temporary && this.temporary, likeStr, this.selectStatement != null ? this.selectStatement.merge(createStatement.selectStatement) : createStatement.selectStatement);
    }

    public String toString() {
        return this.getSqlStr();
    }
}

