/*
 * Decompiled with CFR 0.152.
 */
package strInfo.result;

import java.util.regex.Pattern;
import strInfo.result.InsertStatementBuilder;
import strInfo.result.Statement;

public class InsertStatement
extends Statement {
    public static final short hashNum = 4;
    public static final int INSERT_WORD = InsertStatement.getWordNum("insert", 4);
    public static final int TABLE_WORD = InsertStatement.getWordNum("table", 4);
    public static final int VALUE_WORD = InsertStatement.getWordNum("value", 4);
    public static final int VALUES_WORD = InsertStatement.getWordNum("values", 4);
    protected static final Pattern VALUE_SPLIT_PATTERN = Pattern.compile("\\)\\s*?,\\s*?\\(", 2);
    private final boolean Multiline;
    private final String SQL;
    private final String fieldStr;
    private final String dataStr;

    protected InsertStatement(String tableName, boolean multiline, String sql, String fieldStr, String dataStr) {
        String[] stringArray;
        if (fieldStr == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "null";
        } else {
            stringArray = COMMA_PATTERN.split(fieldStr);
        }
        super(tableName, stringArray);
        this.Multiline = multiline;
        this.SQL = sql;
        this.fieldStr = fieldStr;
        this.dataStr = dataStr;
    }

    protected InsertStatement(String tableName, boolean multiline, String fieldStr, String dataStr) {
        String[] stringArray;
        if (fieldStr == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "null";
        } else {
            stringArray = COMMA_PATTERN.split(fieldStr);
        }
        super(tableName, stringArray);
        this.Multiline = multiline;
        this.fieldStr = fieldStr;
        this.dataStr = dataStr;
        this.SQL = "insert into " + tableName + '(' + fieldStr + ')' + (multiline ? " values " : " value ") + dataStr + ';';
    }

    public static InsertStatementBuilder builder() {
        return new InsertStatementBuilder();
    }

    @Override
    protected int getWordNum(String sqlWord) {
        return InsertStatement.getWordNum(sqlWord, 4);
    }

    @Override
    public String getSqlStr() {
        return this.SQL;
    }

    @Override
    public String getStatementStrByWord(String sqlWord) {
        int wordNum = InsertStatement.getWordNum(sqlWord, 4);
        if (wordNum == INSERT_WORD) {
            return this.fieldStr;
        }
        if (wordNum == TABLE_WORD) {
            return this.tableName;
        }
        if (wordNum == VALUE_WORD || wordNum == VALUES_WORD) {
            return '(' + this.dataStr + ')';
        }
        throw new IllegalStateException("Unexpected value: " + wordNum);
    }

    public InsertStatement merge(InsertStatement insertStatement) {
        if (insertStatement == null) {
            return this;
        }
        String dataStr = null;
        String fieldStr = null;
        if (this.dataStr == null && insertStatement.dataStr != null) {
            dataStr = insertStatement.dataStr;
        }
        if (this.fieldStr == null && insertStatement.fieldStr != null) {
            fieldStr = insertStatement.fieldStr;
        }
        return new InsertStatement(this.tableName, this.Multiline == insertStatement.Multiline && this.Multiline, fieldStr, dataStr);
    }

    @Override
    public String[] getStatementArrayByWord(String sqlWord) {
        int wordNum = InsertStatement.getWordNum(sqlWord, 4);
        if (wordNum == INSERT_WORD) {
            return this.fieldNames;
        }
        if (wordNum == TABLE_WORD) {
            return new String[]{this.tableName};
        }
        if (wordNum == VALUE_WORD || wordNum == VALUES_WORD) {
            return this.dataStr != null ? VALUE_SPLIT_PATTERN.split(this.dataStr) : new String[]{};
        }
        throw new IllegalStateException("Unexpected value: " + wordNum);
    }
}

