/*
 * Decompiled with CFR 0.152.
 */
package strInfo.result;

import java.util.ArrayList;
import strInfo.result.SelectStatementBuilder;
import strInfo.result.Statement;

public class SelectStatement
extends Statement {
    public static final short hashNum = 4;
    public static final int SELECT_WORD = SelectStatement.getWordNum("select", 4);
    public static final int FROM_WORD = SelectStatement.getWordNum("from", 4);
    public static final int WHERE_WORD = SelectStatement.getWordNum("where", 4);
    public static final int GROUP_WORD = SelectStatement.getWordNum("group", 4);
    public static final int ORDER_WORD = SelectStatement.getWordNum("order", 4);
    public static final int LIMIT_WORD = SelectStatement.getWordNum("limit", 4);
    private final ArrayList<SelectStatement> SubQueryList;
    private final String SQL;
    private final String selectStr;
    private final String whereStr;
    private final String groupStr;
    private final boolean asc;
    private final String orderStr;
    private final String limitStr;

    protected SelectStatement(String tableName, String sql, String selectStr, String whereStr, String groupStr, String orderStr, boolean asc, String limitStr, ArrayList<SelectStatement> SubQueryList) {
        super(tableName, COMMA_PATTERN.split(selectStr));
        this.SQL = sql;
        this.selectStr = selectStr;
        this.whereStr = whereStr;
        this.groupStr = groupStr;
        this.asc = asc;
        this.orderStr = orderStr;
        this.limitStr = limitStr;
        this.SubQueryList = SubQueryList;
    }

    protected SelectStatement(String tableName, String selectStr, String whereStr, String groupStr, String orderStr, boolean asc, String limitStr, ArrayList<SelectStatement> SubQueryList) {
        super(tableName, COMMA_PATTERN.split(selectStr));
        this.selectStr = selectStr;
        this.whereStr = whereStr;
        this.groupStr = groupStr;
        this.orderStr = orderStr;
        this.asc = asc;
        this.limitStr = limitStr;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("select ").append(selectStr).append(" from ").append(tableName);
        if (whereStr != null) {
            stringBuilder.append(" where ").append(whereStr);
        }
        if (groupStr != null) {
            stringBuilder.append(" group  by ").append(groupStr);
        }
        if (orderStr != null) {
            stringBuilder.append(" order by ").append(orderStr);
        }
        if (limitStr != null) {
            stringBuilder.append(" limit ").append(limitStr);
        }
        this.SQL = stringBuilder + ";";
        this.SubQueryList = SubQueryList;
    }

    public static SelectStatementBuilder builder() {
        return new SelectStatementBuilder();
    }

    public String[] getTables() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String tableName = this.tableName;
        StringBuilder backStr = new StringBuilder();
        int length = tableName.length();
        for (int i = 0; i < length; ++i) {
            char c = tableName.charAt(i);
            if (c != ' ' && c != ',') {
                backStr.append(c);
                continue;
            }
            int length1 = backStr.length();
            if (length1 == 5) {
                String s1 = backStr.toString();
                if (s1.equalsIgnoreCase("right") || s1.equalsIgnoreCase("inner") || s1.equalsIgnoreCase("cross")) {
                    backStr.delete(0, 5);
                    continue;
                }
                arrayList.add(s1);
                continue;
            }
            if (length1 == 4) {
                String s1 = backStr.toString();
                if ("join".equalsIgnoreCase(s1) || "left".equalsIgnoreCase(s1) || "full".equalsIgnoreCase(s1)) {
                    backStr.delete(0, 4);
                    continue;
                }
                arrayList.add(s1);
                continue;
            }
            int length2 = backStr.length();
            if (length2 == 0) continue;
            arrayList.add(backStr.toString());
            backStr.delete(0, length2);
        }
        if (backStr.length() != 0) {
            arrayList.add(backStr.toString());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    protected int getWordNum(String sqlWord) {
        return SelectStatement.getWordNum(sqlWord, 4);
    }

    @Override
    public String getSqlStr() {
        return this.SQL;
    }

    public int isAsc() {
        return this.orderStr == null ? 0 : (this.asc ? 1 : -1);
    }

    @Override
    public String getStatementStrByWord(String sqlWord) {
        int wordNum = SelectStatement.getWordNum(sqlWord, 4);
        if (wordNum == SELECT_WORD) {
            return this.selectStr;
        }
        if (wordNum == FROM_WORD) {
            return this.tableName;
        }
        if (wordNum == WHERE_WORD) {
            return this.whereStr;
        }
        if (wordNum == GROUP_WORD) {
            return this.groupStr;
        }
        if (wordNum == ORDER_WORD) {
            return this.orderStr;
        }
        if (wordNum == LIMIT_WORD) {
            return this.limitStr;
        }
        throw new IllegalStateException("Unexpected value: " + wordNum);
    }

    @Override
    public String[] getStatementArrayByWord(String sqlWord) {
        int wordNum = SelectStatement.getWordNum(sqlWord, 4);
        if (wordNum == SELECT_WORD) {
            return this.fieldNames;
        }
        if (wordNum == FROM_WORD) {
            return this.tableName == null ? new String[]{} : this.getTables();
        }
        if (wordNum == WHERE_WORD) {
            return this.whereStr == null ? new String[]{} : this.getWhereArray();
        }
        if (wordNum == GROUP_WORD) {
            return this.groupStr == null ? new String[]{} : COMMA_PATTERN.split(this.groupStr);
        }
        if (wordNum == ORDER_WORD) {
            return this.orderStr == null ? new String[]{} : COMMA_PATTERN.split(this.orderStr);
        }
        if (wordNum == LIMIT_WORD) {
            return this.limitStr == null ? new String[]{} : COMMA_PATTERN.split(this.limitStr);
        }
        throw new IllegalStateException("Unexpected value: " + wordNum);
    }

    public String[] getWhereArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder backStr = new StringBuilder();
        int length = this.whereStr.length();
        for (int i = 0; i < length; ++i) {
            char c = this.whereStr.charAt(i);
            if (c != ' ') {
                stringBuilder.append(c);
                continue;
            }
            String s = stringBuilder.toString();
            int length1 = s.length();
            if ("or".equalsIgnoreCase(s) || "and".equalsIgnoreCase(s)) {
                arrayList.add(backStr.toString());
                arrayList.add(s);
            } else {
                backStr.append(c).append((CharSequence)stringBuilder);
            }
            stringBuilder.delete(0, length1);
        }
        if (backStr.length() != 0) {
            arrayList.add(backStr.toString());
        }
        return arrayList.toArray(new String[0]);
    }

    public ArrayList<SelectStatement> getSubQueryList() {
        return this.SubQueryList;
    }

    public SelectStatement merge(SelectStatement selectStatement) {
        if (selectStatement == null) {
            return this;
        }
        String selectStr = null;
        String whereStr = null;
        String groupStr = null;
        String orderStr = null;
        boolean asc = this.asc;
        String limitStr = null;
        if (this.selectStr == null && selectStatement.selectStr != null) {
            selectStr = selectStatement.selectStr;
        }
        if (this.whereStr == null && selectStatement.whereStr != null) {
            whereStr = selectStatement.whereStr;
        }
        if (this.groupStr == null && selectStatement.groupStr != null) {
            groupStr = selectStatement.groupStr;
        }
        if (this.orderStr == null && selectStatement.orderStr != null) {
            orderStr = selectStatement.orderStr;
            asc = selectStatement.asc;
        }
        if (this.limitStr == null && selectStatement.limitStr != null) {
            limitStr = selectStatement.limitStr;
        }
        ArrayList<SelectStatement> arrayList = new ArrayList<SelectStatement>(this.SubQueryList.size() + selectStatement.SubQueryList.size() + 16);
        arrayList.addAll(this.SubQueryList);
        arrayList.addAll(selectStatement.SubQueryList);
        return new SelectStatement(this.tableName, selectStr, whereStr, groupStr, orderStr, this.asc == selectStatement.asc && asc, limitStr, arrayList);
    }

    public String toString() {
        return this.getSqlStr();
    }
}

