/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.MySpringTool.PartUtils;
import io.github.kloping.MySpringTool.Starter;
import io.github.kloping.MySpringTool.annotations.http.CookieFrom;
import io.github.kloping.MySpringTool.annotations.http.GetPath;
import io.github.kloping.MySpringTool.annotations.http.HttpClient;
import io.github.kloping.MySpringTool.annotations.http.ParamBody;
import io.github.kloping.MySpringTool.annotations.http.ParamName;
import io.github.kloping.MySpringTool.annotations.http.PostPath;
import io.github.kloping.MySpringTool.annotations.http.RequestBody;
import io.github.kloping.MySpringTool.entity.Params;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

final class HttpClientStarter {
    private static Map<Method, M1> methodInks = new ConcurrentHashMap<Method, M1>();
    public static String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36 Edg/95.0.1020.53";
    public static Map<String, CookieStore> histCookie = new ConcurrentHashMap<String, CookieStore>();
    public static Map<String, URI> histURI = new ConcurrentHashMap<String, URI>();

    HttpClientStarter() {
    }

    static <T> void initHttpClientInterface(Class<T> cla) {
        Method[] methods;
        Starter.appendToObjMap(UUID.randomUUID().toString(), Proxy.newProxyInstance(cla.getClassLoader(), new Class[]{cla}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (methodInks.containsKey(method)) {
                    return ((M1)methodInks.get(method)).run(args);
                }
                return null;
            }
        }), cla);
        String host = cla.getAnnotation(HttpClient.class).value();
        for (Method method : methods = cla.getDeclaredMethods()) {
            String path;
            if (method.isAnnotationPresent(GetPath.class)) {
                path = method.getAnnotation(GetPath.class).value();
                path = HttpClientStarter.ali(host, path);
                HttpClientStarter.initMethod(method, path, Connection.Method.GET);
                continue;
            }
            if (!method.isAnnotationPresent(PostPath.class)) continue;
            path = method.getAnnotation(PostPath.class).value();
            path = HttpClientStarter.ali(host, path);
            HttpClientStarter.initMethod(method, path, Connection.Method.POST);
        }
    }

    private static String ali(String host, String path) {
        if (!host.endsWith("/")) {
            host = host + "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return host + path;
    }

    private static void initMethod(final Method method, final String url, Connection.Method type2) {
        methodInks.put(method, new M1(url){

            Object run(Object ... objects) {
                try {
                    String trueUrl = HttpClientStarter.getGetUrl(url, method, objects);
                    Connection connection = HttpClientStarter.getConnection(trueUrl);
                    HttpClientStarter.initCookie(connection, method, trueUrl);
                    Class<?> cls = method.getReturnType();
                    if (cls == String.class) {
                        return connection.get().toString();
                    }
                    if (cls == Document.class) {
                        return connection.get();
                    }
                    if (cls == byte[].class) {
                        return connection.method(Connection.Method.GET).execute().bodyAsBytes();
                    }
                    return HttpClientStarter.Type(cls, connection.get().body().text());
                }
                catch (Exception e) {
                    Starter.Log(PartUtils.getExceptionLine(e), -1);
                    return null;
                }
            }
        });
    }

    private static void initCookie(Connection connection, Method method, String trueUrl) throws Exception {
        if (method.isAnnotationPresent(CookieFrom.class)) {
            CookieFrom cf = method.getAnnotation(CookieFrom.class);
            connection.cookieStore(HttpClientStarter.getCookieStore(cf.value(), Connection.Method.valueOf((String)cf.method()), trueUrl));
        }
    }

    private static Connection getConnection(String trueUrl) throws Exception {
        return Jsoup.connect((String)trueUrl).ignoreContentType(true).userAgent(userAgent);
    }

    private static String getPostBody(Method method, Object[] objects) throws Exception {
        Parameter[] parameters = method.getParameters();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(RequestBody.class)) continue;
            RequestBody rb = parameters[i].getAnnotation(RequestBody.class);
            switch (rb.type()) {
                case toString: {
                    sb.append(objects[i]);
                    continue block4;
                }
                case json: {
                    sb.append(JSON.toJSONString((Object)objects[i]));
                }
            }
        }
        if (sb.toString().endsWith("?")) {
            sb.delete(sb.length() - 1, sb.length());
        }
        if (sb.toString().endsWith("&")) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    private static <T> T Type(Class<T> cls, String text) {
        if (cls == byte[].class) {
            return (T)text.getBytes();
        }
        return (T)JSON.parseObject((String)text).toJavaObject(cls);
    }

    static CookieStore getCookieStore(String[] urls, Connection.Method method, String url) throws IOException, URISyntaxException {
        CookieStore store = null;
        for (String u1 : urls) {
            try {
                Connection connection = null;
                CookieStore sc1 = null;
                Document document = null;
                URI uri = null;
                if (u1.trim().toLowerCase().equals("this")) {
                    u1 = url.trim();
                }
                if (histCookie.containsKey(u1)) {
                    sc1 = histCookie.get(u1);
                    uri = histURI.get(u1);
                } else {
                    connection = HttpClientStarter.getConnection(u1);
                    if (method == Connection.Method.GET) {
                        document = connection.get();
                    } else if (method == Connection.Method.POST) {
                        document = connection.post();
                    }
                    sc1 = connection.cookieStore();
                    uri = new URI(document.baseUri());
                    histCookie.put(u1, sc1);
                    histURI.put(u1, uri);
                }
                if (store == null) {
                    store = sc1;
                    continue;
                }
                for (HttpCookie httpCookie : sc1.getCookies()) {
                    store.add(uri, httpCookie);
                }
            }
            catch (Exception e) {
                Starter.Log("get Cookie Failed From: " + u1, 2);
            }
        }
        return store;
    }

    private static String getGetUrl(String url, Method method, Object ... objects) {
        Parameter[] parameters = method.getParameters();
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        sb.append("?");
        for (int i = 0; i < parameters.length; ++i) {
            Annotation pn;
            if (objects[i] instanceof Params) {
                Params params = (Params)objects[i];
                params.getParams().forEach((k, v) -> sb.append((String)k).append("=").append((String)v).append("&"));
                continue;
            }
            if (parameters[i].isAnnotationPresent(ParamName.class)) {
                pn = parameters[i].getAnnotation(ParamName.class);
                String k2 = pn.value();
                sb.append(k2).append("=").append(objects[i].toString()).append("&");
                continue;
            }
            if (!parameters[i].isAnnotationPresent(ParamBody.class)) continue;
            pn = parameters[i].getAnnotation(ParamBody.class);
            JSONObject jo = JSON.parseObject((String)JSON.toJSONString((Object)objects[i]));
            jo.forEach((k, v) -> sb.append((String)k).append("=").append(v).append("&"));
        }
        if (sb.toString().endsWith("?")) {
            sb.delete(sb.length() - 1, sb.length());
        }
        if (sb.toString().endsWith("&")) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    private static abstract class M1<T> {
        private String path;

        private M1(String path) {
            this.path = path;
        }

        abstract T run(Object ... var1);
    }
}

