/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool;

import io.github.kloping.MySpringTool.PartUtils;
import io.github.kloping.MySpringTool.Setting;
import io.github.kloping.MySpringTool.annotations.CommentScan;
import io.github.kloping.MySpringTool.entity.interfaces.Runner;
import io.github.kloping.MySpringTool.exceptions.NoRunException;
import io.github.kloping.MySpringTool.h1.impl.ExtensionImpl0;
import io.github.kloping.MySpringTool.h1.impl.LoggerImpl;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.common.Public;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;

public final class StarterObjectApplication {
    public Logger logger = new LoggerImpl();
    public Setting INSTANCE = null;
    private final ClassLoader SCAN_LOADER;
    private int poolSize = 20;
    private long waitTime = 12000L;
    private String scanPath;
    private boolean inited = false;
    private Class<?> mainKey = Long.class;
    public final List<Runnable> STARTED_RUNNABLE = new LinkedList<Runnable>();
    public final List<Runnable> PRE_SCAN_RUNNABLE = new LinkedList<Runnable>();
    public final List<Runnable> POST_SCAN_RUNNABLE = new LinkedList<Runnable>();
    private Set<String> fileSet = new CopyOnWriteArraySet<String>();

    public StarterObjectApplication(ClassLoader SCAN_LOADER) {
        this.SCAN_LOADER = SCAN_LOADER;
    }

    public StarterObjectApplication(Class cla) {
        this(cla.getClassLoader());
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public StarterObjectApplication run0(Class<?> cla) {
        if (!cla.isAnnotationPresent(CommentScan.class)) {
            try {
                throw new NoRunException("this class must must has @CommentScan");
            }
            catch (Throwable throwable) {
                System.exit(0);
                throw throwable;
            }
        }
        CommentScan scan = cla.getAnnotation(CommentScan.class);
        this.scanPath = PartUtils.filter(scan.path(), cla);
        PartUtils.check(this.scanPath);
        this.loadConf();
        this.work(cla);
        this.workAfter();
        this.startAfter();
        return this;
    }

    public static StarterObjectApplication run(Class<?> cla) {
        return new StarterObjectApplication(cla.getClassLoader()).run0(cla);
    }

    private void startAfter() {
        for (Runnable runnable : this.STARTED_RUNNABLE) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setMainKey(Class<?> cla) {
        this.mainKey = cla;
    }

    public void setAccessTypes(Class<?> ... classes) {
        this.getInstance().argsManager.setArgsType(classes);
    }

    public synchronized int executeMethod(Object ... objects) {
        return this.getInstance().queueExecutor.queueExecute(objects[0], objects);
    }

    public void setAllAfter(Runner runner) {
        this.getInstance().queueExecutor.setAfter(runner);
    }

    public void setAllBefore(Runner runner) {
        this.getInstance().queueExecutor.setBefore(runner);
    }

    private void workAfter() {
        String format;
        Integer l = this.getInstance().contextManager.getContextEntity(Integer.class, "log.level");
        if (l != null) {
            this.logger.setLogLevel(l);
        }
        if ((format = this.getInstance().contextManager.getContextEntity(String.class, "out.format")) != null) {
            this.logger.setFormat(new SimpleDateFormat(format));
        }
        this.INSTANCE.getContextManager().append(this.logger);
    }

    private void loadConf() {
        for (String path : this.fileSet) {
            this.getInstance().configFileManager.load(path);
        }
    }

    private void reloadConf() {
        for (String path : this.fileSet) {
            this.getInstance().configFileManager.load(path);
        }
    }

    public Set<String> addConfFile(File file) {
        this.fileSet.add(file.getAbsolutePath());
        return this.fileSet;
    }

    public Set<String> addConfFile(String file) {
        this.fileSet.add(file);
        return this.fileSet;
    }

    private void work(Class<?> main) {
        try {
            Object startClass = this.getInstance().getInstanceCrater().create(main, this.getInstance().contextManager);
            this.getInstance().getContextManager().append(startClass);
            this.getInstance().getClassManager().add(main);
            this.preScan();
            for (Class<?> aClass : this.getInstance().getPackageScanner().scan(main, this.SCAN_LOADER, this.scanPath)) {
                this.getInstance().getClassManager().add(aClass);
            }
            this.postScan();
            this.logger.info("version 0.6.2-R3 sptool start success");
        }
        catch (Throwable e) {
            this.logger.error("There is an exception=>" + e + " at " + PartUtils.getExceptionLine(e));
            e.printStackTrace();
        }
    }

    private void postScan() {
        final CountDownLatch cdl = new CountDownLatch(this.POST_SCAN_RUNNABLE.size());
        for (final Runnable runnable : this.POST_SCAN_RUNNABLE) {
            Public.EXECUTOR_SERVICE.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    cdl.countDown();
                }
            });
        }
        try {
            cdl.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void preScan() {
        ExtensionImpl0.INSTANCE = new ExtensionImpl0(this.getInstance());
        for (Runnable runnable : this.PRE_SCAN_RUNNABLE) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.logger.error("There is an exception=>" + e + " at " + PartUtils.getExceptionLine(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Setting getInstance() {
        StarterObjectApplication starterObjectApplication = this;
        synchronized (starterObjectApplication) {
            if (!this.inited) {
                this.INSTANCE = new Setting(){

                    @Override
                    public List<Runnable> getSTARTED_RUNNABLE() {
                        return StarterObjectApplication.this.STARTED_RUNNABLE;
                    }

                    @Override
                    public List<Runnable> getPRE_SCAN_RUNNABLE() {
                        return StarterObjectApplication.this.PRE_SCAN_RUNNABLE;
                    }

                    @Override
                    public List<Runnable> getPOST_SCAN_RUNNABLE() {
                        return StarterObjectApplication.this.POST_SCAN_RUNNABLE;
                    }
                };
                this.INSTANCE.defaultInit(this.mainKey, this.poolSize, this.waitTime);
                this.inited = true;
            }
        }
        return this.INSTANCE;
    }

    public boolean isInited() {
        return this.inited;
    }

    public void setInited(boolean inited) {
        this.inited = inited;
    }
}

