/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool.h1.impl.component;

import io.github.kloping.MySpringTool.annotations.CommentScan;
import io.github.kloping.MySpringTool.annotations.Controller;
import io.github.kloping.MySpringTool.annotations.Entity;
import io.github.kloping.MySpringTool.interfaces.AutomaticWiringParams;
import io.github.kloping.MySpringTool.interfaces.component.ActionManager;
import io.github.kloping.MySpringTool.interfaces.component.ClassManager;
import io.github.kloping.MySpringTool.interfaces.component.ContextManager;
import io.github.kloping.MySpringTool.interfaces.component.InstanceCrater;
import io.github.kloping.MySpringTool.interfaces.component.up0.ClassAttributeManager;
import io.github.kloping.map.MapUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class ClassManagerImpl
implements ClassManager {
    private InstanceCrater instanceCrater;
    private ContextManager contextManager;
    private AutomaticWiringParams automaticWiringParams;
    private ActionManager actionManager;
    private Map<Class<? extends Annotation>, List<ClassAttributeManager>> registeredAnnotations = new ConcurrentHashMap<Class<? extends Annotation>, List<ClassAttributeManager>>();
    private Set<Class<?>> set = new CopyOnWriteArraySet();

    public ClassManagerImpl(InstanceCrater instanceCrater, ContextManager contextManager, AutomaticWiringParams automaticWiringParams, ActionManager actionManager) {
        this.instanceCrater = instanceCrater;
        this.contextManager = contextManager;
        this.automaticWiringParams = automaticWiringParams;
        this.actionManager = actionManager;
    }

    @Override
    public <T extends Annotation> void registeredAnnotation(Class<T> annotation, ClassAttributeManager attributeManager) {
        MapUtils.append(this.registeredAnnotations, annotation, (Object)attributeManager, CopyOnWriteArrayList.class);
    }

    @Override
    public void add(Class<?> cla) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Object o;
        Object object;
        if (!this.set.add(cla)) {
            return;
        }
        String id = null;
        if (cla.isAnnotationPresent(CommentScan.class)) {
            object = this.contextManager.getContextEntity(cla);
        }
        if (cla.isAnnotationPresent(Entity.class) && (o = this.contextManager.getContextEntity(cla)) == null) {
            id = cla.getDeclaredAnnotation(Entity.class).value();
            this.m1(id, cla);
        }
        if (cla.isAnnotationPresent(Controller.class) && (o = this.contextManager.getContextEntity(cla)) == null) {
            id = cla.getDeclaredAnnotation(Controller.class).value();
            object = this.m1(id, cla);
        }
        for (Class clazz : this.registeredAnnotations.keySet()) {
            if (!cla.isAnnotationPresent(clazz)) continue;
            for (ClassAttributeManager classAttributeManager : this.registeredAnnotations.get(clazz)) {
                classAttributeManager.manager(cla, this.contextManager);
            }
        }
    }

    private Object m1(String id, Class cla) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        try {
            Object o = this.instanceCrater.create(cla, this.contextManager);
            this.contextManager.append(o, id);
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("exception on " + cla.getName());
            return null;
        }
    }
}

