/*
 * Decompiled with CFR 0.152.
 */
package cpufeatures.arm;

import cpufeatures.arm.ArmFeatures;
import java.util.function.Predicate;

public enum ArmFeature {
    SWP(ArmFeatures::swp),
    HALF(ArmFeatures::half),
    THUMB(ArmFeatures::thumb),
    _26BIT(ArmFeatures::_26bit),
    FASTMULT(ArmFeatures::fastmult),
    FPA(ArmFeatures::fpa),
    VFP(ArmFeatures::vfp),
    EDSP(ArmFeatures::edsp),
    JAVA(ArmFeatures::java),
    IWMMXT(ArmFeatures::iwmmxt),
    CRUNCH(ArmFeatures::crunch),
    THUMBEE(ArmFeatures::thumbee),
    NEON(ArmFeatures::neon),
    VFPV3(ArmFeatures::vfpv3),
    VFPV3D16(ArmFeatures::vfpv3d16),
    TLS(ArmFeatures::tls),
    VFPV4(ArmFeatures::vfpv4),
    IDIVA(ArmFeatures::idiva),
    IDIVT(ArmFeatures::idivt),
    VFPD32(ArmFeatures::vfpd32),
    LPAE(ArmFeatures::lpae),
    EVTSTRM(ArmFeatures::evtstrm),
    AES(ArmFeatures::aes),
    PMULL(ArmFeatures::pmull),
    SHA1(ArmFeatures::sha1),
    SHA2(ArmFeatures::sha2),
    CRC32(ArmFeatures::crc32);

    private final Predicate<ArmFeatures> predicate;

    private ArmFeature(Predicate<ArmFeatures> predicate) {
        this.predicate = predicate;
    }

    public boolean in(ArmFeatures features) {
        return this.predicate.test(features);
    }
}

