/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.ArrayUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public final class ConvertUtils {
    private static final String TAG = ConvertUtils.class.getSimpleName();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] HEX_DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ConvertUtils() {
    }

    public static <T> T convert(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return (T)object;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "convert", new Object[0]);
            return null;
        }
    }

    @Deprecated
    public static String toString(byte[] data) {
        return ConvertUtils.newString(data, null);
    }

    @Deprecated
    public static String toString(byte[] data, String defaultStr) {
        return ConvertUtils.newString(data, defaultStr);
    }

    @Deprecated
    public static String toString(char[] data) {
        return ConvertUtils.newString(data, null);
    }

    @Deprecated
    public static String toString(char[] data, String defaultStr) {
        return ConvertUtils.newString(data, defaultStr);
    }

    public static String newString(Object value) {
        return ConvertUtils.newString(value, null);
    }

    public static String newString(Object value, String defaultStr) {
        if (value != null) {
            try {
                if (value instanceof byte[]) {
                    return new String((byte[])value);
                }
                if (value instanceof char[]) {
                    return new String((char[])value);
                }
                if (value instanceof String) {
                    return (String)value;
                }
                if (value instanceof StringBuffer) {
                    return new String((StringBuffer)value);
                }
                if (value instanceof StringBuilder) {
                    return new String((StringBuilder)value);
                }
                throw new Exception("can not new string, value : " + value);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "newString", new Object[0]);
            }
        }
        return defaultStr;
    }

    public static String toString(Object object) {
        return ConvertUtils.toString(object, null);
    }

    public static String toString(Object object, String defaultStr) {
        if (object != null) {
            try {
                if (object instanceof String) {
                    return (String)object;
                }
                if (object instanceof Integer) {
                    return Integer.toString((Integer)object);
                }
                if (object instanceof Boolean) {
                    return Boolean.toString((Boolean)object);
                }
                if (object instanceof Long) {
                    return Long.toString((Long)object);
                }
                if (object instanceof Double) {
                    return Double.toString((Double)object);
                }
                if (object instanceof Float) {
                    return Float.toString(((Float)object).floatValue());
                }
                if (object instanceof Byte) {
                    return Byte.toString((Byte)object);
                }
                if (object instanceof Character) {
                    return Character.toString(((Character)object).charValue());
                }
                if (object instanceof Short) {
                    return Short.toString((Short)object);
                }
                Class<Object[]> clazz = object.getClass();
                if (clazz.isArray()) {
                    if (clazz.isAssignableFrom(int[].class)) {
                        return Arrays.toString((int[])object);
                    }
                    if (clazz.isAssignableFrom(boolean[].class)) {
                        return Arrays.toString((boolean[])object);
                    }
                    if (clazz.isAssignableFrom(long[].class)) {
                        return Arrays.toString((long[])object);
                    }
                    if (clazz.isAssignableFrom(double[].class)) {
                        return Arrays.toString((double[])object);
                    }
                    if (clazz.isAssignableFrom(float[].class)) {
                        return Arrays.toString((float[])object);
                    }
                    if (clazz.isAssignableFrom(byte[].class)) {
                        return Arrays.toString((byte[])object);
                    }
                    if (clazz.isAssignableFrom(char[].class)) {
                        return Arrays.toString((char[])object);
                    }
                    if (clazz.isAssignableFrom(short[].class)) {
                        return Arrays.toString((short[])object);
                    }
                    return Arrays.toString((Object[])object);
                }
                return object.toString();
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "toString", new Object[0]);
            }
        }
        return defaultStr;
    }

    public static Integer toInt(Object value) {
        return ConvertUtils.toInt(value, 0);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                String strVal = (String)value;
                if (strVal.indexOf(44) != 0) {
                    strVal = strVal.replaceAll(",", "");
                }
                return Integer.parseInt(strVal);
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1 : 0;
            }
            throw new Exception("can not cast to int, value : " + value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toInt", new Object[0]);
            return defaultValue;
        }
    }

    public static Boolean toBoolean(Object value) {
        return ConvertUtils.toBoolean(value, false);
    }

    public static Boolean toBoolean(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() == 1;
            }
            if (value instanceof String) {
                String strVal = (String)value;
                if ("true".equalsIgnoreCase(strVal) || "1".equals(strVal)) {
                    return Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(strVal) || "0".equals(strVal)) {
                    return Boolean.FALSE;
                }
                if ("Y".equalsIgnoreCase(strVal) || "T".equalsIgnoreCase(strVal)) {
                    return Boolean.TRUE;
                }
                if ("N".equalsIgnoreCase(strVal) || "F".equalsIgnoreCase(strVal)) {
                    return Boolean.FALSE;
                }
            }
            throw new Exception("can not cast to boolean, value : " + value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toBoolean", new Object[0]);
            return defaultValue;
        }
    }

    public static Float toFloat(Object value) {
        return ConvertUtils.toFloat(value, Float.valueOf(0.0f));
    }

    public static Float toFloat(Object value, Float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Float) {
                return (Float)value;
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof String) {
                String strVal = (String)value;
                if (strVal.indexOf(44) != 0) {
                    strVal = strVal.replaceAll(",", "");
                }
                return Float.valueOf(Float.parseFloat(strVal));
            }
            throw new Exception("can not cast to float, value : " + value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toFloat", new Object[0]);
            return defaultValue;
        }
    }

    public static Double toDouble(Object value) {
        return ConvertUtils.toDouble(value, 0.0);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                String strVal = (String)value;
                if (strVal.indexOf(44) != 0) {
                    strVal = strVal.replaceAll(",", "");
                }
                return Double.parseDouble(strVal);
            }
            throw new Exception("can not cast to double, value : " + value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toDouble", new Object[0]);
            return defaultValue;
        }
    }

    public static Long toLong(Object value) {
        return ConvertUtils.toLong(value, 0L);
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                String strVal = (String)value;
                if (strVal.indexOf(44) != 0) {
                    strVal = strVal.replaceAll(",", "");
                }
                return Long.parseLong(strVal);
            }
            throw new Exception("can not cast to long, value : " + value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toLong", new Object[0]);
            return defaultValue;
        }
    }

    public static Short toShort(Object value) {
        return ConvertUtils.toShort(value, (short)0);
    }

    public static Short toShort(Object value, Short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Short) {
                return (Short)value;
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof String) {
                String strVal = (String)value;
                return Short.parseShort(strVal);
            }
            throw new Exception("can not cast to short, value : " + value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toShort", new Object[0]);
            return defaultValue;
        }
    }

    public static Character toChar(Object value) {
        return ConvertUtils.toChar(value, Character.valueOf('\u0000'));
    }

    public static Character toChar(Object value, Character defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            String strVal;
            if (value instanceof Character) {
                return (Character)value;
            }
            if (value instanceof String && (strVal = (String)value).length() == 1) {
                return Character.valueOf(strVal.charAt(0));
            }
            throw new Exception("can not cast to char, value : " + value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toChar", new Object[0]);
            return defaultValue;
        }
    }

    public static byte toByte(Object value) {
        return ConvertUtils.toByte(value, (byte)0);
    }

    public static byte toByte(Object value, Byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Byte) {
                return (Byte)value;
            }
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof String) {
                String strVal = (String)value;
                return Byte.parseByte(strVal);
            }
            throw new Exception("can not cast to byte, value : " + value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toByte", new Object[0]);
            return defaultValue;
        }
    }

    public static BigDecimal toBigDecimal(Object value) {
        return ConvertUtils.toBigDecimal(value, BigDecimal.ZERO);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (value instanceof String) {
                String strVal = (String)value;
                return new BigDecimal(strVal);
            }
            throw new Exception("can not cast to BigDecimal, value : " + value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toBigDecimal", new Object[0]);
            return defaultValue;
        }
    }

    public static BigInteger toBigInteger(Object value) {
        return ConvertUtils.toBigInteger(value, BigInteger.valueOf(0L));
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof BigInteger) {
                return (BigInteger)value;
            }
            if (value instanceof Float || value instanceof Double) {
                return BigInteger.valueOf(((Number)value).longValue());
            }
            if (value instanceof String) {
                String strVal = (String)value;
                return new BigInteger(strVal);
            }
            throw new Exception("can not cast to BigInteger, value : " + value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toBigInteger", new Object[0]);
            return defaultValue;
        }
    }

    public static char[] toChars(Object value) {
        try {
            if (value instanceof char[]) {
                return (char[])value;
            }
            if (value instanceof String) {
                return ((String)value).toCharArray();
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toChars", new Object[0]);
        }
        return null;
    }

    public static byte[] toBytes(Object value) {
        try {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            if (value instanceof String) {
                return ((String)value).getBytes();
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toBytes", new Object[0]);
        }
        return null;
    }

    public static int toCharInt(char value) {
        return value;
    }

    public static char charAt(Object value, char defaultValue) {
        return ConvertUtils.charAt(value, 0, defaultValue);
    }

    public static char charAt(Object value, int pos, char defaultValue) {
        if (value == null || pos < 0) {
            return defaultValue;
        }
        try {
            return ConvertUtils.toChars(value)[pos];
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "charAt", new Object[0]);
            return defaultValue;
        }
    }

    public static int parseInt(String str, int radix) {
        if (str == null) {
            return -1;
        }
        try {
            return Integer.parseInt(str, radix);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "parseInt", new Object[0]);
            return -1;
        }
    }

    public static long parseLong(String str, int radix) {
        if (str == null) {
            return -1L;
        }
        try {
            return Long.parseLong(str, radix);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "parseLong", new Object[0]);
            return -1L;
        }
    }

    public static byte[] valueOf(short data) {
        try {
            byte[] bytes = new byte[2];
            for (int i = 0; i < 2; ++i) {
                int offset = (bytes.length - 1 - i) * 8;
                bytes[i] = (byte)(data >>> offset & 0xFF);
            }
            return bytes;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "valueOf", new Object[0]);
            return null;
        }
    }

    public static byte[] valueOf(int data) {
        try {
            byte[] bytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                int offset = (bytes.length - 1 - i) * 8;
                bytes[i] = (byte)(data >>> offset & 0xFF);
            }
            return bytes;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "valueOf", new Object[0]);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object bytesToObject(byte[] bytes) {
        Object object;
        if (bytes == null) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            object = ois.readObject();
        }
        catch (Exception e) {
            try {
                JCLogUtils.eTag(TAG, e, "bytesToObject", new Object[0]);
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(ois);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(ois);
            return null;
        }
        CloseUtils.closeIOQuietly(ois);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] objectToBytes(Object object) {
        byte[] byArray;
        if (object == null) {
            return null;
        }
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            byArray = baos.toByteArray();
        }
        catch (Exception e) {
            try {
                JCLogUtils.eTag(TAG, e, "objectToBytes", new Object[0]);
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(oos);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(oos);
            return null;
        }
        CloseUtils.closeIOQuietly(oos);
        return byArray;
    }

    public static char[] bytesToChars(byte[] data) {
        if (data == null) {
            return null;
        }
        int len = data.length;
        if (len == 0) {
            return null;
        }
        try {
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)(data[i] & 0xFF);
            }
            return chars;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "bytesToChars", new Object[0]);
            return null;
        }
    }

    public static byte[] charsToBytes(char[] data) {
        if (data == null) {
            return null;
        }
        int len = data.length;
        if (len == 0) {
            return null;
        }
        try {
            byte[] bytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                bytes[i] = (byte)data[i];
            }
            return bytes;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "charsToBytes", new Object[0]);
            return null;
        }
    }

    public static String[] intsToStrings(int[] datas) {
        return ConvertUtils.intsToStrings(0, datas != null ? datas.length : 0, datas);
    }

    public static String[] intsToStrings(int off, int[] datas) {
        return ConvertUtils.intsToStrings(off, datas != null ? datas.length : 0, datas);
    }

    public static String[] intsToStrings(int off, int length, int[] datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        String[] strings = new String[length - off];
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            strings[i] = String.valueOf(datas[off + i]);
        }
        return strings;
    }

    public static String[] doublesToStrings(double[] datas) {
        return ConvertUtils.doublesToStrings(0, datas != null ? datas.length : 0, datas);
    }

    public static String[] doublesToStrings(int off, double[] datas) {
        return ConvertUtils.doublesToStrings(off, datas != null ? datas.length : 0, datas);
    }

    public static String[] doublesToStrings(int off, int length, double[] datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        String[] strings = new String[length - off];
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            strings[i] = String.valueOf(datas[off + i]);
        }
        return strings;
    }

    public static String[] longsToStrings(long[] datas) {
        return ConvertUtils.longsToStrings(0, datas != null ? datas.length : 0, datas);
    }

    public static String[] longsToStrings(int off, long[] datas) {
        return ConvertUtils.longsToStrings(off, datas != null ? datas.length : 0, datas);
    }

    public static String[] longsToStrings(int off, int length, long[] datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        String[] strings = new String[length - off];
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            strings[i] = String.valueOf(datas[off + i]);
        }
        return strings;
    }

    public static String[] floatsToStrings(float[] datas) {
        return ConvertUtils.floatsToStrings(0, datas != null ? datas.length : 0, datas);
    }

    public static String[] floatsToStrings(int off, float[] datas) {
        return ConvertUtils.floatsToStrings(off, datas != null ? datas.length : 0, datas);
    }

    public static String[] floatsToStrings(int off, int length, float[] datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        String[] strings = new String[length - off];
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            strings[i] = String.valueOf(datas[off + i]);
        }
        return strings;
    }

    public static double[] intsToDoubles(int[] datas) {
        return ConvertUtils.intsToDoubles(0, datas != null ? datas.length : 0, datas);
    }

    public static double[] intsToDoubles(int off, int[] datas) {
        return ConvertUtils.intsToDoubles(off, datas != null ? datas.length : 0, datas);
    }

    public static double[] intsToDoubles(int off, int length, int[] datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        double[] doubles = new double[length - off];
        int len = doubles.length;
        for (int i = 0; i < len; ++i) {
            doubles[i] = datas[off + i];
        }
        return doubles;
    }

    public static long[] intsToLongs(int[] datas) {
        return ConvertUtils.intsToLongs(0, datas != null ? datas.length : 0, datas);
    }

    public static long[] intsToLongs(int off, int[] datas) {
        return ConvertUtils.intsToLongs(off, datas != null ? datas.length : 0, datas);
    }

    public static long[] intsToLongs(int off, int length, int[] datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        long[] longs = new long[length - off];
        int len = longs.length;
        for (int i = 0; i < len; ++i) {
            longs[i] = datas[off + i];
        }
        return longs;
    }

    public static float[] intsToFloats(int[] datas) {
        return ConvertUtils.intsToFloats(0, datas != null ? datas.length : 0, datas);
    }

    public static float[] intsToFloats(int off, int[] datas) {
        return ConvertUtils.intsToFloats(off, datas != null ? datas.length : 0, datas);
    }

    public static float[] intsToFloats(int off, int length, int[] datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        float[] floats = new float[length - off];
        int len = floats.length;
        for (int i = 0; i < len; ++i) {
            floats[i] = datas[off + i];
        }
        return floats;
    }

    public static int[] stringsToInts(String ... datas) {
        return ConvertUtils.stringsToInts(0, datas != null ? datas.length : 0, -1, datas);
    }

    public static int[] stringsToInts(int off, String ... datas) {
        return ConvertUtils.stringsToInts(off, datas != null ? datas.length : 0, -1, datas);
    }

    public static int[] stringsToInts(int off, int length, String ... datas) {
        return ConvertUtils.stringsToInts(off, length, -1, datas);
    }

    public static int[] stringsToInts(int off, int length, int errorValue, String ... datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        int[] ints = new int[length - off];
        int len = ints.length;
        for (int i = 0; i < len; ++i) {
            try {
                ints[i] = Integer.parseInt(datas[off + i]);
                continue;
            }
            catch (Exception e) {
                ints[i] = errorValue;
            }
        }
        return ints;
    }

    public static double[] stringsToDoubles(String ... datas) {
        return ConvertUtils.stringsToDoubles(0, datas != null ? datas.length : 0, -1.0, datas);
    }

    public static double[] stringsToDoubles(int off, String ... datas) {
        return ConvertUtils.stringsToDoubles(off, datas != null ? datas.length : 0, -1.0, datas);
    }

    public static double[] stringsToDoubles(int off, int length, String ... datas) {
        return ConvertUtils.stringsToDoubles(off, length, -1.0, datas);
    }

    public static double[] stringsToDoubles(int off, int length, double errorValue, String ... datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        double[] doubles = new double[length - off];
        int len = doubles.length;
        for (int i = 0; i < len; ++i) {
            try {
                doubles[i] = Double.parseDouble(datas[off + i]);
                continue;
            }
            catch (Exception e) {
                doubles[i] = errorValue;
            }
        }
        return doubles;
    }

    public static long[] stringsToLongs(String ... datas) {
        return ConvertUtils.stringsToLongs(0, datas != null ? datas.length : 0, -1L, datas);
    }

    public static long[] stringsToLongs(int off, String ... datas) {
        return ConvertUtils.stringsToLongs(off, datas != null ? datas.length : 0, -1L, datas);
    }

    public static long[] stringsToLongs(int off, int length, String ... datas) {
        return ConvertUtils.stringsToLongs(off, length, -1L, datas);
    }

    public static long[] stringsToLongs(int off, int length, long errorValue, String ... datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        long[] longs = new long[length - off];
        int len = longs.length;
        for (int i = 0; i < len; ++i) {
            try {
                longs[i] = Long.parseLong(datas[off + i]);
                continue;
            }
            catch (Exception e) {
                longs[i] = errorValue;
            }
        }
        return longs;
    }

    public static float[] stringsToFloats(String ... datas) {
        return ConvertUtils.stringsToFloats(0, datas != null ? datas.length : 0, -1.0f, datas);
    }

    public static float[] stringsToFloats(int off, String ... datas) {
        return ConvertUtils.stringsToFloats(off, datas != null ? datas.length : 0, -1.0f, datas);
    }

    public static float[] stringsToFloats(int off, int length, String ... datas) {
        return ConvertUtils.stringsToFloats(off, length, -1.0f, datas);
    }

    public static float[] stringsToFloats(int off, int length, float errorValue, String ... datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        float[] floats = new float[length - off];
        int len = floats.length;
        for (int i = 0; i < len; ++i) {
            try {
                floats[i] = Float.parseFloat(datas[off + i]);
                continue;
            }
            catch (Exception e) {
                floats[i] = errorValue;
            }
        }
        return floats;
    }

    public static int[] doublesToInts(double[] datas) {
        return ConvertUtils.doublesToInts(0, datas != null ? datas.length : 0, datas);
    }

    public static int[] doublesToInts(int off, double[] datas) {
        return ConvertUtils.doublesToInts(off, datas != null ? datas.length : 0, datas);
    }

    public static int[] doublesToInts(int off, int length, double[] datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        int[] ints = new int[length - off];
        int len = ints.length;
        for (int i = 0; i < len; ++i) {
            try {
                ints[i] = (int)datas[off + i];
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ints;
    }

    public static int[] longsToInts(long[] datas) {
        return ConvertUtils.longsToInts(0, datas != null ? datas.length : 0, datas);
    }

    public static int[] longsToInts(int off, long[] datas) {
        return ConvertUtils.longsToInts(off, datas != null ? datas.length : 0, datas);
    }

    public static int[] longsToInts(int off, int length, long[] datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        int[] ints = new int[length - off];
        int len = ints.length;
        for (int i = 0; i < len; ++i) {
            try {
                ints[i] = (int)datas[off + i];
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ints;
    }

    public static int[] floatsToInts(float[] datas) {
        return ConvertUtils.floatsToInts(0, datas != null ? datas.length : 0, datas);
    }

    public static int[] floatsToInts(int off, float[] datas) {
        return ConvertUtils.floatsToInts(off, datas != null ? datas.length : 0, datas);
    }

    public static int[] floatsToInts(int off, int length, float[] datas) {
        if (off < 0 || length < 1 || off >= length || datas == null || length > datas.length) {
            return null;
        }
        int[] ints = new int[length - off];
        int len = ints.length;
        for (int i = 0; i < len; ++i) {
            try {
                ints[i] = (int)datas[off + i];
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ints;
    }

    public static String toBinaryString(byte ... datas) {
        if (datas == null || datas.length == 0) {
            return null;
        }
        try {
            StringBuilder builder = new StringBuilder();
            for (byte value : datas) {
                for (int j = 7; j >= 0; --j) {
                    builder.append((value >> j & 1) == 0 ? (char)'0' : '1');
                }
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toBinaryString", new Object[0]);
            return null;
        }
    }

    public static byte[] decodeBinary(String str) {
        if (str == null) {
            return null;
        }
        try {
            Object data = str;
            int lenMod = ((String)data).length() % 8;
            int byteLen = ((String)data).length() / 8;
            if (lenMod != 0) {
                for (int i = lenMod; i < 8; ++i) {
                    data = "0" + (String)data;
                }
                ++byteLen;
            }
            byte[] bytes = new byte[byteLen];
            for (int i = 0; i < byteLen; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int n = i;
                    bytes[n] = (byte)(bytes[n] << 1);
                    int n2 = i;
                    bytes[n2] = (byte)(bytes[n2] | ((String)data).charAt(i * 8 + j) - 48);
                }
            }
            return bytes;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "decodeBinary", new Object[0]);
            return null;
        }
    }

    public static boolean isHex(String data) {
        if (data == null) {
            return false;
        }
        int len = data.length();
        if (len > 0) {
            for (int i = len - 1; i >= 0; --i) {
                char c = data.charAt(i);
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static byte[] decodeHex(byte[] data) {
        return ConvertUtils.decodeHex(ArrayUtils.length(data) == 0 ? null : ConvertUtils.bytesToChars(data));
    }

    public static byte[] decodeHex(String str) {
        return ConvertUtils.decodeHex(StringUtils.isEmpty(str) ? null : str.toCharArray());
    }

    public static byte[] decodeHex(char[] data) {
        if (data == null) {
            return null;
        }
        try {
            int len = data.length;
            byte[] out = new byte[len >> 1];
            int i = 0;
            int j = 0;
            while (j < len) {
                int d = ConvertUtils.toDigit(data[j], j) << 4;
                d |= ConvertUtils.toDigit(data[++j], j);
                ++j;
                out[i] = (byte)(d & 0xFF);
                ++i;
            }
            return out;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "decodeHex", new Object[0]);
            return null;
        }
    }

    public static int hexToInt(char hexChar) {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        throw new IllegalArgumentException();
    }

    private static int toDigit(char ch, int index) throws Exception {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new Exception(String.format("Illegal hexadecimal character %s at index %s", Character.valueOf(ch), index));
        }
        return digit;
    }

    public static String toHexString(int value) {
        try {
            return Integer.toHexString(value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toHexString", new Object[0]);
            return null;
        }
    }

    public static String toHexString(long value) {
        try {
            return Long.toHexString(value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toHexString", new Object[0]);
            return null;
        }
    }

    public static String toHexString(double value) {
        try {
            return Double.toHexString(value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toHexString", new Object[0]);
            return null;
        }
    }

    public static String toHexString(float value) {
        try {
            return Float.toHexString(value);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toHexString", new Object[0]);
            return null;
        }
    }

    public static char[] toHexChars(String str) {
        return ConvertUtils.toHexChars(str, true);
    }

    public static char[] toHexChars(String str, boolean toLowerCase) {
        return ConvertUtils.toHexChars(StringUtils.isEmpty(str) ? null : str.getBytes(), toLowerCase ? HEX_DIGITS : HEX_DIGITS_UPPER);
    }

    public static char[] toHexChars(byte[] data) {
        return ConvertUtils.toHexChars(data, true);
    }

    public static char[] toHexChars(byte[] data, boolean toLowerCase) {
        return ConvertUtils.toHexChars(data, toLowerCase ? HEX_DIGITS : HEX_DIGITS_UPPER);
    }

    private static char[] toHexChars(byte[] data, char[] hexDigits) {
        if (data == null || hexDigits == null) {
            return null;
        }
        try {
            return ConvertUtils.toHexString(data, hexDigits).toCharArray();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toHexChars", new Object[0]);
            return null;
        }
    }

    public static String toHexString(String str) {
        return ConvertUtils.toHexString(str, true);
    }

    public static String toHexString(String str, boolean toLowerCase) {
        return ConvertUtils.toHexString(StringUtils.isEmpty(str) ? null : str.getBytes(), toLowerCase ? HEX_DIGITS : HEX_DIGITS_UPPER);
    }

    public static String toHexString(byte[] data) {
        return ConvertUtils.toHexString(data, true);
    }

    public static String toHexString(byte[] data, boolean toLowerCase) {
        return ConvertUtils.toHexString(data, toLowerCase ? HEX_DIGITS : HEX_DIGITS_UPPER);
    }

    private static String toHexString(byte[] data, char[] hexDigits) {
        if (data == null || hexDigits == null) {
            return null;
        }
        try {
            int len = data.length;
            StringBuilder builder = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                builder.append(hexDigits[(data[i] & 0xF0) >>> 4]);
                builder.append(hexDigits[data[i] & 0xF]);
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "toHexString", new Object[0]);
            return null;
        }
    }

    public static void bytesBitwiseAND(byte[] data) {
        if (data == null) {
            return;
        }
        for (int n : data) {
            data[i] = (byte)(n ^= 0xFFFFFFFF);
        }
    }
}

