/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

public final class CoordinateUtils {
    private static final double X_PI = 52.35987755982988;
    private static final double A = 6378245.0;
    private static final double EE = 0.006693421622965943;
    private static final double EARTH_RADIUS = 6378.137;

    private CoordinateUtils() {
    }

    public static double[] bd09ToGcj02(double lng, double lat) {
        double x = lng - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        double gg_lng = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        return new double[]{gg_lng, gg_lat};
    }

    public static double[] gcj02ToBd09(double lng, double lat) {
        double z = Math.sqrt(lng * lng + lat * lat) + 2.0E-5 * Math.sin(lat * 52.35987755982988);
        double theta = Math.atan2(lat, lng) + 3.0E-6 * Math.cos(lng * 52.35987755982988);
        double bd_lng = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new double[]{bd_lng, bd_lat};
    }

    public static double[] gcj02ToWGS84(double lng, double lat) {
        if (CoordinateUtils.outOfChina(lng, lat)) {
            return new double[]{lng, lat};
        }
        double dlat = CoordinateUtils.transformLat(lng - 105.0, lat - 35.0);
        double dlng = CoordinateUtils.transformLng(lng - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (6335552.717000426 / (magic * sqrtmagic) * Math.PI);
        dlng = dlng * 180.0 / (6378245.0 / sqrtmagic * Math.cos(radlat) * Math.PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new double[]{lng * 2.0 - mglng, lat * 2.0 - mglat};
    }

    public static double[] wgs84ToGcj02(double lng, double lat) {
        if (CoordinateUtils.outOfChina(lng, lat)) {
            return new double[]{lng, lat};
        }
        double dlat = CoordinateUtils.transformLat(lng - 105.0, lat - 35.0);
        double dlng = CoordinateUtils.transformLng(lng - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (6335552.717000426 / (magic * sqrtmagic) * Math.PI);
        dlng = dlng * 180.0 / (6378245.0 / sqrtmagic * Math.cos(radlat) * Math.PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new double[]{mglng, mglat};
    }

    public static double[] bd09ToWGS84(double lng, double lat) {
        double[] gcj = CoordinateUtils.bd09ToGcj02(lng, lat);
        return CoordinateUtils.gcj02ToWGS84(gcj[0], gcj[1]);
    }

    public static double[] wgs84ToBd09(double lng, double lat) {
        double[] gcj = CoordinateUtils.wgs84ToGcj02(lng, lat);
        return CoordinateUtils.gcj02ToBd09(gcj[0], gcj[1]);
    }

    private static double transformLat(double lng, double lat) {
        double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat + 0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lat / 12.0 * Math.PI) + 320.0 * Math.sin(lat * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    private static double transformLng(double lng, double lat) {
        double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng + 0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lng * Math.PI) + 40.0 * Math.sin(lng / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lng / 12.0 * Math.PI) + 300.0 * Math.sin(lng / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    public static boolean outOfChina(double lng, double lat) {
        return lng < 72.004 || lng > 137.8347 || lat < 0.8293 || lat > 55.8271;
    }

    private static double rad(double degree) {
        return degree * Math.PI / 180.0;
    }

    public static double getDistance(double originLng, double originLat, double targetLng, double targetLat) {
        double radLat1 = CoordinateUtils.rad(originLat);
        double radLat2 = CoordinateUtils.rad(targetLat);
        double a = radLat1 - radLat2;
        double b = CoordinateUtils.rad(originLng) - CoordinateUtils.rad(targetLng);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6378.137;
        s = (double)Math.round(s * 100.0) / 100.0;
        return s *= 1000.0;
    }

    public static double getAngle(double originLng, double originLat, double targetLng, double targetLat) {
        double radLat1 = CoordinateUtils.rad(originLat);
        double radLng1 = CoordinateUtils.rad(originLng);
        double radLat2 = CoordinateUtils.rad(targetLat);
        double radLng2 = CoordinateUtils.rad(targetLng);
        if (radLng1 == radLng2) {
            if (radLat1 > radLat2) {
                return 270.0;
            }
            if (radLat1 < radLat2) {
                return 90.0;
            }
            return 2.147483647E9;
        }
        double ret = 4.0 * Math.pow(Math.sin((radLat1 - radLat2) / 2.0), 2.0) - Math.pow(Math.sin((radLng1 - radLng2) / 2.0) * (Math.cos(radLat1) - Math.cos(radLat2)), 2.0);
        ret = Math.sqrt(ret);
        ret = ret / Math.sin(Math.abs(radLng1 - radLng2) / 2.0) * (Math.cos(radLat1) + Math.cos(radLat2));
        ret = Math.atan(ret) / Math.PI * 180.0;
        if (radLng1 > radLng2) {
            ret = radLat1 > radLat2 ? (ret += 180.0) : 180.0 - ret;
        } else if (radLat1 > radLat2) {
            ret = 360.0 - ret;
        }
        return ret;
    }

    public static Direction getDirection(double originLng, double originLat, double targetLng, double targetLat) {
        double angle = CoordinateUtils.getAngle(originLng, originLat, targetLng, targetLat);
        return CoordinateUtils.getDirection(angle);
    }

    public static Direction getDirection(double angle) {
        if (angle == 2.147483647E9) {
            return Direction.SAME;
        }
        if (angle <= 10.0 || angle > 350.0) {
            return Direction.RIGHT;
        }
        if (angle > 10.0 && angle <= 80.0) {
            return Direction.RIGHT_TOP;
        }
        if (angle > 80.0 && angle <= 100.0) {
            return Direction.TOP;
        }
        if (angle > 100.0 && angle <= 170.0) {
            return Direction.LEFT_TOP;
        }
        if (angle > 170.0 && angle <= 190.0) {
            return Direction.LEFT;
        }
        if (angle > 190.0 && angle <= 260.0) {
            return Direction.LEFT_BOTTOM;
        }
        if (angle > 260.0 && angle <= 280.0) {
            return Direction.BOTTOM;
        }
        if (angle > 280.0 && angle <= 350.0) {
            return Direction.RIGHT_BOTTOM;
        }
        return Direction.SAME;
    }

    public static enum Direction {
        SAME("\u76f8\u540c"),
        TOP("\u5317"),
        BOTTOM("\u5357"),
        LEFT("\u897f"),
        RIGHT("\u4e1c"),
        LEFT_TOP("\u897f\u5317"),
        LEFT_BOTTOM("\u897f\u5357"),
        RIGHT_TOP("\u4e1c\u5317"),
        RIGHT_BOTTOM("\u4e1c\u5357");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

