/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.ConvertUtils;
import dev.utils.common.NumberUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public final class DateUtils {
    private static final String TAG = DateUtils.class.getSimpleName();
    public static final String yyyy = "yyyy";
    public static final String yyyyMMdd = "yyyy-MM-dd";
    public static final String yyyyMMdd2 = "yyyyMMdd";
    public static final String yyyyMMdd3 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String yyyyMMddHHmmss = "yyyy-MM-dd HH:mm:ss";
    public static final String yyyyMMddHHmmss_2 = "yyyy\u5e74M\u6708d\u65e5 HH:mm:ss";
    public static final String yyyyMMdd_HHmmss = "yyyyMMdd_HHmmss";
    public static final String MMdd = "MM-dd";
    public static final String MMdd2 = "MM\u6708dd\u65e5";
    public static final String MMdd3 = "MMdd";
    public static final String HHmm = "HH:mm";
    public static final String HHmm2 = "HHmm";
    public static final String HHmmss = "HH:mm:ss";
    public static final String HHmmss2 = "HHmmss";
    public static final String hhmmMMDDyyyy = "hh:mm M\u6708d\u65e5 yyyy";
    public static final String hhmmssMMDDyyyy = "hh:mm:ss M\u6708d\u65e5 yyyy";
    public static final int MINUTE_S = 60;
    public static final int HOUR_S = 3600;
    public static final int DAY_S = 86400;
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31536000000L;
    private static final String[] ZODIAC = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    private static final int[] CONSTELLATION_DAY = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] CONSTELLATION_DATE = new String[]{"01.20-02.18", "02.19-03.20", "03.21-04.19", "04.20-05.20", "05.21-06.21", "06.22-07.22", "07.23-08.22", "08.23-09.22", "09.23-10.23", "10.24-11.22", "11.23-12.21", "12.22-01.19"};
    private static final String[] CONSTELLATION = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};

    private DateUtils() {
    }

    public static String getDateNow() {
        return DateUtils.getDateNow(yyyyMMddHHmmss);
    }

    public static String getDateNow(String format) {
        if (format == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(format).format(Calendar.getInstance().getTime());
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getDateNow", new Object[0]);
            return null;
        }
    }

    public static String formatTime(long time, String format) {
        if (format == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(format).format(time);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "formatTime", new Object[0]);
            return null;
        }
    }

    public static String formatDate(Date date, String format) {
        if (date == null || format == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(format).format(date);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "formatDate", new Object[0]);
            return null;
        }
    }

    public static Date parseDate(long time) {
        try {
            return new Date(time);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "parseDate", new Object[0]);
            return null;
        }
    }

    public static Date parseDate(String time) {
        return DateUtils.parseDate(time, yyyyMMddHHmmss);
    }

    public static Date parseDate(String time, String format) {
        if (time == null || format == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(format).parse(time);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "parseDate", new Object[0]);
            return null;
        }
    }

    public static long parseLong(String time) {
        return DateUtils.parseLong(time, yyyyMMddHHmmss);
    }

    public static long parseLong(String time, String format) {
        if (time == null || format == null) {
            return 0L;
        }
        try {
            return new SimpleDateFormat(format).parse(time).getTime();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "parseLong", new Object[0]);
            return 0L;
        }
    }

    public static String parseToString(String time, String timeFormat, String format) {
        if (time != null && timeFormat != null && format != null) {
            try {
                Date date = DateUtils.parseDate(time, timeFormat);
                return DateUtils.formatDate(date, format);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "parseToString", new Object[0]);
            }
        }
        return null;
    }

    public static int getTimeDiffMinute(long time) {
        return (int)(time / 60000L);
    }

    public static int getTimeDiffHour(long time) {
        return (int)(time / 3600000L);
    }

    public static int getTimeDiffDay(long time) {
        return (int)(time / 86400000L);
    }

    public static long getTimeDiff(long time) {
        return time - System.currentTimeMillis();
    }

    public static long getTimeDiff(String time1, String time2) {
        long timeLong1 = DateUtils.parseLong(time1);
        long timeLong2 = DateUtils.parseLong(time2);
        if (timeLong1 > 1L && timeLong2 > 1L) {
            return timeLong1 - timeLong2;
        }
        return -2L;
    }

    public static long getTimeDiff(String time1, String timeFormat1, String time2, String timeFormat2) {
        long timeLong1 = DateUtils.parseLong(time1, timeFormat1);
        long timeLong2 = DateUtils.parseLong(time2, timeFormat2);
        if (timeLong1 > 1L && timeLong2 > 1L) {
            return timeLong1 - timeLong2;
        }
        return -2L;
    }

    public static int getYear(Date date) {
        if (date == null) {
            return -1;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.get(1);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getYear", new Object[0]);
            return -1;
        }
    }

    public static int getMonth(Date date) {
        if (date == null) {
            return -1;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.get(2) + 1;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMonth", new Object[0]);
            return -1;
        }
    }

    public static int getDay(Date date) {
        if (date == null) {
            return -1;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.get(5);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getDay", new Object[0]);
            return -1;
        }
    }

    public static int getWeek(Date date) {
        if (date == null) {
            return -1;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.get(7);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getWeek", new Object[0]);
            return -1;
        }
    }

    public static int get24Hour(Date date) {
        if (date == null) {
            return -1;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.get(11);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get24Hour", new Object[0]);
            return -1;
        }
    }

    public static int get12Hour(Date date) {
        if (date == null) {
            return -1;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.get(10);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get12Hour", new Object[0]);
            return -1;
        }
    }

    public static int getMinute(Date date) {
        if (date == null) {
            return -1;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.get(12);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getMinute", new Object[0]);
            return -1;
        }
    }

    public static int getSecond(Date date) {
        if (date == null) {
            return -1;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.get(13);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getSecond", new Object[0]);
            return -1;
        }
    }

    public static String timeAddZero(int time) {
        return DateUtils.timeAddZero(time, true);
    }

    public static String timeAddZero(int time, boolean append) {
        return NumberUtils.addZero(time, append);
    }

    public static int getYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int getDay() {
        return Calendar.getInstance().get(5);
    }

    public static int getWeek() {
        return Calendar.getInstance().get(7);
    }

    public static int get24Hour() {
        return Calendar.getInstance().get(11);
    }

    public static int get12Hour() {
        return Calendar.getInstance().get(10);
    }

    public static int getMinute() {
        return Calendar.getInstance().get(12);
    }

    public static int getSecond() {
        return Calendar.getInstance().get(13);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getMonthDayNumberAll(int year, int month) {
        int number = 31;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                number = 31;
                break;
            }
            case 2: {
                if (DateUtils.isLeapYear(year)) {
                    number = 29;
                    break;
                }
                number = 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                number = 30;
            }
        }
        return number;
    }

    public static int getYearMonthNumber(int year) {
        if (year == DateUtils.getYear()) {
            return DateUtils.getMonth();
        }
        return 12;
    }

    public static int getMonthDayNumber(int year, int month) {
        if (year == DateUtils.getYear() && DateUtils.getYearMonthNumber(year) == month) {
            return DateUtils.getDay();
        }
        return DateUtils.getMonthDayNumberAll(year, month);
    }

    public static String[] getArrayToHH() {
        List<String> lists = DateUtils.getListToHH();
        return lists.toArray(new String[lists.size()]);
    }

    public static List<String> getListToHH() {
        ArrayList<String> lists = new ArrayList<String>();
        for (int i = 0; i < 24; ++i) {
            lists.add(DateUtils.timeAddZero(i, true));
        }
        return lists;
    }

    public static String[] getArrayToMM() {
        List<String> lists = DateUtils.getListToMM();
        return lists.toArray(new String[lists.size()]);
    }

    public static List<String> getListToMM() {
        ArrayList<String> lists = new ArrayList<String>();
        for (int i = 0; i < 60; ++i) {
            lists.add(DateUtils.timeAddZero(i, true));
        }
        return lists;
    }

    public static String[] getArrayToHHMM(int type) {
        List<String> lists = DateUtils.getListToHHMM(type);
        return lists.toArray(new String[lists.size()]);
    }

    public static List<String> getListToHHMM(int type) {
        ArrayList<String> lists = new ArrayList<String>();
        switch (type) {
            case 0: {
                for (int i = 0; i < 24; ++i) {
                    lists.add(DateUtils.timeAddZero(i, true) + ":00");
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 96; ++i) {
                    String minute;
                    String hour;
                    if (i % 2 == 0) {
                        hour = DateUtils.timeAddZero(i / 4, true);
                        minute = i % 4 == 0 ? "00" : "30";
                        lists.add(hour + ":" + minute);
                        continue;
                    }
                    hour = DateUtils.timeAddZero(i / 4, true);
                    minute = (i - 1) % 4 == 0 ? "15" : "45";
                    lists.add(hour + ":" + minute);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 48; ++i) {
                    int hour = i / 2;
                    if (i % 2 == 0) {
                        lists.add(DateUtils.timeAddZero(hour, true) + ":00");
                        continue;
                    }
                    lists.add(DateUtils.timeAddZero(hour, true) + ":30");
                }
                break;
            }
        }
        return lists;
    }

    public static int getListToHHMMPosition(String time, int type) {
        String[] timeSplit;
        if (time != null && time.length() != 0 && (timeSplit = time.split(":")) != null && timeSplit.length == 2) {
            int hour = ConvertUtils.toInt(timeSplit[0], -1);
            if (hour < 0) {
                return -1;
            }
            if (hour > 24) {
                return -1;
            }
            switch (type) {
                case 0: {
                    return hour;
                }
                case 1: 
                case 2: {
                    int minute = ConvertUtils.toInt(timeSplit[1], -1);
                    if (minute < 0) {
                        return -1;
                    }
                    if (minute > 59) {
                        return -1;
                    }
                    if (type == 1) {
                        if (minute >= 0 && minute < 15) {
                            return hour * 4;
                        }
                        if (minute >= 15 && minute < 30) {
                            return hour * 4 + 1;
                        }
                        if (minute >= 30 && minute < 45) {
                            return hour * 4 + 2;
                        }
                        if (minute < 30 || minute >= 60) break;
                        return hour * 4 + 3;
                    }
                    if (type != 2) break;
                    if (minute >= 30) {
                        return hour * 2 + 1;
                    }
                    return hour * 2;
                }
            }
        }
        return -1;
    }

    public static String secToTimeRetain(int time) {
        return DateUtils.secToTimeRetain(time, false);
    }

    public static String secToTimeRetain(int time, boolean isHandlerMDay) {
        try {
            if (time <= 0) {
                return "00:00:00";
            }
            if (time < 60) {
                return "00:00:" + (Serializable)(time >= 10 ? Integer.valueOf(time) : "0" + time);
            }
            if (time >= 60 && time < 3600) {
                int dSecond = time % 60;
                int dMinute = (time - dSecond) / 60;
                return "00:" + (Serializable)(dMinute >= 10 ? Integer.valueOf(dMinute) : "0" + dMinute) + ":" + (Serializable)(dSecond >= 10 ? Integer.valueOf(dSecond) : "0" + dSecond);
            }
            if (time >= 3600 && time < 86400) {
                int rMinute = time % 3600;
                int dHour = (time - rMinute) / 3600;
                int dSecond = time - dHour * 3600;
                int dMinute = dSecond / 60;
                int rSecond = dSecond % 60;
                return (Serializable)(dHour >= 10 ? Integer.valueOf(dHour) : "0" + dHour) + ":" + (Serializable)(dMinute >= 10 ? Integer.valueOf(dMinute) : "0" + dMinute) + ":" + (Serializable)(rSecond >= 10 ? Integer.valueOf(rSecond) : "0" + rSecond);
            }
            if (isHandlerMDay) {
                int rMinute = time % 3600;
                int dHour = (time - rMinute) / 3600;
                int dSecond = time - dHour * 3600;
                int dMinute = dSecond / 60;
                int rSecond = dSecond % 60;
                return (Serializable)(dHour >= 10 ? Integer.valueOf(dHour) : "0" + dHour) + ":" + (Serializable)(dMinute >= 10 ? Integer.valueOf(dMinute) : "0" + dMinute) + ":" + (Serializable)(rSecond >= 10 ? Integer.valueOf(rSecond) : "0" + rSecond);
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "secToTimeRetain", new Object[0]);
        }
        return null;
    }

    public static int[] convertTimeArys(int time) {
        try {
            if (time <= 0) {
                return new int[]{0, 0, 0};
            }
            if (time < 60) {
                return new int[]{0, 0, time};
            }
            if (time >= 60 && time < 3600) {
                int dSecond = time % 60;
                int dMinute = (time - dSecond) / 60;
                return new int[]{0, dMinute, dSecond};
            }
            if (time >= 3600 && time < 86400) {
                int rMinute = time % 3600;
                int dHour = (time - rMinute) / 3600;
                int dSecond = time - dHour * 3600;
                int dMinute = dSecond / 60;
                int rSecond = dSecond % 60;
                return new int[]{dHour, dMinute, rSecond};
            }
            int rMinute = time % 3600;
            int dHour = (time - rMinute) / 3600;
            int dSecond = time - dHour * 3600;
            int dMinute = dSecond / 60;
            int rSecond = dSecond % 60;
            return new int[]{dHour, dMinute, rSecond};
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "convertTimeArys", new Object[0]);
            return null;
        }
    }

    public static String millisToFitTimeSpan(long millis, int precision) {
        if (millis <= 0L || precision <= 0) {
            return null;
        }
        long millisTime = millis;
        int precisionFormat = precision;
        StringBuilder builder = new StringBuilder();
        String[] units = new String[]{"\u5929", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2", "\u6beb\u79d2"};
        int[] unitLen = new int[]{86400000, 3600000, 60000, 1000, 1};
        precisionFormat = Math.min(precisionFormat, 5);
        for (int i = 0; i < precisionFormat; ++i) {
            if (millisTime < (long)unitLen[i]) continue;
            long mode = millisTime / (long)unitLen[i];
            millisTime -= mode * (long)unitLen[i];
            builder.append(mode).append(units[i]);
        }
        return builder.toString();
    }

    public static int[] millisToTimeArys(long millis) {
        if (millis <= 0L) {
            return null;
        }
        int[] timeArys = new int[5];
        int[] unitLen = new int[]{86400000, 3600000, 60000, 1000, 1};
        long millisTime = millis;
        for (int i = 0; i < 5; ++i) {
            if (millisTime < (long)unitLen[i]) continue;
            long mode = millisTime / (long)unitLen[i];
            millisTime -= mode * (long)unitLen[i];
            timeArys[i] = (int)mode;
        }
        return timeArys;
    }

    public static boolean isInTimeHHmm(String startTime, String endTime) {
        return DateUtils.isInTime(DateUtils.formatTime(System.currentTimeMillis(), HHmm), startTime, endTime, HHmm);
    }

    public static boolean isInTimeHHmm(String nowTime, String startTime, String endTime) {
        return DateUtils.isInTime(nowTime, startTime, endTime, HHmm);
    }

    public static boolean isInTimeHHmmss(String startTime, String endTime) {
        return DateUtils.isInTime(DateUtils.formatTime(System.currentTimeMillis(), HHmmss), startTime, endTime, HHmmss);
    }

    public static boolean isInTimeHHmmss(String nowTime, String startTime, String endTime) {
        return DateUtils.isInTime(nowTime, startTime, endTime, HHmmss);
    }

    public static boolean isInTime(String nowTime, String startTime, String endTime, String format) {
        if (nowTime == null || startTime == null || endTime == null || format == null) {
            return false;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            long now = sdf.parse(nowTime).getTime();
            long start = sdf.parse(startTime).getTime();
            long end = sdf.parse(endTime).getTime();
            if (end < start ? now >= start || now <= end : now >= start && now <= end) {
                return true;
            }
            if (startTime.equals(endTime)) {
                return true;
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "isInTime", new Object[0]);
        }
        return false;
    }

    public static boolean isInTime(long nowTime, long startTime, long endTime) {
        return DateUtils.isInDate(new Date(nowTime), new Date(startTime), new Date(endTime));
    }

    public static boolean isInDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime == null || startTime == null || endTime == null) {
            return false;
        }
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        now.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return now.after(begin) && now.before(end);
    }

    public static long getEndTimeDiffHHmm(String endTime) {
        return DateUtils.getEndTimeDiff(System.currentTimeMillis(), endTime, HHmm);
    }

    public static long getEndTimeDiffHHmm(long startTime, String endTime) {
        return DateUtils.getEndTimeDiff(startTime, endTime, HHmm);
    }

    public static long getEndTimeDiff(String endTime, String format) {
        return DateUtils.getEndTimeDiff(System.currentTimeMillis(), endTime, format);
    }

    public static long getEndTimeDiff(long startTime, String endTime, String format) {
        if (startTime < 1L || endTime == null || format == null) {
            return -1L;
        }
        try {
            boolean isSecond = format.endsWith(":ss");
            String start = DateUtils.formatTime(startTime, format);
            int startNumber = Integer.parseInt(start.replace(":", ""));
            int endNumber = Integer.parseInt(endTime.replace(":", ""));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(startTime));
            if (startNumber > endNumber) {
                calendar.add(5, 1);
            }
            String yyyyMMddDate = DateUtils.formatDate(calendar.getTime(), yyyyMMdd);
            String yyyyMMddHHmmssDate = yyyyMMddDate + " " + endTime + (isSecond ? "" : ":00");
            return DateUtils.parseLong(yyyyMMddHHmmssDate, yyyyMMddHHmmss);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getEndTimeDiff", new Object[0]);
            return -1L;
        }
    }

    public static String getZodiac(int year) {
        return ZODIAC[Math.abs(year) % 12];
    }

    public static String getConstellation(int month, int day) {
        if (month > 12 || month < 1) {
            return null;
        }
        return CONSTELLATION[day >= CONSTELLATION_DAY[month - 1] ? month - 1 : (month + 10) % 12];
    }

    public static String getConstellationDate(int month, int day) {
        if (month > 12 || month < 1) {
            return null;
        }
        return CONSTELLATION_DATE[day >= CONSTELLATION_DAY[month - 1] ? month - 1 : (month + 10) % 12];
    }
}

