/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.ClassUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;

public final class FieldUtils {
    private static final String TAG = FieldUtils.class.getSimpleName();

    private FieldUtils() {
    }

    public static Field getField(Object object, String name) {
        return FieldUtils.getField(ClassUtils.getClass(object), name);
    }

    public static Field getField(Class clazz, String name) {
        if (clazz != null && name != null) {
            try {
                return clazz.getField(name);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getField", new Object[0]);
            }
        }
        return null;
    }

    public static Field getDeclaredField(Object object, String name) {
        return FieldUtils.getDeclaredField(ClassUtils.getClass(object), name);
    }

    public static Field getDeclaredField(Class clazz, String name) {
        if (clazz != null && name != null) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getDeclaredField", new Object[0]);
            }
        }
        return null;
    }

    public static Field[] getFields(Object object) {
        return FieldUtils.getFields(ClassUtils.getClass(object));
    }

    public static Field[] getFields(Class clazz) {
        if (clazz != null) {
            try {
                return clazz.getFields();
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getFields", new Object[0]);
            }
        }
        return null;
    }

    public static Field[] getDeclaredFields(Object object) {
        return FieldUtils.getDeclaredFields(ClassUtils.getClass(object));
    }

    public static Field[] getDeclaredFields(Class clazz) {
        if (clazz != null) {
            try {
                return clazz.getDeclaredFields();
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getDeclaredFields", new Object[0]);
            }
        }
        return null;
    }

    public static Object set(Field field, Object object, Object value) {
        if (field == null || object == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            field.set(object, value);
            return field.get(object);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "set", new Object[0]);
            return null;
        }
    }

    public static Object get(Field field, Object object) {
        if (field == null || object == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "get", new Object[0]);
            return null;
        }
    }

    public static boolean isLong(Field field) {
        return field != null && (field.getType() == Long.TYPE || field.getType() == Long.class);
    }

    public static boolean isFloat(Field field) {
        return field != null && (field.getType() == Float.TYPE || field.getType() == Float.class);
    }

    public static boolean isDouble(Field field) {
        return field != null && (field.getType() == Double.TYPE || field.getType() == Double.class);
    }

    public static boolean isInteger(Field field) {
        return field != null && (field.getType() == Integer.TYPE || field.getType() == Integer.class);
    }

    public static boolean isBoolean(Field field) {
        return field != null && (field.getType() == Boolean.TYPE || field.getType() == Boolean.class);
    }

    public static boolean isCharacter(Field field) {
        return field != null && (field.getType() == Character.TYPE || field.getType() == Character.class);
    }

    public static boolean isByte(Field field) {
        return field != null && (field.getType() == Byte.TYPE || field.getType() == Byte.class);
    }

    public static boolean isShort(Field field) {
        return field != null && (field.getType() == Short.TYPE || field.getType() == Short.class);
    }

    public static boolean isString(Field field) {
        return field != null && field.getType() == String.class;
    }

    public static boolean isSerializable(Field field) {
        if (field == null) {
            return false;
        }
        try {
            Class<?>[] clazzs;
            for (Class<?> clazz : clazzs = field.getType().getInterfaces()) {
                if (Serializable.class != clazz) continue;
                return true;
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "isSerializable", new Object[0]);
        }
        return false;
    }

    public static boolean isInvalid(Field field) {
        return FieldUtils.isStaticFinal(field) || FieldUtils.isSynthetic(field);
    }

    public static boolean isStatic(Field field) {
        return field != null && Modifier.isStatic(field.getModifiers());
    }

    public static boolean isFinal(Field field) {
        return field != null && Modifier.isFinal(field.getModifiers());
    }

    public static boolean isStaticFinal(Field field) {
        return field != null && Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers());
    }

    public static boolean isSynthetic(Field field) {
        return field != null && field.isSynthetic();
    }

    public static Class<?> getGenericType(Field field) {
        if (field == null) {
            return null;
        }
        try {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType ? (type = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class : type instanceof Class) {
                return (Class)type;
            }
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getGenericType", new Object[0]);
        }
        return null;
    }

    public static Class<?> getComponentType(Field field) {
        if (field == null || field.getType() == null) {
            return null;
        }
        return field.getType().getComponentType();
    }

    public static List<Field> getAllDeclaredFields(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            LinkedList<Field> fieldList = new LinkedList<Field>();
            for (Class<?> clazzTemp = clazz; clazzTemp != null && clazzTemp != Object.class; clazzTemp = clazzTemp.getSuperclass()) {
                Field[] fs = clazzTemp.getDeclaredFields();
                for (int i = 0; i < fs.length; ++i) {
                    Field f = fs[i];
                    if (FieldUtils.isInvalid(f)) continue;
                    fieldList.addLast(f);
                }
            }
            return fieldList;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getAllDeclaredFields", new Object[0]);
            return null;
        }
    }
}

