/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.ObjectUtils;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final String TAG = StringUtils.class.getSimpleName();
    public static final String SPACE_STR = " ";
    public static final String TAB_STR = "\t";
    public static final String NEW_LINE_STR = System.getProperty("line.separator");
    public static final String NEW_LINE_STR_X2 = NEW_LINE_STR + NEW_LINE_STR;
    public static final String NULL_STR = "null";

    private StringUtils() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(String str, boolean isTrim) {
        if (str != null) {
            return StringUtils.isEmpty(isTrim ? str.trim() : str);
        }
        return false;
    }

    public static boolean isEmpty(String ... strs) {
        if (strs != null && strs.length != 0) {
            int len = strs.length;
            for (int i = 0; i < len; ++i) {
                if (!StringUtils.isEmpty(strs[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() != 0;
    }

    public static boolean isNotEmpty(String str, boolean isTrim) {
        return StringUtils.isNotEmpty(isTrim ? str.trim() : str);
    }

    public static int length(String str) {
        return str == null ? 0 : str.length();
    }

    public static int length(String str, int defaultLength) {
        return str != null ? str.length() : defaultLength;
    }

    public static boolean isLength(String str, int length) {
        return str != null && str.length() == length;
    }

    public static <T> boolean equals(T value1, T value2) {
        return ObjectUtils.equals(value1, value2);
    }

    public static boolean isEquals(String ... strs) {
        return StringUtils.isEquals(false, strs);
    }

    public static boolean isEquals(boolean isIgnore, String ... strs) {
        if (strs != null) {
            String last = null;
            int len = strs.length;
            if (len <= 1) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                String value = strs[i];
                if (value == null) {
                    return false;
                }
                if (last != null && (isIgnore ? !value.equalsIgnoreCase(last) : !value.equals(last))) {
                    return false;
                }
                last = value;
            }
            return true;
        }
        return false;
    }

    public static boolean isOrEquals(String str, String ... strs) {
        return StringUtils.isOrEquals(false, str, strs);
    }

    public static boolean isOrEquals(boolean isIgnore, String str, String ... strs) {
        if (str != null && strs != null && strs.length != 0) {
            for (String value : strs) {
                if (value == null || !(isIgnore ? value.equalsIgnoreCase(str) : value.equals(str))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isContains(String str, String ... strs) {
        return StringUtils.isContains(false, str, strs);
    }

    public static boolean isContains(boolean isIgnore, String str, String ... strs) {
        if (str != null && strs != null && strs.length != 0) {
            String tempString = str;
            if (isIgnore) {
                tempString = tempString.toLowerCase();
            }
            int strLength = tempString.length();
            for (String value : strs) {
                String valIgnore;
                if (!(!StringUtils.isEmpty(value) && strLength != 0 ? (isIgnore ? (valIgnore = value.toLowerCase()).indexOf(tempString) != -1 : value.indexOf(tempString) != -1) : tempString.equals(value))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isStartsWith(String str, String ... strs) {
        return StringUtils.isStartsWith(false, str, strs);
    }

    public static boolean isStartsWith(boolean isIgnore, String str, String ... strs) {
        if (!StringUtils.isEmpty(str) && strs != null && strs.length != 0) {
            String tempString = str;
            if (isIgnore) {
                tempString = tempString.toLowerCase();
            }
            for (String value : strs) {
                String valIgnore;
                if (StringUtils.isEmpty(value) || !(isIgnore ? tempString.startsWith(valIgnore = value.toLowerCase()) : tempString.startsWith(value))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEndsWith(String str, String ... strs) {
        return StringUtils.isEndsWith(false, str, strs);
    }

    public static boolean isEndsWith(boolean isIgnore, String str, String ... strs) {
        if (!StringUtils.isEmpty(str) && strs != null && strs.length != 0) {
            String tempString = str;
            if (isIgnore) {
                tempString = tempString.toLowerCase();
            }
            for (String value : strs) {
                String valIgnore;
                if (StringUtils.isEmpty(value) || !(isIgnore ? tempString.endsWith(valIgnore = value.toLowerCase()) : tempString.endsWith(value))) continue;
                return true;
            }
        }
        return false;
    }

    public static int countMatches(String str, String keyword) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(keyword)) {
            return 0;
        }
        try {
            int count = 0;
            Matcher matcher = Pattern.compile(keyword).matcher(str);
            while (matcher.find()) {
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "countMatches", new Object[0]);
            return -1;
        }
    }

    public static int countMatches2(String str, String keyword) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(keyword)) {
            return 0;
        }
        try {
            int keyLength = keyword.length();
            int count = 0;
            int index = 0;
            while ((index = str.indexOf(keyword, index)) != -1) {
                index += keyLength;
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "countMatches2", new Object[0]);
            return -1;
        }
    }

    public static boolean isSpace(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytes(String str) {
        return str != null ? str.getBytes() : null;
    }

    public static String clearSpace(String str) {
        return StringUtils.replaceAll(str, SPACE_STR, "");
    }

    public static String clearTab(String str) {
        return StringUtils.replaceAll(str, TAB_STR, "");
    }

    public static String clearLine(String str) {
        return StringUtils.replaceAll(str, NEW_LINE_STR, "");
    }

    public static String clearSpaceTrim(String str) {
        return StringUtils.clearSEWiths(str, SPACE_STR);
    }

    public static String clearTabTrim(String str) {
        return StringUtils.clearSEWiths(str, TAB_STR);
    }

    public static String clearLineTrim(String str) {
        return StringUtils.clearSEWiths(str, NEW_LINE_STR);
    }

    public static String clearSpaceTabLine(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        String value = StringUtils.clearSpace(str);
        value = StringUtils.clearTab(value);
        value = StringUtils.clearLine(value);
        return value;
    }

    public static String clearSpaceTabLineTrim(String str) {
        boolean line;
        boolean tab;
        boolean space;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        String value = str;
        do {
            boolean bl = space = value.startsWith(SPACE_STR) || value.endsWith(SPACE_STR);
            if (space) {
                value = StringUtils.clearSpaceTrim(value);
            }
            boolean bl2 = tab = value.startsWith(TAB_STR) || value.endsWith(TAB_STR);
            if (tab) {
                value = StringUtils.clearTabTrim(value);
            }
            boolean bl3 = line = value.startsWith(NEW_LINE_STR) || value.endsWith(NEW_LINE_STR);
            if (!line) continue;
            value = StringUtils.clearLineTrim(value);
        } while (space || tab || line);
        return value;
    }

    public static String appendSpace(int number) {
        return StringUtils.forString(number, SPACE_STR);
    }

    public static String appendTab(int number) {
        return StringUtils.forString(number, TAB_STR);
    }

    public static String appendLine(int number) {
        return StringUtils.forString(number, NEW_LINE_STR);
    }

    public static String forString(int number, String str) {
        StringBuilder builder = new StringBuilder();
        if (number > 0) {
            for (int i = 0; i < number; ++i) {
                builder.append(str);
            }
        }
        return builder.toString();
    }

    public static String forJoint(Object joint, Object ... values) {
        int length;
        if (values != null && (length = values.length) != 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(values[0]);
            for (int i = 1; i < length; ++i) {
                builder.append(joint).append(values[i]);
            }
            return builder.toString();
        }
        return null;
    }

    public static String colonSplit(String str) {
        if (!StringUtils.isEmpty(str)) {
            return str.replaceAll("(?<=[0-9A-F]{2})[0-9A-F]{2}", ":$0");
        }
        return str;
    }

    public static String getString(String str) {
        return StringUtils.getString(str, NULL_STR);
    }

    public static String getString(String str, String defaultStr) {
        return str != null ? str : defaultStr;
    }

    public static String getString(Object object) {
        return StringUtils.getString(object, NULL_STR);
    }

    public static String getString(Object object, String defaultStr) {
        return object != null ? object.toString() : defaultStr;
    }

    public static String checkValue(String str) {
        return StringUtils.checkValue("", str);
    }

    public static String checkValue(String defaultStr, String str) {
        return StringUtils.isEmpty(str) ? defaultStr : str;
    }

    public static String checkValue(String defaultStr, String value1, String value2) {
        if (StringUtils.isEmpty(value1)) {
            if (StringUtils.isEmpty(value2)) {
                return defaultStr;
            }
            return value2;
        }
        return value1;
    }

    public static String checkValues(String defaultStr, String ... strs) {
        if (strs != null && strs.length != 0) {
            for (String value : strs) {
                if (StringUtils.isEmpty(value)) continue;
                return value;
            }
        }
        return defaultStr;
    }

    public static String checkValuesSpace(String defaultStr, String ... strs) {
        if (strs != null && strs.length != 0) {
            int len = strs.length;
            for (int i = 0; i < len; ++i) {
                String value = StringUtils.clearSpaceTrim(strs[i]);
                if (StringUtils.isEmpty(value)) continue;
                return value;
            }
        }
        return defaultStr;
    }

    public static String getFormatString(String format, Object ... args) {
        if (format == null) {
            return null;
        }
        try {
            if (args != null && args.length != 0) {
                return String.format(format, args);
            }
            return format;
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "getFormatString", new Object[0]);
            return null;
        }
    }

    public static String getAutoFormatString(Object ... args) {
        if (args != null && args.length != 0) {
            try {
                int length = args.length;
                StringBuilder builder = new StringBuilder();
                builder.append("%s");
                if (length > 1) {
                    for (int i = 1; i < length; ++i) {
                        builder.append(" %s");
                    }
                }
                return String.format(builder.toString(), args);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getAutoFormatString", new Object[0]);
            }
        }
        return null;
    }

    public static String getAutoFormatString2(Object ... args) {
        if (args != null && args.length != 0) {
            try {
                int length = args.length;
                StringBuilder builder = new StringBuilder();
                builder.append("[%s]");
                if (length > 1) {
                    for (int i = 1; i < length; ++i) {
                        builder.append(" %s");
                    }
                }
                return String.format(builder.toString(), args);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getAutoFormatString2", new Object[0]);
            }
        }
        return null;
    }

    public static String concat(Object ... args) {
        return StringUtils.concatSpiltWith("", args);
    }

    public static String concatSpiltWith(String split, Object ... args) {
        if (args == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isEmpty(split)) {
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                builder.append(args[i]);
            }
        } else {
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                builder.append(args[i]).append(split);
            }
        }
        return builder.toString();
    }

    public static String concatSpiltWithIgnoreLast(String split, Object ... args) {
        if (args == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int len = args.length;
        if (len > 0) {
            if (StringUtils.isEmpty(split)) {
                for (int i = 0; i < len; ++i) {
                    builder.append(args[i]);
                }
            } else {
                for (int i = 0; i < len - 1; ++i) {
                    builder.append(args[i]).append(split);
                }
                builder.append(args[len - 1]);
            }
        }
        return builder.toString();
    }

    public static StringBuilder appends(StringBuilder builder, String split, Object ... args) {
        block4: {
            if (builder == null || args == null) break block4;
            if (StringUtils.isEmpty(split)) {
                int len = args.length;
                for (int i = 0; i < len; ++i) {
                    builder.append(args[i]);
                }
            } else {
                int len = args.length;
                for (int i = 0; i < len; ++i) {
                    builder.append(args[i]).append(split);
                }
            }
        }
        return builder;
    }

    public static StringBuilder appendsIgnoreLast(StringBuilder builder, String split, Object ... args) {
        int len;
        if (builder != null && args != null && (len = args.length) > 0) {
            if (StringUtils.isEmpty(split)) {
                for (int i = 0; i < len; ++i) {
                    builder.append(args[i]);
                }
            } else {
                for (int i = 0; i < len - 1; ++i) {
                    builder.append(args[i]).append(split);
                }
                builder.append(args[len - 1]);
            }
        }
        return builder;
    }

    public static String gbkEncode(String str) {
        return StringUtils.strEncode(str, "GBK");
    }

    public static String gbk2312Encode(String str) {
        return StringUtils.strEncode(str, "GBK-2312");
    }

    public static String utf8Encode(String str) {
        return StringUtils.strEncode(str, "UTF-8");
    }

    public static String strEncode(String str, String enc) {
        if (str == null || enc == null) {
            return null;
        }
        try {
            return new String(str.getBytes(), enc);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "strEncode", new Object[0]);
            return str;
        }
    }

    public static String urlEncode(String str) {
        return StringUtils.urlEncode(str, "UTF-8");
    }

    public static String urlEncode(String str, String enc) {
        if (str == null || enc == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, enc);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "urlEncode", new Object[0]);
            return null;
        }
    }

    public static String urlDecode(String str) {
        return StringUtils.urlDecode(str, "UTF-8");
    }

    public static String urlDecode(String str, String enc) {
        if (str == null || enc == null) {
            return null;
        }
        try {
            return URLDecoder.decode(str, enc);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "urlDecode", new Object[0]);
            return null;
        }
    }

    public static String ascii(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        try {
            StringBuilder builder = new StringBuilder();
            byte[] bytes = str.getBytes();
            int len = bytes.length;
            for (int i = 0; i < len; ++i) {
                builder.append(Integer.toHexString(bytes[i] & 0xFF));
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "ascii", new Object[0]);
            return null;
        }
    }

    public static String unicode(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        try {
            StringBuilder builder = new StringBuilder();
            char[] chars = str.toCharArray();
            int len = chars.length;
            for (int i = 0; i < len; ++i) {
                builder.append("\\u").append(Integer.toHexString(chars[i]));
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "unicode", new Object[0]);
            return null;
        }
    }

    public static String unicodeString(char[] chars) {
        if (chars == null) {
            return null;
        }
        try {
            StringBuilder builder = new StringBuilder();
            int len = chars.length;
            for (int i = 0; i < len; ++i) {
                builder.append("\\u").append(Integer.toHexString(chars[i]));
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "unicodeString", new Object[0]);
            return null;
        }
    }

    public static String dbc(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            chars[i] = chars[i] == '\u3000' ? 32 : ('\uff01' <= chars[i] && chars[i] <= '\uff5e' ? (char)(chars[i] - 65248) : chars[i]);
        }
        return new String(chars);
    }

    public static String sbc(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            chars[i] = chars[i] == ' ' ? 12288 : ('!' <= chars[i] && chars[i] <= '~' ? (char)(chars[i] + 65248) : chars[i]);
        }
        return new String(chars);
    }

    public static boolean checkChineseToString(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        boolean result = true;
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (StringUtils.isChinese(chars[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isChinese(char ch) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(ch);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String upperFirstLetter(String str) {
        if (StringUtils.isEmpty(str) || !Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        try {
            return (char)(str.charAt(0) - 32) + str.substring(1);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "upperFirstLetter", new Object[0]);
            return str;
        }
    }

    public static String lowerFirstLetter(String str) {
        if (StringUtils.isEmpty(str) || !Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        try {
            return (char)(str.charAt(0) + 32) + str.substring(1);
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "lowerFirstLetter", new Object[0]);
            return str;
        }
    }

    public static String reverse(String str) {
        int len = StringUtils.length(str);
        if (len <= 1) {
            return str;
        }
        int mid = len >> 1;
        char[] chars = str.toCharArray();
        for (int i = 0; i < mid; ++i) {
            char ch = chars[i];
            chars[i] = chars[len - i - 1];
            chars[len - i - 1] = ch;
        }
        return new String(chars);
    }

    public static String underScoreCaseToCamelCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (!str.contains("_")) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        char[] chars = str.toCharArray();
        boolean hitUnderScore = false;
        builder.append(chars[0]);
        int len = chars.length;
        for (int i = 1; i < len; ++i) {
            char c = chars[i];
            if (c == '_') {
                hitUnderScore = true;
                continue;
            }
            if (hitUnderScore) {
                builder.append(Character.toUpperCase(c));
                hitUnderScore = false;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String camelCaseToUnderScoreCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (Character.isUpperCase(c)) {
                builder.append("_").append(Character.toLowerCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String sqliteEscape(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        String keyWord = str;
        keyWord = keyWord.replace("/", "//");
        keyWord = keyWord.replace("'", "''");
        keyWord = keyWord.replace("[", "/[");
        keyWord = keyWord.replace("]", "/]");
        keyWord = keyWord.replace("%", "/%");
        keyWord = keyWord.replace("&", "/&");
        keyWord = keyWord.replace("_", "/_");
        keyWord = keyWord.replace("(", "/(");
        keyWord = keyWord.replace(")", "/)");
        return keyWord;
    }

    public static String convertHideMobile(String phone) {
        return StringUtils.convertHideMobile(phone, "*");
    }

    public static String convertHideMobile(String phone, String symbol) {
        return StringUtils.convertSymbolHide(3, phone, symbol);
    }

    public static String convertSymbolHide(int start, String str, String symbol) {
        if (!StringUtils.isEmpty(str)) {
            if (start <= 0) {
                return str;
            }
            int length = str.length();
            if (length <= start) {
                return str;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(str.substring(0, start));
            int len = length - start;
            len /= 2;
            for (int i = 0; i < len; ++i) {
                builder.append(symbol);
            }
            builder.append(str.substring(start + len, length));
            return builder.toString();
        }
        return "";
    }

    public static String subEllipsize(int maxLength, String str, String symbol) {
        int strLength;
        if (maxLength >= 1 && (strLength = StringUtils.length(str)) != 0) {
            if (maxLength >= strLength) {
                return str;
            }
            return str.substring(0, maxLength) + StringUtils.checkValue(symbol);
        }
        return "";
    }

    public static String subSymbolHide(int start, int symbolNumber, String str, String symbol) {
        if (!StringUtils.isEmpty(str)) {
            if (start <= 0 || symbolNumber <= 0) {
                return str;
            }
            int length = str.length();
            if (length <= start) {
                return str;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(str.substring(0, start));
            int len = length - start - symbolNumber;
            len = len <= 0 ? length - start : symbolNumber;
            for (int i = 0; i < len; ++i) {
                builder.append(symbol);
            }
            builder.append(str.substring(start + len, length));
            return builder.toString();
        }
        return "";
    }

    public static String subSetSymbol(String str, int frontRetainLength, int rearRetainLength, String symbol) {
        if (str != null) {
            try {
                String startStr = str.substring(0, frontRetainLength);
                String endStr = str.substring(str.length() - rearRetainLength);
                int symbolLength = str.length() - (frontRetainLength + rearRetainLength);
                if (symbolLength >= 1) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < symbolLength; ++i) {
                        builder.append(symbol);
                    }
                    return startStr + builder.toString() + endStr;
                }
                return startStr + endStr;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "subSetSymbol", new Object[0]);
            }
        }
        return null;
    }

    public static String substring(String str, int endIndex) {
        return StringUtils.substring(str, 0, endIndex, true);
    }

    public static String substring(String str, int endIndex, boolean isReturn) {
        return StringUtils.substring(str, 0, endIndex, isReturn);
    }

    public static String substring(String str, int beginIndex, int endIndex, boolean isReturn) {
        if (!StringUtils.isEmpty(str) && beginIndex >= 0 && endIndex >= 0 && endIndex >= beginIndex) {
            int len = StringUtils.length(str);
            if (beginIndex > len) {
                return isReturn ? str : "";
            }
            return str.substring(beginIndex, endIndex >= len ? len : endIndex);
        }
        return isReturn ? str : "";
    }

    public static String replaceSEWith(String str, String suffix) {
        return StringUtils.replaceSEWith(str, suffix, "");
    }

    public static String replaceSEWith(String str, String suffix, String replace) {
        try {
            if (StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix) || replace == null || suffix.equals(replace)) {
                return str;
            }
            int suffixLength = suffix.length();
            StringBuilder builder = new StringBuilder(str);
            if (builder.indexOf(suffix) == 0) {
                builder.delete(0, suffixLength);
                builder.insert(0, replace);
            }
            int lastIndexOf = builder.lastIndexOf(suffix);
            int bufLength = builder.length();
            if (lastIndexOf != -1 && lastIndexOf == bufLength - suffixLength) {
                builder.delete(lastIndexOf, bufLength);
                builder.insert(lastIndexOf, replace);
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "replaceSEWith", new Object[0]);
            return str;
        }
    }

    public static String replaceStartsWith(String str, String prefix) {
        return StringUtils.replaceStartsWith(str, prefix, "");
    }

    public static String replaceStartsWith(String str, String prefix, String startAppend) {
        if (!StringUtils.isEmpty(str) && !StringUtils.isEmpty(prefix)) {
            try {
                if (str.startsWith(prefix)) {
                    return StringUtils.checkValue(startAppend) + str.substring(prefix.length());
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "replaceStartsWith", new Object[0]);
            }
        }
        return str;
    }

    public static String replaceEndsWith(String str, String suffix) {
        return StringUtils.replaceEndsWith(str, suffix, "");
    }

    public static String replaceEndsWith(String str, String suffix, String replace) {
        if (!StringUtils.isEmpty(str) && !StringUtils.isEmpty(suffix)) {
            try {
                if (str.endsWith(suffix)) {
                    return str.substring(0, str.length() - suffix.length()) + replace;
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "replaceEndsWith", new Object[0]);
            }
        }
        return str;
    }

    public static String clearSEWiths(String str, String suffix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix)) {
            return str;
        }
        try {
            int suffixLength = suffix.length();
            StringBuilder builder = new StringBuilder(str);
            while (builder.indexOf(suffix) == 0) {
                builder.delete(0, suffixLength);
            }
            int lastIndexOf = builder.lastIndexOf(suffix);
            int bufLength = builder.length();
            while (lastIndexOf != -1 && lastIndexOf == bufLength - suffixLength) {
                builder.delete(lastIndexOf, bufLength);
                lastIndexOf = builder.lastIndexOf(suffix);
                bufLength = builder.length();
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "clearSEWiths", new Object[0]);
            return str;
        }
    }

    public static String clearStartsWith(String str, String suffix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix)) {
            return str;
        }
        try {
            int suffixLength = suffix.length();
            StringBuilder builder = new StringBuilder(str);
            while (builder.indexOf(suffix) == 0) {
                builder.delete(0, suffixLength);
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "clearStartsWith", new Object[0]);
            return str;
        }
    }

    public static String clearEndsWith(String str, String suffix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix)) {
            return str;
        }
        try {
            int suffixLength = suffix.length();
            StringBuilder builder = new StringBuilder(str);
            int lastIndexOf = builder.lastIndexOf(suffix);
            int bufLength = builder.length();
            while (lastIndexOf != -1 && lastIndexOf == bufLength - suffixLength) {
                builder.delete(lastIndexOf, bufLength);
                lastIndexOf = builder.lastIndexOf(suffix);
                bufLength = builder.length();
            }
            return builder.toString();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "clearEndsWith", new Object[0]);
            return str;
        }
    }

    public static String replaceAll(String str, String suffix, String replace) {
        if (!(StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix) || replace == null || suffix.equals(replace))) {
            try {
                return str.replaceAll(suffix, replace);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "replaceAll", new Object[0]);
            }
        }
        return str;
    }

    public static String replaceAllToNull(String str, String suffix, String replace) {
        if (!(StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix) || replace == null || suffix.equals(replace))) {
            try {
                return str.replaceAll(suffix, replace);
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "replaceAllToNull", new Object[0]);
            }
        }
        return null;
    }

    public static String replaceAlls(String str, String[] suffixArys, String[] replaceArys) {
        if (str != null && suffixArys != null && replaceArys != null) {
            String tempString = str;
            int spCount = suffixArys.length;
            int reCount = replaceArys.length;
            if (spCount == reCount) {
                for (int i = 0; i < spCount; ++i) {
                    tempString = StringUtils.replaceAll(tempString, suffixArys[i], replaceArys[i]);
                }
                return tempString;
            }
        }
        return null;
    }

    public static String[] split(String str, String regex) {
        if (!StringUtils.isEmpty(str) && !StringUtils.isEmpty(regex)) {
            return str.split(regex);
        }
        return null;
    }

    public static String split(String str, String regex, int index) {
        return StringUtils.split(str, regex, index, null);
    }

    public static String split(String str, String regex, int index, String defaultStr) {
        String[] arrays;
        if (index >= 0 && (arrays = StringUtils.split(str, regex)) != null && arrays.length > index) {
            return arrays[index];
        }
        return defaultStr;
    }
}

