/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.DevFinal;
import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import dev.utils.common.FileIOUtils;
import dev.utils.common.StringUtils;
import dev.utils.common.encrypt.MD5Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public final class FileUtils {
    private static final String TAG = FileUtils.class.getSimpleName();
    private static final String[] IMAGE_FORMATS = new String[]{".PNG", ".JPG", ".JPEG", ".BMP", ".GIF", ".WEBP"};
    private static final String[] AUDIO_FORMATS = new String[]{".MP3", ".AAC", ".OGG", ".WMA", ".APE", ".FLAC", ".RA"};
    private static final String[] VIDEO_FORMATS = new String[]{".MP4", ".AVI", ".MOV", ".ASF", ".MPG", ".MPEG", ".WMV", ".RM", ".RMVB", ".3GP", ".MKV"};

    private FileUtils() {
    }

    public static File getFile(String filePath) {
        return FileUtils.getFileByPath(filePath);
    }

    public static File getFile(String filePath, String fileName) {
        return filePath != null && fileName != null ? new File(filePath, fileName) : null;
    }

    public static File getFileByPath(String filePath) {
        return filePath != null ? new File(filePath) : null;
    }

    public static File getFileCreateFolder(String filePath, String fileName) {
        FileUtils.createFolder(filePath);
        return FileUtils.getFile(filePath, fileName);
    }

    public static String getFilePathCreateFolder(String filePath, String fileName) {
        FileUtils.createFolder(filePath);
        File file = FileUtils.getFile(filePath, fileName);
        return FileUtils.getAbsolutePath(file);
    }

    public static boolean createFolder(String dirPath) {
        return FileUtils.createFolder(FileUtils.getFileByPath(dirPath));
    }

    public static boolean createFolder(File file) {
        if (file != null) {
            try {
                if (!file.exists()) {
                    return file.mkdirs();
                }
                return true;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "createFolder", new Object[0]);
            }
        }
        return false;
    }

    public static boolean createFolderByPath(String filePath) {
        return FileUtils.createFolderByPath(FileUtils.getFileByPath(filePath));
    }

    public static boolean createFolderByPath(File file) {
        if (file != null) {
            if (file.exists()) {
                return true;
            }
            if (!file.getParentFile().mkdirs()) {
                return FileUtils.createFolder(file.getParent());
            }
        }
        return false;
    }

    public static boolean createFolderByPaths(String ... filePaths) {
        if (filePaths != null && filePaths.length != 0) {
            int len = filePaths.length;
            for (int i = 0; i < len; ++i) {
                FileUtils.createFolder(filePaths[i]);
            }
            return true;
        }
        return false;
    }

    public static boolean createFolderByPaths(File ... files) {
        if (files != null && files.length != 0) {
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                FileUtils.createFolder(files[i]);
            }
            return true;
        }
        return false;
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtils.createOrExistsDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) {
        return FileUtils.createOrExistsFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (Exception e) {
            JCLogUtils.eTag(TAG, e, "createOrExistsFile", new Object[0]);
            return false;
        }
    }

    public static boolean createFileByDeleteOldFile(String filePath) {
        return FileUtils.createFileByDeleteOldFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && !file.delete()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            JCLogUtils.eTag(TAG, e, "createFileByDeleteOldFile", new Object[0]);
            return false;
        }
    }

    public static List<File> convertFiles(List<String> paths) {
        return FileUtils.convertFiles(paths, true);
    }

    public static List<File> convertFiles(List<String> paths, boolean ignore) {
        ArrayList<File> files = new ArrayList<File>();
        if (paths != null && !paths.isEmpty()) {
            int len = paths.size();
            for (int i = 0; i < len; ++i) {
                String path = paths.get(i);
                if (path == null) {
                    if (ignore) continue;
                    files.add(null);
                    continue;
                }
                files.add(new File(path));
            }
        }
        return files;
    }

    public static List<String> convertPaths(List<File> files) {
        return FileUtils.convertPaths(files, true);
    }

    public static List<String> convertPaths(List<File> files, boolean ignore) {
        ArrayList<String> paths = new ArrayList<String>();
        if (files != null && !files.isEmpty()) {
            int len = files.size();
            for (int i = 0; i < len; ++i) {
                File file = files.get(i);
                if (file == null) {
                    if (ignore) continue;
                    paths.add(null);
                    continue;
                }
                paths.add(file.getAbsolutePath());
            }
        }
        return paths;
    }

    public static String getPath(File file) {
        return file != null ? file.getPath() : null;
    }

    public static String getAbsolutePath(File file) {
        return file != null ? file.getAbsolutePath() : null;
    }

    public static String getName(File file) {
        return file != null ? file.getName() : null;
    }

    public static String getName(String filePath) {
        return FileUtils.getName(filePath, "");
    }

    public static String getName(String filePath, String defaultStr) {
        return StringUtils.isSpace(filePath) ? defaultStr : new File(filePath).getName();
    }

    public static String getFileSuffix(File file) {
        return FileUtils.getFileSuffix(FileUtils.getAbsolutePath(file));
    }

    public static String getFileSuffix(String filePath) {
        int lastIndexOf;
        if (filePath != null && (lastIndexOf = filePath.lastIndexOf(46)) != -1) {
            String result = filePath.substring(lastIndexOf);
            if (result.startsWith(".")) {
                return result.substring(1);
            }
            return result;
        }
        return null;
    }

    public static String getFileNotSuffix(File file) {
        return FileUtils.getFileNotSuffix(FileUtils.getName(file));
    }

    public static String getFileNotSuffixToPath(String filePath) {
        return FileUtils.getFileNotSuffix(FileUtils.getName(filePath));
    }

    public static String getFileNotSuffix(String fileName) {
        if (fileName != null) {
            if (fileName.lastIndexOf(46) != -1) {
                return fileName.substring(0, fileName.lastIndexOf(46));
            }
            return fileName;
        }
        return null;
    }

    public static String getFileNameNoExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileNameNoExtension(file.getPath());
    }

    public static String getFileNameNoExtension(String filePath) {
        if (StringUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastSep == -1) {
            return lastPoi == -1 ? filePath : filePath.substring(0, lastPoi);
        }
        if (lastPoi == -1 || lastSep > lastPoi) {
            return filePath.substring(lastSep + 1);
        }
        return filePath.substring(lastSep + 1, lastPoi);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileExtension(file.getPath());
    }

    public static String getFileExtension(String filePath) {
        if (StringUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastPoi == -1 || lastSep >= lastPoi) {
            return "";
        }
        return filePath.substring(lastPoi + 1);
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean isFileExists(String filePath) {
        return FileUtils.isFileExists(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFileExists(String filePath, String fileName) {
        return filePath != null && fileName != null && new File(filePath, fileName).exists();
    }

    public static boolean isFile(String filePath) {
        return FileUtils.isFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static boolean isDirectory(String filePath) {
        return FileUtils.isDirectory(FileUtils.getFileByPath(filePath));
    }

    public static boolean isDirectory(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    public static boolean isHidden(String filePath) {
        return FileUtils.isHidden(FileUtils.getFileByPath(filePath));
    }

    public static boolean isHidden(File file) {
        return file != null && file.exists() && file.isHidden();
    }

    public static boolean canRead(String filePath) {
        return FileUtils.canRead(FileUtils.getFileByPath(filePath));
    }

    public static boolean canRead(File file) {
        return file != null && file.exists() && file.canRead();
    }

    public static boolean canWrite(String filePath) {
        return FileUtils.canWrite(FileUtils.getFileByPath(filePath));
    }

    public static boolean canWrite(File file) {
        return file != null && file.exists() && file.canWrite();
    }

    public static boolean canReadWrite(String filePath) {
        return FileUtils.canReadWrite(FileUtils.getFileByPath(filePath));
    }

    public static boolean canReadWrite(File file) {
        return file != null && file.exists() && file.canRead() && file.canWrite();
    }

    public static long getFileLastModified(String filePath) {
        return FileUtils.getFileLastModified(FileUtils.getFileByPath(filePath));
    }

    public static long getFileLastModified(File file) {
        if (file == null) {
            return 0L;
        }
        return file.lastModified();
    }

    public static String getFileCharsetSimple(String filePath) {
        return FileUtils.getFileCharsetSimple(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharsetSimple(File file) {
        if (!FileUtils.isFileExists(file)) {
            return null;
        }
        int pos = 0;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            pos = (((InputStream)is).read() << 8) + ((InputStream)is).read();
        }
        catch (IOException e) {
            try {
                JCLogUtils.eTag(TAG, e, "getFileCharsetSimple", new Object[0]);
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(is);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(is);
        }
        CloseUtils.closeIOQuietly(is);
        switch (pos) {
            case 61371: {
                return "UTF-8";
            }
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public static int getFileLines(String filePath) {
        return FileUtils.getFileLines(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileLines(File file) {
        if (!FileUtils.isFileExists(file)) {
            return 0;
        }
        int lineCount = 1;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            if (DevFinal.NEW_LINE_STR.endsWith("\n")) {
                int readChars;
                while ((readChars = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
                    for (int i = 0; i < readChars; ++i) {
                        if (buffer[i] != 10) continue;
                        ++lineCount;
                    }
                }
            } else {
                int readChars;
                while ((readChars = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
                    for (int i = 0; i < readChars; ++i) {
                        if (buffer[i] != 13) continue;
                        ++lineCount;
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                JCLogUtils.eTag(TAG, e, "getFileLines", new Object[0]);
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(is);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(is);
        }
        CloseUtils.closeIOQuietly(is);
        return lineCount;
    }

    public static String getFileSize(String filePath) {
        return FileUtils.getFileSize(FileUtils.getFileByPath(filePath));
    }

    public static String getFileSize(File file) {
        return FileUtils.formatByteMemorySize(FileUtils.getFileLength(file));
    }

    public static String getDirSize(String dirPath) {
        return FileUtils.getDirSize(FileUtils.getFileByPath(dirPath));
    }

    public static String getDirSize(File dir) {
        return FileUtils.formatByteMemorySize(FileUtils.getDirLength(dir));
    }

    public static long getFileLength(String filePath) {
        return FileUtils.getFileLength(FileUtils.getFileByPath(filePath));
    }

    public static long getFileLength(File file) {
        return file != null ? file.length() : 0L;
    }

    public static long getDirLength(String dirPath) {
        return FileUtils.getDirLength(FileUtils.getFileByPath(dirPath));
    }

    public static long getDirLength(File dir) {
        if (!FileUtils.isDirectory(dir)) {
            return 0L;
        }
        long len = 0L;
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    len += FileUtils.getDirLength(file);
                    continue;
                }
                len += file.length();
            }
        }
        return len;
    }

    public static long getFileLengthNetwork(String httpUri) {
        boolean isHttpRes;
        if (StringUtils.isSpace(httpUri)) {
            return 0L;
        }
        boolean bl = isHttpRes = httpUri.toLowerCase().startsWith("http:") || httpUri.toLowerCase().startsWith("https:");
        if (isHttpRes) {
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL(httpUri).openConnection();
                conn.setRequestProperty("Accept-Encoding", "identity");
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    return conn.getContentLength();
                }
                return 0L;
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "getFileLengthNetwork", new Object[0]);
            }
        }
        return 0L;
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileName(file.getPath());
    }

    public static String getFileName(String filePath) {
        if (StringUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? filePath : filePath.substring(lastSep + 1);
    }

    public static String getDirName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getDirName(file.getPath());
    }

    public static String getDirName(String filePath) {
        if (StringUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? "" : filePath.substring(0, lastSep + 1);
    }

    public static boolean rename(String filePath, String newFileName) {
        return FileUtils.rename(FileUtils.getFileByPath(filePath), newFileName);
    }

    public static boolean rename(File file, String newFileName) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (newFileName.equals(file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newFileName);
        return !newFile.exists() && file.renameTo(newFile);
    }

    public static String formatFileSize(String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        return FileUtils.formatFileSize(file != null ? (double)file.length() : 0.0);
    }

    public static String formatFileSize(File file) {
        return FileUtils.formatFileSize(file != null ? (double)file.length() : 0.0);
    }

    public static String formatFileSize(double fileSize) {
        DecimalFormat df = new DecimalFormat("#.00");
        Object fileSizeStr = fileSize <= 0.0 ? "0B" : (fileSize < 1024.0 ? df.format(fileSize) + "B" : (fileSize < 1048576.0 ? df.format(fileSize / 1024.0) + "KB" : (fileSize < 1.073741824E9 ? df.format(fileSize / 1048576.0) + "MB" : (fileSize < 1.099511627776E12 ? df.format(fileSize / 1.073741824E9) + "GB" : df.format(fileSize / 1.099511627776E12) + "TB"))));
        return fileSizeStr;
    }

    public static String formatByteMemorySize(double byteSize) {
        return FileUtils.formatByteMemorySize(3, byteSize);
    }

    public static String formatByteMemorySize(int number, double byteSize) {
        if (byteSize < 0.0) {
            return "0B";
        }
        if (byteSize < 1024.0) {
            return String.format("%." + number + "fB", byteSize);
        }
        if (byteSize < 1048576.0) {
            return String.format("%." + number + "fKB", byteSize / 1024.0);
        }
        if (byteSize < 1.073741824E9) {
            return String.format("%." + number + "fMB", byteSize / 1048576.0);
        }
        if (byteSize < 1.099511627776E12) {
            return String.format("%." + number + "fGB", byteSize / 1.073741824E9);
        }
        return String.format("%." + number + "fTB", byteSize / 1.099511627776E12);
    }

    public static boolean deleteFile(String filePath) {
        return FileUtils.deleteFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean deleteFile(File file) {
        if (file != null && file.exists() && !file.isDirectory()) {
            return file.delete();
        }
        return false;
    }

    public static boolean deleteFiles(String ... filePaths) {
        if (filePaths != null && filePaths.length != 0) {
            int len = filePaths.length;
            for (int i = 0; i < len; ++i) {
                FileUtils.deleteFile(filePaths[i]);
            }
            return true;
        }
        return false;
    }

    public static boolean deleteFiles(File ... files) {
        if (files != null && files.length != 0) {
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                FileUtils.deleteFile(files[i]);
            }
            return true;
        }
        return false;
    }

    public static boolean deleteFolder(String filePath) {
        return FileUtils.deleteFolder(FileUtils.getFileByPath(filePath));
    }

    public static boolean deleteFolder(File file) {
        if (file != null) {
            try {
                if (file.exists()) {
                    if (file.isDirectory()) {
                        File[] files = file.listFiles();
                        if (null == files || files.length == 0) {
                            file.delete();
                        }
                        for (File f : files) {
                            FileUtils.deleteFolder(f.getPath());
                        }
                        return file.delete();
                    }
                    return FileUtils.deleteFile(file);
                }
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "deleteFolder", new Object[0]);
            }
        }
        return false;
    }

    public static boolean saveFile(String filePath, byte[] data) {
        return FileUtils.saveFile(FileUtils.getFile(filePath), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFile(File file, byte[] data) {
        if (file != null && data != null) {
            boolean bl;
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            try {
                FileUtils.createFolder(FileUtils.getDirName(file));
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(data);
                bl = true;
            }
            catch (Exception e) {
                try {
                    JCLogUtils.eTag(TAG, e, "saveFile", new Object[0]);
                }
                catch (Throwable throwable) {
                    CloseUtils.closeIOQuietly(bos, fos);
                    throw throwable;
                }
                CloseUtils.closeIOQuietly(bos, fos);
            }
            CloseUtils.closeIOQuietly(bos, fos);
            return bl;
        }
        return false;
    }

    public static boolean appendFile(String filePath, byte[] data) {
        return FileUtils.appendFile(FileUtils.getFile(filePath), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean appendFile(File file, byte[] data) {
        boolean bl;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            FileUtils.createFolder(FileUtils.getDirName(file));
            fos = new FileOutputStream(file, true);
            bos = new BufferedOutputStream(fos);
            bos.write(data);
            bl = true;
        }
        catch (Exception e) {
            try {
                JCLogUtils.eTag(TAG, e, "appendFile", new Object[0]);
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(bos, fos);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(bos, fos);
            return false;
        }
        CloseUtils.closeIOQuietly(bos, fos);
        return bl;
    }

    public static byte[] readFileBytes(String filePath) {
        return FileUtils.readFileBytes(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileBytes(File file) {
        if (file != null && file.exists()) {
            byte[] byArray;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                int length = fis.available();
                byte[] buffer = new byte[length];
                fis.read(buffer);
                byArray = buffer;
            }
            catch (Exception e) {
                try {
                    JCLogUtils.eTag(TAG, e, "readFileBytes", new Object[0]);
                }
                catch (Throwable throwable) {
                    CloseUtils.closeIOQuietly(fis);
                    throw throwable;
                }
                CloseUtils.closeIOQuietly(fis);
            }
            CloseUtils.closeIOQuietly(fis);
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileBytes(InputStream inputStream) {
        if (inputStream != null) {
            byte[] byArray;
            try {
                int length = inputStream.available();
                byte[] buffer = new byte[length];
                inputStream.read(buffer);
                byArray = buffer;
            }
            catch (Exception e) {
                try {
                    JCLogUtils.eTag(TAG, e, "readFileBytes", new Object[0]);
                }
                catch (Throwable throwable) {
                    CloseUtils.closeIOQuietly(inputStream);
                    throw throwable;
                }
                CloseUtils.closeIOQuietly(inputStream);
            }
            CloseUtils.closeIOQuietly(inputStream);
            return byArray;
        }
        return null;
    }

    public static String readFile(String filePath) {
        return FileUtils.readFile(FileUtils.getFileByPath(filePath));
    }

    public static String readFile(File file) {
        if (file != null && file.exists()) {
            try {
                return FileUtils.readFile(new FileInputStream(file));
            }
            catch (Exception e) {
                JCLogUtils.eTag(TAG, e, "readFile", new Object[0]);
            }
        }
        return null;
    }

    public static String readFile(InputStream inputStream) {
        return FileUtils.readFile(inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(InputStream inputStream, String encode) {
        if (inputStream != null) {
            String string;
            BufferedReader br = null;
            try {
                String line;
                InputStreamReader isr = encode != null ? new InputStreamReader(inputStream, encode) : new InputStreamReader(inputStream);
                br = new BufferedReader(isr);
                StringBuilder builder = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                }
                string = builder.toString();
            }
            catch (Exception e) {
                try {
                    JCLogUtils.eTag(TAG, e, "readFile", new Object[0]);
                }
                catch (Throwable throwable) {
                    CloseUtils.closeIOQuietly(br);
                    throw throwable;
                }
                CloseUtils.closeIOQuietly(br);
            }
            CloseUtils.closeIOQuietly(br);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean copyFile(InputStream inputStream, String destFilePath, boolean overlay) {
        boolean bl;
        if (inputStream == null || destFilePath == null) {
            return false;
        }
        File destFile = new File(destFilePath);
        if (destFile.isDirectory()) {
            return false;
        }
        if (destFile.exists()) {
            if (!overlay) return false;
            destFile.delete();
        } else if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            return false;
        }
        InputStream is = inputStream;
        FileOutputStream os = null;
        try {
            int len;
            os = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, len);
            }
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                JCLogUtils.eTag(TAG, e, "copyFile", new Object[0]);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(os, is);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(os, is);
            return bl2;
        }
        CloseUtils.closeIOQuietly(os, is);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean copyFile(String srcFilePath, String destFilePath, boolean overlay) {
        boolean bl;
        if (srcFilePath == null || destFilePath == null) {
            return false;
        }
        File srcFile = new File(srcFilePath);
        if (!srcFile.exists()) {
            return false;
        }
        if (!srcFile.isFile()) {
            return false;
        }
        File destFile = new File(destFilePath);
        if (destFile.isDirectory()) {
            return false;
        }
        if (destFile.exists()) {
            if (!overlay) return false;
            new File(destFilePath).delete();
        } else if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            return false;
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int len;
            is = new FileInputStream(srcFile);
            os = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)is).read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, len);
            }
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                JCLogUtils.eTag(TAG, e, "copyFile", new Object[0]);
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtils.closeIOQuietly(os, is);
                throw throwable;
            }
            CloseUtils.closeIOQuietly(os, is);
            return bl2;
        }
        CloseUtils.closeIOQuietly(os, is);
        return bl;
    }

    public static boolean copyFolder(String srcFolderPath, String destFolderPath, boolean overlay) {
        return FileUtils.copyFolder(srcFolderPath, destFolderPath, srcFolderPath, overlay);
    }

    private static boolean copyFolder(String srcFolderPath, String destFolderPath, String sourcePath, boolean overlay) {
        File[] files;
        if (srcFolderPath == null || destFolderPath == null || sourcePath == null) {
            return false;
        }
        File srcFile = new File(srcFolderPath);
        if (!srcFile.exists()) {
            return false;
        }
        if (!srcFile.isDirectory()) {
            return false;
        }
        File destFile = new File(destFolderPath);
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
        if (!destFile.isDirectory()) {
            return false;
        }
        if (srcFile.exists() && (files = srcFile.listFiles()) != null && files.length != 0) {
            for (File file : files) {
                String dealSource;
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    FileUtils.copyFolder(file.getAbsolutePath(), destFolderPath, sourcePath, overlay);
                    continue;
                }
                String filePath = file.getAbsolutePath();
                if (filePath.indexOf(dealSource = new File(sourcePath).getAbsolutePath()) != 0) continue;
                dealSource = filePath.substring(dealSource.length());
                String savePath = new File(destFolderPath, dealSource).getAbsolutePath();
                boolean bl = FileUtils.copyFile(filePath, savePath, overlay);
            }
        }
        return true;
    }

    public static boolean moveFile(String srcFilePath, String destFilePath, boolean overlay) {
        if (FileUtils.copyFile(srcFilePath, destFilePath, overlay)) {
            return FileUtils.deleteFile(srcFilePath);
        }
        return false;
    }

    public static boolean moveFolder(String srcFilePath, String destFilePath, boolean overlay) {
        if (FileUtils.copyFolder(srcFilePath, destFilePath, overlay)) {
            return FileUtils.deleteFolder(srcFilePath);
        }
        return false;
    }

    public static boolean copyOrMoveDir(String srcDirPath, String destDirPath, OnReplaceListener listener, boolean isMove) {
        return FileUtils.copyOrMoveDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath), listener, isMove);
    }

    public static boolean copyOrMoveDir(File srcDir, File destDir, OnReplaceListener listener, boolean isMove) {
        File[] files;
        if (srcDir == null || destDir == null || listener == null) {
            return false;
        }
        String srcPath = srcDir.getPath() + File.separator;
        String destPath = destDir.getPath() + File.separator;
        if (destPath.contains(srcPath)) {
            return false;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        if (destDir.exists()) {
            if (listener.onReplace()) {
                if (!FileUtils.deleteAllInDir(destDir)) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (!FileUtils.createOrExistsDir(destDir)) {
            return false;
        }
        for (File file : files = srcDir.listFiles()) {
            File oneDestFile = new File(destPath + file.getName());
            if (!(file.isFile() ? !FileUtils.copyOrMoveFile(file, oneDestFile, listener, isMove) : file.isDirectory() && !FileUtils.copyOrMoveDir(file, oneDestFile, listener, isMove))) continue;
            return false;
        }
        return !isMove || FileUtils.deleteDir(srcDir);
    }

    public static boolean copyOrMoveFile(String srcFilePath, String destFilePath, OnReplaceListener listener, boolean isMove) {
        return FileUtils.copyOrMoveFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath), listener, isMove);
    }

    public static boolean copyOrMoveFile(File srcFile, File destFile, OnReplaceListener listener, boolean isMove) {
        if (srcFile == null || destFile == null || listener == null) {
            return false;
        }
        if (srcFile.equals(destFile)) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        if (destFile.exists()) {
            if (listener.onReplace()) {
                if (!destFile.delete()) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (!FileUtils.createOrExistsDir(destFile.getParentFile())) {
            return false;
        }
        try {
            return FileIOUtils.writeFileFromIS(destFile, (InputStream)new FileInputStream(srcFile), false) && (!isMove || FileUtils.deleteFile(srcFile));
        }
        catch (FileNotFoundException e) {
            JCLogUtils.eTag(TAG, e, "copyOrMoveFile", new Object[0]);
            return false;
        }
    }

    public static boolean copyDir(String srcDirPath, String destDirPath, OnReplaceListener listener) {
        return FileUtils.copyDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath), listener);
    }

    public static boolean copyDir(File srcDir, File destDir, OnReplaceListener listener) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, listener, false);
    }

    public static boolean copyFile(String srcFilePath, String destFilePath, OnReplaceListener listener) {
        return FileUtils.copyFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath), listener);
    }

    public static boolean copyFile(File srcFile, File destFile, OnReplaceListener listener) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, listener, false);
    }

    public static boolean moveDir(String srcDirPath, String destDirPath, OnReplaceListener listener) {
        return FileUtils.moveDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath), listener);
    }

    public static boolean moveDir(File srcDir, File destDir, OnReplaceListener listener) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, listener, true);
    }

    public static boolean moveFile(String srcFilePath, String destFilePath, OnReplaceListener listener) {
        return FileUtils.moveFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath), listener);
    }

    public static boolean moveFile(File srcFile, File destFile, OnReplaceListener listener) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, listener, true);
    }

    public static boolean deleteDir(String dirPath) {
        return FileUtils.deleteDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteAllInDir(String dirPath) {
        return FileUtils.deleteAllInDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteAllInDir(File dir) {
        return FileUtils.deleteFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        });
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return FileUtils.deleteFilesInDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteFilesInDir(File dir) {
        return FileUtils.deleteFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
    }

    public static boolean deleteFilesInDirWithFilter(String dirPath, FileFilter filter) {
        return FileUtils.deleteFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter);
    }

    public static boolean deleteFilesInDirWithFilter(File dir, FileFilter filter) {
        if (filter == null) {
            return false;
        }
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!filter.accept(file) || !(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<File> listFilesInDir(String dirPath) {
        return FileUtils.listFilesInDir(dirPath, false);
    }

    public static List<File> listFilesInDir(File dir) {
        return FileUtils.listFilesInDir(dir, false);
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(dirPath), isRecursive);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        }, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FileFilter filter) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, false);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FileFilter filter) {
        return FileUtils.listFilesInDirWithFilter(dir, filter, false);
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FileFilter filter, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FileFilter filter, boolean isRecursive) {
        if (!FileUtils.isDirectory(dir) || filter == null) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (filter.accept(file)) {
                    list.add(file);
                }
                if (!isRecursive || !file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDirWithFilter(file, filter, true));
            }
        }
        return list;
    }

    public static List<FileList> listFilesInDirBean(String dirPath) {
        return FileUtils.listFilesInDirBean(dirPath, false);
    }

    public static List<FileList> listFilesInDirBean(File dir) {
        return FileUtils.listFilesInDirBean(dir, false);
    }

    public static List<FileList> listFilesInDirBean(String dirPath, boolean isRecursive) {
        return FileUtils.listFilesInDirBean(FileUtils.getFileByPath(dirPath), isRecursive);
    }

    public static List<FileList> listFilesInDirBean(File dir, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilterBean(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        }, isRecursive);
    }

    public static List<FileList> listFilesInDirWithFilterBean(String dirPath, FileFilter filter) {
        return FileUtils.listFilesInDirWithFilterBean(FileUtils.getFileByPath(dirPath), filter, false);
    }

    public static List<FileList> listFilesInDirWithFilterBean(File dir, FileFilter filter) {
        return FileUtils.listFilesInDirWithFilterBean(dir, filter, false);
    }

    public static List<FileList> listFilesInDirWithFilterBean(String dirPath, FileFilter filter, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilterBean(FileUtils.getFileByPath(dirPath), filter, isRecursive);
    }

    public static List<FileList> listFilesInDirWithFilterBean(File dir, FileFilter filter, boolean isRecursive) {
        if (!FileUtils.isDirectory(dir) || filter == null) {
            return null;
        }
        ArrayList<FileList> list = new ArrayList<FileList>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                FileList fileList;
                if (!filter.accept(file)) continue;
                if (isRecursive && file.isDirectory()) {
                    List<FileList> subs = FileUtils.listFilesInDirWithFilterBean(file, filter, true);
                    fileList = new FileList(file, subs);
                } else {
                    fileList = new FileList(file);
                }
                list.add(fileList);
            }
        }
        return list;
    }

    public static boolean isImageFormats(File file) {
        return file != null && FileUtils.isImageFormats(file.getPath(), IMAGE_FORMATS);
    }

    public static boolean isImageFormats(String filePath) {
        return FileUtils.isImageFormats(filePath, IMAGE_FORMATS);
    }

    public static boolean isImageFormats(String filePath, String[] fileFormats) {
        return FileUtils.isFileFormats(filePath, fileFormats);
    }

    public static boolean isAudioFormats(File file) {
        return file != null && FileUtils.isAudioFormats(file.getPath(), AUDIO_FORMATS);
    }

    public static boolean isAudioFormats(String filePath) {
        return FileUtils.isAudioFormats(filePath, AUDIO_FORMATS);
    }

    public static boolean isAudioFormats(String filePath, String[] fileFormats) {
        return FileUtils.isFileFormats(filePath, fileFormats);
    }

    public static boolean isVideoFormats(File file) {
        return file != null && FileUtils.isVideoFormats(file.getPath(), VIDEO_FORMATS);
    }

    public static boolean isVideoFormats(String filePath) {
        return FileUtils.isVideoFormats(filePath, VIDEO_FORMATS);
    }

    public static boolean isVideoFormats(String filePath, String[] fileFormats) {
        return FileUtils.isFileFormats(filePath, fileFormats);
    }

    public static boolean isFileFormats(File file, String[] fileFormats) {
        return file != null && FileUtils.isFileFormats(file.getPath(), fileFormats);
    }

    public static boolean isFileFormats(String filePath, String[] fileFormats) {
        if (filePath == null || fileFormats == null || fileFormats.length == 0) {
            return false;
        }
        String path = filePath.toUpperCase();
        for (String format : fileFormats) {
            if (format == null || !path.endsWith(format.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static byte[] getFileMD5(String filePath) {
        return MD5Utils.getFileMD5(filePath);
    }

    public static String getFileMD5ToHexString(String filePath) {
        return MD5Utils.getFileMD5ToHexString(filePath);
    }

    public static String getFileMD5ToHexString(File file) {
        return MD5Utils.getFileMD5ToHexString(file);
    }

    public static byte[] getFileMD5(File file) {
        return MD5Utils.getFileMD5(file);
    }

    public static class FileList {
        private final File mFile;
        private final List<FileList> mSubFiles;

        public FileList(File file) {
            this(file, new ArrayList<FileList>(0));
        }

        public FileList(File file, List<FileList> lists) {
            this.mFile = file;
            this.mSubFiles = lists;
        }

        public File getFile() {
            return this.mFile;
        }

        public List<FileList> getSubFiles() {
            return this.mSubFiles;
        }
    }

    public static interface OnReplaceListener {
        public boolean onReplace();
    }
}

