/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.DevFinal;
import dev.utils.common.DateUtils;
import dev.utils.common.FileUtils;
import dev.utils.common.StringUtils;
import dev.utils.common.ThrowableUtils;
import java.io.File;

public final class FileRecordUtils {
    private static String INSERT_INFO = null;
    private static Callback RECORD_CALLBACK = null;

    private FileRecordUtils() {
    }

    public static void setInsertInfo(String insertInfo) {
        INSERT_INFO = insertInfo;
    }

    public static void setCallback(Callback callback) {
        RECORD_CALLBACK = callback;
    }

    public static boolean saveErrorLog(Throwable ex, String filePath, String fileName) {
        return FileRecordUtils.saveErrorLog(ex, filePath, fileName, null, null, true);
    }

    public static boolean saveErrorLog(Throwable ex, String filePath, String fileName, String head, String bottom) {
        return FileRecordUtils.saveErrorLog(ex, filePath, fileName, head, bottom, true);
    }

    public static boolean saveErrorLog(Throwable ex, String filePath, String fileName, boolean printInsertInfo) {
        return FileRecordUtils.saveErrorLog(ex, filePath, fileName, null, null, printInsertInfo);
    }

    public static boolean saveErrorLog(Throwable ex, String filePath, String fileName, String head, String bottom, boolean printInsertInfo) {
        return FileRecordUtils.saveLog(ThrowableUtils.getThrowableStackTrace(ex, "failed to get exception information"), filePath, fileName, head, bottom, printInsertInfo);
    }

    public static boolean saveLog(String log, String filePath, String fileName) {
        return FileRecordUtils.saveLog(log, filePath, fileName, null, null, true);
    }

    public static boolean saveLog(String log, String filePath, String fileName, String head, String bottom) {
        return FileRecordUtils.saveLog(log, filePath, fileName, head, bottom, true);
    }

    public static boolean saveLog(String log, String filePath, String fileName, boolean printInsertInfo) {
        return FileRecordUtils.saveLog(log, filePath, fileName, null, null, printInsertInfo);
    }

    public static boolean saveLog(String log, String filePath, String fileName, String head, String bottom, boolean printInsertInfo) {
        StringBuilder builder = new StringBuilder();
        builder.append(DevFinal.NEW_LINE_STR_X2);
        builder.append("date: ").append(DateUtils.getDateNow());
        builder.append(DevFinal.NEW_LINE_STR_X2);
        builder.append("===========================");
        if (!StringUtils.isEmpty(head)) {
            builder.append(DevFinal.NEW_LINE_STR_X2);
            builder.append(head);
            builder.append(DevFinal.NEW_LINE_STR_X2);
            builder.append("===========================");
        }
        if (printInsertInfo && !StringUtils.isEmpty(INSERT_INFO)) {
            builder.append(DevFinal.NEW_LINE_STR_X2);
            builder.append(INSERT_INFO);
            builder.append(DevFinal.NEW_LINE_STR_X2);
            builder.append("===========================");
        }
        builder.append(DevFinal.NEW_LINE_STR_X2);
        builder.append(log);
        builder.append(DevFinal.NEW_LINE_STR_X2);
        if (!StringUtils.isEmpty(bottom)) {
            builder.append("===========================");
            builder.append(DevFinal.NEW_LINE_STR_X2);
            builder.append(bottom);
            builder.append(DevFinal.NEW_LINE_STR_X2);
        }
        File file = FileUtils.getFile(filePath, fileName);
        String content = builder.toString();
        boolean result = FileUtils.saveFile(file, StringUtils.getBytes(content));
        if (RECORD_CALLBACK != null) {
            RECORD_CALLBACK.callback(result, log, filePath, fileName, head, bottom, printInsertInfo, INSERT_INFO);
        }
        return result;
    }

    public static interface Callback {
        public void callback(boolean var1, String var2, String var3, String var4, String var5, String var6, boolean var7, String var8);
    }
}

