/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.JCLogUtils;
import dev.utils.common.CloseUtils;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class ThrowableUtils {
    private static final String TAG = ThrowableUtils.class.getSimpleName();

    private ThrowableUtils() {
    }

    public static String getThrowable(Throwable throwable) {
        return ThrowableUtils.getThrowable(throwable, "error(null)");
    }

    public static String getThrowable(Throwable throwable, String errorInfo) {
        if (throwable != null) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                return cause.toString();
            }
            return throwable.toString();
        }
        return errorInfo;
    }

    public static String getThrowableStackTrace(Throwable throwable) {
        return ThrowableUtils.getThrowableStackTrace(throwable, "error(null)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getThrowableStackTrace(Throwable throwable, String errorInfo) {
        if (throwable != null) {
            String string;
            PrintWriter printWriter = null;
            try {
                StringWriter writer = new StringWriter();
                printWriter = new PrintWriter(writer);
                throwable.printStackTrace(printWriter);
                string = ((Object)writer).toString();
            }
            catch (Exception e) {
                String string2;
                try {
                    JCLogUtils.eTag(TAG, e, "getThrowableStackTrace", new Object[0]);
                    string2 = e.toString();
                }
                catch (Throwable throwable2) {
                    CloseUtils.closeIOQuietly(printWriter);
                    throw throwable2;
                }
                CloseUtils.closeIOQuietly(printWriter);
                return string2;
            }
            CloseUtils.closeIOQuietly(printWriter);
            return string;
        }
        return errorInfo;
    }
}

