/*
 * Decompiled with CFR 0.152.
 */
package dev.utils.common;

import dev.utils.common.ConvertUtils;
import dev.utils.common.cipher.Base64;

public final class EncodeUtils {
    private EncodeUtils() {
    }

    public static byte[] base64Encode(String input) {
        return EncodeUtils.base64Encode(input, 2);
    }

    public static byte[] base64Encode(String input, int flags) {
        return EncodeUtils.base64Encode(ConvertUtils.toBytes(input), flags);
    }

    public static byte[] base64Encode(byte[] input) {
        return EncodeUtils.base64Encode(input, 2);
    }

    public static byte[] base64Encode(byte[] input, int flags) {
        if (input == null) {
            return null;
        }
        return Base64.encode(input, flags);
    }

    public static String base64EncodeToString(String input) {
        return EncodeUtils.base64EncodeToString(input, 2);
    }

    public static String base64EncodeToString(String input, int flags) {
        return EncodeUtils.base64EncodeToString(ConvertUtils.toBytes(input), flags);
    }

    public static String base64EncodeToString(byte[] input) {
        return EncodeUtils.base64EncodeToString(input, 2);
    }

    public static String base64EncodeToString(byte[] input, int flags) {
        if (input == null) {
            return null;
        }
        return ConvertUtils.newString(Base64.encode(input, flags));
    }

    public static byte[] base64Decode(String input) {
        return EncodeUtils.base64Decode(input, 2);
    }

    public static byte[] base64Decode(String input, int flags) {
        return EncodeUtils.base64Decode(ConvertUtils.toBytes(input), flags);
    }

    public static byte[] base64Decode(byte[] input) {
        return EncodeUtils.base64Decode(input, 2);
    }

    public static byte[] base64Decode(byte[] input, int flags) {
        if (input == null) {
            return null;
        }
        return Base64.decode(input, flags);
    }

    public static String base64DecodeToString(String input) {
        return EncodeUtils.base64DecodeToString(input, 2);
    }

    public static String base64DecodeToString(String input, int flags) {
        return EncodeUtils.base64DecodeToString(ConvertUtils.toBytes(input), flags);
    }

    public static String base64DecodeToString(byte[] input) {
        return EncodeUtils.base64DecodeToString(input, 2);
    }

    public static String base64DecodeToString(byte[] input, int flags) {
        if (input == null) {
            return null;
        }
        return ConvertUtils.newString(Base64.decode(input, flags));
    }

    public static String htmlEncode(CharSequence input) {
        if (input == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int len = input.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case '<': {
                    builder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    builder.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    builder.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    builder.append("&quot;");
                    continue block7;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        return builder.toString();
    }
}

